<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Spend_Authorization_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Expense Payee for Spend Authorization must be an Employee, Contingent Worker, or External Committee Member. | The Web Service is set to Add Only; documents cannot be resubmitted. | Element containing Spend Authorization reference for
 * update and all Spend Authorization data items
 * @subpackage Structs
 */
class Submit_Spend_Authorization_RequestType extends AbstractStructBase
{
    /**
     * The Spend_Authorization_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Authorization for update only purposes
     * - minOccurs: 0
     * @var \StructType\Spend_AuthorizationObjectType
     */
    public $Spend_Authorization_Reference;
    /**
     * The Business_Process_Parameters
     * Meta information extracted from the WSDL
     * - documentation: Business Process Parameters provide the ability to auto-submit to the business process.
     * - minOccurs: 0
     * @var \StructType\Financials_Business_Process_ParametersType
     */
    public $Business_Process_Parameters;
    /**
     * The Spend_Authorization_Data
     * Meta information extracted from the WSDL
     * - documentation: Spend Authorization Data
     * @var \StructType\Spend_Authorization_DataType
     */
    public $Spend_Authorization_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Submit_Spend_Authorization_RequestType
     * @uses Submit_Spend_Authorization_RequestType::setSpend_Authorization_Reference()
     * @uses Submit_Spend_Authorization_RequestType::setBusiness_Process_Parameters()
     * @uses Submit_Spend_Authorization_RequestType::setSpend_Authorization_Data()
     * @uses Submit_Spend_Authorization_RequestType::setAdd_Only()
     * @uses Submit_Spend_Authorization_RequestType::setVersion()
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @param \StructType\Spend_Authorization_DataType $spend_Authorization_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null, \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null, \StructType\Spend_Authorization_DataType $spend_Authorization_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setSpend_Authorization_Reference($spend_Authorization_Reference)
            ->setBusiness_Process_Parameters($business_Process_Parameters)
            ->setSpend_Authorization_Data($spend_Authorization_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Spend_Authorization_Reference value
     * @return \StructType\Spend_AuthorizationObjectType|null
     */
    public function getSpend_Authorization_Reference()
    {
        return $this->Spend_Authorization_Reference;
    }
    /**
     * Set Spend_Authorization_Reference value
     * @param \StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference
     * @return \StructType\Submit_Spend_Authorization_RequestType
     */
    public function setSpend_Authorization_Reference(\StructType\Spend_AuthorizationObjectType $spend_Authorization_Reference = null)
    {
        $this->Spend_Authorization_Reference = $spend_Authorization_Reference;
        return $this;
    }
    /**
     * Get Business_Process_Parameters value
     * @return \StructType\Financials_Business_Process_ParametersType|null
     */
    public function getBusiness_Process_Parameters()
    {
        return $this->Business_Process_Parameters;
    }
    /**
     * Set Business_Process_Parameters value
     * @param \StructType\Financials_Business_Process_ParametersType $business_Process_Parameters
     * @return \StructType\Submit_Spend_Authorization_RequestType
     */
    public function setBusiness_Process_Parameters(\StructType\Financials_Business_Process_ParametersType $business_Process_Parameters = null)
    {
        $this->Business_Process_Parameters = $business_Process_Parameters;
        return $this;
    }
    /**
     * Get Spend_Authorization_Data value
     * @return \StructType\Spend_Authorization_DataType|null
     */
    public function getSpend_Authorization_Data()
    {
        return $this->Spend_Authorization_Data;
    }
    /**
     * Set Spend_Authorization_Data value
     * @param \StructType\Spend_Authorization_DataType $spend_Authorization_Data
     * @return \StructType\Submit_Spend_Authorization_RequestType
     */
    public function setSpend_Authorization_Data(\StructType\Spend_Authorization_DataType $spend_Authorization_Data = null)
    {
        $this->Spend_Authorization_Data = $spend_Authorization_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Submit_Spend_Authorization_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Submit_Spend_Authorization_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
