<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Submit_Return_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Enter a valid Return Ship-To Address Reference | Enter a positive amount for Restocking fee | Company on Return does not match company hierarchy on referenced supplier contract. | Company on Return is a required field for returns for
 * supplier contracts associated with a company hierarchy. | The Purchase Order or the Supplier Contract submitted to Return is Pending Close and you cannot create a Return against a document Pending Close. | The Supplier Invoice must be referenced by
 * the Purchase Order or Supplier Contract submitted for the Return. | The Supplier Contract submitted to Return is Terminated and you cannot Return a Terminated Contract. | The Purchase Order or the Supplier Contract submitted to Return is Closed and
 * you cannot Return a Closed Document. | The Purchase Order or the Supplier Contract submitted to Return is Canceled and you cannot Return a Canceled Document. | The Purchase Order Lines or Supplier Contract Lines submitted to be returned must be for
 * the same Purchase Order or Supplier Contract. | Return Data
 * @subpackage Structs
 */
class Submit_Return_DataType extends AbstractStructBase
{
    /**
     * The Return_ID
     * Meta information extracted from the WSDL
     * - documentation: Return ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Return_ID;
    /**
     * The Submit
     * Meta information extracted from the WSDL
     * - documentation: Submit for Approval is a boolean flag indicating if the transaction is to be submitted or saved in draft mode. If this flag is set, the transaction will be submitted, otherwise the transaction is saved in draft.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Submit;
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Company_Reference;
    /**
     * The Return_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Return Reason
     * @var \StructType\Return_to_Supplier_ReasonObjectType
     */
    public $Return_Reason_Reference;
    /**
     * The Return_Date
     * Meta information extracted from the WSDL
     * - documentation: Return Date
     * - maxOccurs: 1
     * @var string
     */
    public $Return_Date;
    /**
     * The Supplier_Invoice_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of a Supplier Invoice to relate to the Return. If the Return Reason creates Supplier Invoice Adjustments this is the Supplier Invoice that will be used.
     * - minOccurs: 0
     * @var \StructType\Supplier_InvoiceObjectType
     */
    public $Supplier_Invoice_Reference;
    /**
     * The Supplier_RMA
     * Meta information extracted from the WSDL
     * - documentation: Supplier RMA
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_RMA;
    /**
     * The Restocking_Fee_Amount
     * Meta information extracted from the WSDL
     * - documentation: Restocking Fee Amount for Return to Supplier
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Restocking_Fee_Amount;
    /**
     * The Return_Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Return Ship-To Address
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Return_Ship_To_Address_Reference;
    /**
     * The Pick_Up_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Pick Up Location
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Pick_Up_Location_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Header Level Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Item_Return_Line_Replacement_Data
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Line References must be unique. Cannot use the same Supplier Contract Line on one Return. | Purchase Order Line References must be unique. Cannot use the same Purchase Order Line on one Return.
     * - maxOccurs: unbounded
     * @var \StructType\Item_Return_Line_Replacement_DataType[]
     */
    public $Item_Return_Line_Replacement_Data;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_with_Attachment_Category_DataType[]
     */
    public $Attachment_Data;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * Constructor method for Submit_Return_DataType
     * @uses Submit_Return_DataType::setReturn_ID()
     * @uses Submit_Return_DataType::setSubmit()
     * @uses Submit_Return_DataType::setCompany_Reference()
     * @uses Submit_Return_DataType::setReturn_Reason_Reference()
     * @uses Submit_Return_DataType::setReturn_Date()
     * @uses Submit_Return_DataType::setSupplier_Invoice_Reference()
     * @uses Submit_Return_DataType::setSupplier_RMA()
     * @uses Submit_Return_DataType::setRestocking_Fee_Amount()
     * @uses Submit_Return_DataType::setReturn_Ship_To_Address_Reference()
     * @uses Submit_Return_DataType::setPick_Up_Location_Reference()
     * @uses Submit_Return_DataType::setMemo()
     * @uses Submit_Return_DataType::setItem_Return_Line_Replacement_Data()
     * @uses Submit_Return_DataType::setAttachment_Data()
     * @uses Submit_Return_DataType::setCurrency_Reference()
     * @param string $return_ID
     * @param bool $submit
     * @param \StructType\CompanyObjectType $company_Reference
     * @param \StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference
     * @param string $return_Date
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @param string $supplier_RMA
     * @param float $restocking_Fee_Amount
     * @param \StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference
     * @param \StructType\LocationObjectType $pick_Up_Location_Reference
     * @param string $memo
     * @param \StructType\Item_Return_Line_Replacement_DataType[] $item_Return_Line_Replacement_Data
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @param \StructType\CurrencyObjectType $currency_Reference
     */
    public function __construct($return_ID = null, $submit = null, \StructType\CompanyObjectType $company_Reference = null, \StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference = null, $return_Date = null, \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null, $supplier_RMA = null, $restocking_Fee_Amount = null, \StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference = null, \StructType\LocationObjectType $pick_Up_Location_Reference = null, $memo = null, array $item_Return_Line_Replacement_Data = array(), array $attachment_Data = array(), \StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this
            ->setReturn_ID($return_ID)
            ->setSubmit($submit)
            ->setCompany_Reference($company_Reference)
            ->setReturn_Reason_Reference($return_Reason_Reference)
            ->setReturn_Date($return_Date)
            ->setSupplier_Invoice_Reference($supplier_Invoice_Reference)
            ->setSupplier_RMA($supplier_RMA)
            ->setRestocking_Fee_Amount($restocking_Fee_Amount)
            ->setReturn_Ship_To_Address_Reference($return_Ship_To_Address_Reference)
            ->setPick_Up_Location_Reference($pick_Up_Location_Reference)
            ->setMemo($memo)
            ->setItem_Return_Line_Replacement_Data($item_Return_Line_Replacement_Data)
            ->setAttachment_Data($attachment_Data)
            ->setCurrency_Reference($currency_Reference);
    }
    /**
     * Get Return_ID value
     * @return string|null
     */
    public function getReturn_ID()
    {
        return $this->Return_ID;
    }
    /**
     * Set Return_ID value
     * @param string $return_ID
     * @return \StructType\Submit_Return_DataType
     */
    public function setReturn_ID($return_ID = null)
    {
        // validation for constraint: string
        if (!is_null($return_ID) && !is_string($return_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_ID, true), gettype($return_ID)), __LINE__);
        }
        $this->Return_ID = $return_ID;
        return $this;
    }
    /**
     * Get Submit value
     * @return bool|null
     */
    public function getSubmit()
    {
        return $this->Submit;
    }
    /**
     * Set Submit value
     * @param bool $submit
     * @return \StructType\Submit_Return_DataType
     */
    public function setSubmit($submit = null)
    {
        // validation for constraint: boolean
        if (!is_null($submit) && !is_bool($submit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($submit, true), gettype($submit)), __LINE__);
        }
        $this->Submit = $submit;
        return $this;
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * Set Company_Reference value
     * @param \StructType\CompanyObjectType $company_Reference
     * @return \StructType\Submit_Return_DataType
     */
    public function setCompany_Reference(\StructType\CompanyObjectType $company_Reference = null)
    {
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Get Return_Reason_Reference value
     * @return \StructType\Return_to_Supplier_ReasonObjectType|null
     */
    public function getReturn_Reason_Reference()
    {
        return $this->Return_Reason_Reference;
    }
    /**
     * Set Return_Reason_Reference value
     * @param \StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference
     * @return \StructType\Submit_Return_DataType
     */
    public function setReturn_Reason_Reference(\StructType\Return_to_Supplier_ReasonObjectType $return_Reason_Reference = null)
    {
        $this->Return_Reason_Reference = $return_Reason_Reference;
        return $this;
    }
    /**
     * Get Return_Date value
     * @return string|null
     */
    public function getReturn_Date()
    {
        return $this->Return_Date;
    }
    /**
     * Set Return_Date value
     * @param string $return_Date
     * @return \StructType\Submit_Return_DataType
     */
    public function setReturn_Date($return_Date = null)
    {
        // validation for constraint: string
        if (!is_null($return_Date) && !is_string($return_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($return_Date, true), gettype($return_Date)), __LINE__);
        }
        $this->Return_Date = $return_Date;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Reference value
     * @return \StructType\Supplier_InvoiceObjectType|null
     */
    public function getSupplier_Invoice_Reference()
    {
        return $this->Supplier_Invoice_Reference;
    }
    /**
     * Set Supplier_Invoice_Reference value
     * @param \StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference
     * @return \StructType\Submit_Return_DataType
     */
    public function setSupplier_Invoice_Reference(\StructType\Supplier_InvoiceObjectType $supplier_Invoice_Reference = null)
    {
        $this->Supplier_Invoice_Reference = $supplier_Invoice_Reference;
        return $this;
    }
    /**
     * Get Supplier_RMA value
     * @return string|null
     */
    public function getSupplier_RMA()
    {
        return $this->Supplier_RMA;
    }
    /**
     * Set Supplier_RMA value
     * @param string $supplier_RMA
     * @return \StructType\Submit_Return_DataType
     */
    public function setSupplier_RMA($supplier_RMA = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_RMA) && !is_string($supplier_RMA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_RMA, true), gettype($supplier_RMA)), __LINE__);
        }
        $this->Supplier_RMA = $supplier_RMA;
        return $this;
    }
    /**
     * Get Restocking_Fee_Amount value
     * @return float|null
     */
    public function getRestocking_Fee_Amount()
    {
        return $this->Restocking_Fee_Amount;
    }
    /**
     * Set Restocking_Fee_Amount value
     * @param float $restocking_Fee_Amount
     * @return \StructType\Submit_Return_DataType
     */
    public function setRestocking_Fee_Amount($restocking_Fee_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($restocking_Fee_Amount) && !(is_float($restocking_Fee_Amount) || is_numeric($restocking_Fee_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($restocking_Fee_Amount, true), gettype($restocking_Fee_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($restocking_Fee_Amount) && mb_strlen(mb_substr($restocking_Fee_Amount, false !== mb_strpos($restocking_Fee_Amount, '.') ? mb_strpos($restocking_Fee_Amount, '.') + 1 : mb_strlen($restocking_Fee_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($restocking_Fee_Amount, true), mb_strlen(mb_substr($restocking_Fee_Amount, mb_strpos($restocking_Fee_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($restocking_Fee_Amount) && mb_strlen(preg_replace('/(\D)/', '', $restocking_Fee_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($restocking_Fee_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $restocking_Fee_Amount))), __LINE__);
        }
        $this->Restocking_Fee_Amount = $restocking_Fee_Amount;
        return $this;
    }
    /**
     * Get Return_Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReturn_Ship_To_Address_Reference()
    {
        return $this->{'Return_Ship-To_Address_Reference'};
    }
    /**
     * Set Return_Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference
     * @return \StructType\Submit_Return_DataType
     */
    public function setReturn_Ship_To_Address_Reference(\StructType\Unique_IdentifierObjectType $return_Ship_To_Address_Reference = null)
    {
        $this->Return_Ship_To_Address_Reference = $this->{'Return_Ship-To_Address_Reference'} = $return_Ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Pick_Up_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getPick_Up_Location_Reference()
    {
        return $this->Pick_Up_Location_Reference;
    }
    /**
     * Set Pick_Up_Location_Reference value
     * @param \StructType\LocationObjectType $pick_Up_Location_Reference
     * @return \StructType\Submit_Return_DataType
     */
    public function setPick_Up_Location_Reference(\StructType\LocationObjectType $pick_Up_Location_Reference = null)
    {
        $this->Pick_Up_Location_Reference = $pick_Up_Location_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Submit_Return_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Item_Return_Line_Replacement_Data value
     * @return \StructType\Item_Return_Line_Replacement_DataType[]|null
     */
    public function getItem_Return_Line_Replacement_Data()
    {
        return $this->Item_Return_Line_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Return_Line_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Return_Line_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Return_Line_Replacement_DataForArrayConstraintsFromSetItem_Return_Line_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Return_DataTypeItem_Return_Line_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Return_DataTypeItem_Return_Line_Replacement_DataItem instanceof \StructType\Item_Return_Line_Replacement_DataType) {
                $invalidValues[] = is_object($submit_Return_DataTypeItem_Return_Line_Replacement_DataItem) ? get_class($submit_Return_DataTypeItem_Return_Line_Replacement_DataItem) : sprintf('%s(%s)', gettype($submit_Return_DataTypeItem_Return_Line_Replacement_DataItem), var_export($submit_Return_DataTypeItem_Return_Line_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Return_Line_Replacement_Data property can only contain items of type \StructType\Item_Return_Line_Replacement_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Return_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Return_Line_Replacement_DataType[] $item_Return_Line_Replacement_Data
     * @return \StructType\Submit_Return_DataType
     */
    public function setItem_Return_Line_Replacement_Data(array $item_Return_Line_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Return_Line_Replacement_DataArrayErrorMessage = self::validateItem_Return_Line_Replacement_DataForArrayConstraintsFromSetItem_Return_Line_Replacement_Data($item_Return_Line_Replacement_Data))) {
            throw new \InvalidArgumentException($item_Return_Line_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Item_Return_Line_Replacement_Data = $item_Return_Line_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Item_Return_Line_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_Return_Line_Replacement_DataType $item
     * @return \StructType\Submit_Return_DataType
     */
    public function addToItem_Return_Line_Replacement_Data(\StructType\Item_Return_Line_Replacement_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_Return_Line_Replacement_DataType) {
            throw new \InvalidArgumentException(sprintf('The Item_Return_Line_Replacement_Data property can only contain items of type \StructType\Item_Return_Line_Replacement_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Return_Line_Replacement_Data[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_with_Attachment_Category_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $submit_Return_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$submit_Return_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
                $invalidValues[] = is_object($submit_Return_DataTypeAttachment_DataItem) ? get_class($submit_Return_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($submit_Return_DataTypeAttachment_DataItem), var_export($submit_Return_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType[] $attachment_Data
     * @return \StructType\Submit_Return_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_with_Attachment_Category_DataType $item
     * @return \StructType\Submit_Return_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_with_Attachment_Category_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_with_Attachment_Category_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_with_Attachment_Category_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Submit_Return_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
}
