<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Spend_Category_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Spend Category
 * @subpackage Structs
 */
class Spend_Category_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Resource_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Spend Category
     * - maxOccurs: unbounded
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Resource_Category_Reference;
    /**
     * Constructor method for Spend_Category_Request_ReferencesType
     * @uses Spend_Category_Request_ReferencesType::setResource_Category_Reference()
     * @param \StructType\Spend_CategoryObjectType[] $resource_Category_Reference
     */
    public function __construct(array $resource_Category_Reference = array())
    {
        $this
            ->setResource_Category_Reference($resource_Category_Reference);
    }
    /**
     * Get Resource_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getResource_Category_Reference()
    {
        return $this->Resource_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Category_ReferenceForArrayConstraintsFromSetResource_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $spend_Category_Request_ReferencesTypeResource_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$spend_Category_Request_ReferencesTypeResource_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($spend_Category_Request_ReferencesTypeResource_Category_ReferenceItem) ? get_class($spend_Category_Request_ReferencesTypeResource_Category_ReferenceItem) : sprintf('%s(%s)', gettype($spend_Category_Request_ReferencesTypeResource_Category_ReferenceItem), var_export($spend_Category_Request_ReferencesTypeResource_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $resource_Category_Reference
     * @return \StructType\Spend_Category_Request_ReferencesType
     */
    public function setResource_Category_Reference(array $resource_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Category_ReferenceArrayErrorMessage = self::validateResource_Category_ReferenceForArrayConstraintsFromSetResource_Category_Reference($resource_Category_Reference))) {
            throw new \InvalidArgumentException($resource_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Resource_Category_Reference = $resource_Category_Reference;
        return $this;
    }
    /**
     * Add item to Resource_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Spend_Category_Request_ReferencesType
     */
    public function addToResource_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Category_Reference[] = $item;
        return $this;
    }
}
