<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Return_to_Supplier_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Return to Supplier Line Data
 * @subpackage Structs
 */
class Return_to_Supplier_Line_DataType extends AbstractStructBase
{
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Line Company for the Return Line
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item for the Return Line
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category for the Return Line
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Packaging_String
     * Meta information extracted from the WSDL
     * - documentation: Packaging String associated with the Item specified on the Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Packaging_String;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure Reference
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Line Memo
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Stocking_Information_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[]
     */
    public $Stocking_Information_Data;
    /**
     * The Return_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Return_Line_Split_Data;
    /**
     * Constructor method for Return_to_Supplier_Line_DataType
     * @uses Return_to_Supplier_Line_DataType::setLine_Company_Reference()
     * @uses Return_to_Supplier_Line_DataType::setItem_Reference()
     * @uses Return_to_Supplier_Line_DataType::setSpend_Category_Reference()
     * @uses Return_to_Supplier_Line_DataType::setPackaging_String()
     * @uses Return_to_Supplier_Line_DataType::setQuantity()
     * @uses Return_to_Supplier_Line_DataType::setUnit_of_Measure_Reference()
     * @uses Return_to_Supplier_Line_DataType::setExtended_Amount()
     * @uses Return_to_Supplier_Line_DataType::setMemo()
     * @uses Return_to_Supplier_Line_DataType::setUnit_Cost()
     * @uses Return_to_Supplier_Line_DataType::setStocking_Information_Data()
     * @uses Return_to_Supplier_Line_DataType::setReturn_Line_Split_Data()
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @param string $packaging_String
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $extended_Amount
     * @param string $memo
     * @param float $unit_Cost
     * @param \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[] $stocking_Information_Data
     * @param \StructType\Business_Document_Line_Split_DataType[] $return_Line_Split_Data
     */
    public function __construct(\StructType\CompanyObjectType $line_Company_Reference = null, \StructType\Item_DescriptorObjectType $item_Reference = null, \StructType\Accounting_CategoryObjectType $spend_Category_Reference = null, $packaging_String = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $extended_Amount = null, $memo = null, $unit_Cost = null, array $stocking_Information_Data = array(), array $return_Line_Split_Data = array())
    {
        $this
            ->setLine_Company_Reference($line_Company_Reference)
            ->setItem_Reference($item_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setPackaging_String($packaging_String)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setExtended_Amount($extended_Amount)
            ->setMemo($memo)
            ->setUnit_Cost($unit_Cost)
            ->setStocking_Information_Data($stocking_Information_Data)
            ->setReturn_Line_Split_Data($return_Line_Split_Data);
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Reference
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setItem_Reference(\StructType\Item_DescriptorObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Accounting_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Packaging_String value
     * @return string|null
     */
    public function getPackaging_String()
    {
        return $this->Packaging_String;
    }
    /**
     * Set Packaging_String value
     * @param string $packaging_String
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setPackaging_String($packaging_String = null)
    {
        // validation for constraint: string
        if (!is_null($packaging_String) && !is_string($packaging_String)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packaging_String, true), gettype($packaging_String)), __LINE__);
        }
        $this->Packaging_String = $packaging_String;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Stocking_Information_Data value
     * @return \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[]|null
     */
    public function getStocking_Information_Data()
    {
        return $this->Stocking_Information_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setStocking_Information_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStocking_Information_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStocking_Information_DataForArrayConstraintsFromSetStocking_Information_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_to_Supplier_Line_DataTypeStocking_Information_DataItem) {
            // validation for constraint: itemType
            if (!$return_to_Supplier_Line_DataTypeStocking_Information_DataItem instanceof \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType) {
                $invalidValues[] = is_object($return_to_Supplier_Line_DataTypeStocking_Information_DataItem) ? get_class($return_to_Supplier_Line_DataTypeStocking_Information_DataItem) : sprintf('%s(%s)', gettype($return_to_Supplier_Line_DataTypeStocking_Information_DataItem), var_export($return_to_Supplier_Line_DataTypeStocking_Information_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Stocking_Information_Data property can only contain items of type \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Stocking_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType[] $stocking_Information_Data
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setStocking_Information_Data(array $stocking_Information_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($stocking_Information_DataArrayErrorMessage = self::validateStocking_Information_DataForArrayConstraintsFromSetStocking_Information_Data($stocking_Information_Data))) {
            throw new \InvalidArgumentException($stocking_Information_DataArrayErrorMessage, __LINE__);
        }
        $this->Stocking_Information_Data = $stocking_Information_Data;
        return $this;
    }
    /**
     * Add item to Stocking_Information_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType $item
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function addToStocking_Information_Data(\StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType) {
            throw new \InvalidArgumentException(sprintf('The Stocking_Information_Data property can only contain items of type \StructType\Return_to_Supplier_Line_Inventory_Location_Quantity_Details_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Stocking_Information_Data[] = $item;
        return $this;
    }
    /**
     * Get Return_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getReturn_Line_Split_Data()
    {
        return $this->Return_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setReturn_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReturn_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReturn_Line_Split_DataForArrayConstraintsFromSetReturn_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $return_to_Supplier_Line_DataTypeReturn_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$return_to_Supplier_Line_DataTypeReturn_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($return_to_Supplier_Line_DataTypeReturn_Line_Split_DataItem) ? get_class($return_to_Supplier_Line_DataTypeReturn_Line_Split_DataItem) : sprintf('%s(%s)', gettype($return_to_Supplier_Line_DataTypeReturn_Line_Split_DataItem), var_export($return_to_Supplier_Line_DataTypeReturn_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Return_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Return_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $return_Line_Split_Data
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function setReturn_Line_Split_Data(array $return_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($return_Line_Split_DataArrayErrorMessage = self::validateReturn_Line_Split_DataForArrayConstraintsFromSetReturn_Line_Split_Data($return_Line_Split_Data))) {
            throw new \InvalidArgumentException($return_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Return_Line_Split_Data = $return_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Return_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Return_to_Supplier_Line_DataType
     */
    public function addToReturn_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Return_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Return_Line_Split_Data[] = $item;
        return $this;
    }
}
