<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resume_Asset_Depreciation_for_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resume Date cannot be earlier than the last depreciation start date for any asset lifecycle event that records depreciation (such as Issue or Transfer). | You cannot resume asset depreciation for a book that is not suspended. |
 * Depreciation has been posted for periods affected by resume date | Cannot resume this asset since it is not in out of service. | Element containing Business Asset data to resume an asset.
 * @subpackage Structs
 */
class Resume_Asset_Depreciation_for_WWS_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: The asset is part of a lease contract. You can't resume depreciation on leased assets. | The Asset one would like to resume depreciation for.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Resume depreciation transaction date is required for all requests.
     * - maxOccurs: 1
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Restricted_to_Books_Reference
     * Meta information extracted from the WSDL
     * - documentation: Resume depreciation restricted to books is required for all requests.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Restricted_to_Books_Reference;
    /**
     * Constructor method for Resume_Asset_Depreciation_for_WWS_DataType
     * @uses Resume_Asset_Depreciation_for_WWS_DataType::setAsset_Reference()
     * @uses Resume_Asset_Depreciation_for_WWS_DataType::setTransaction_Effective_Date()
     * @uses Resume_Asset_Depreciation_for_WWS_DataType::setRestricted_to_Books_Reference()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param string $transaction_Effective_Date
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, $transaction_Effective_Date = null, array $restricted_to_Books_Reference = array())
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setRestricted_to_Books_Reference($restricted_to_Books_Reference);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Resume_Asset_Depreciation_for_WWS_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Resume_Asset_Depreciation_for_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Restricted_to_Books_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getRestricted_to_Books_Reference()
    {
        return $this->Restricted_to_Books_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_to_Books_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_to_Books_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resume_Asset_Depreciation_for_WWS_DataTypeRestricted_to_Books_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resume_Asset_Depreciation_for_WWS_DataTypeRestricted_to_Books_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($resume_Asset_Depreciation_for_WWS_DataTypeRestricted_to_Books_ReferenceItem) ? get_class($resume_Asset_Depreciation_for_WWS_DataTypeRestricted_to_Books_ReferenceItem) : sprintf('%s(%s)', gettype($resume_Asset_Depreciation_for_WWS_DataTypeRestricted_to_Books_ReferenceItem), var_export($resume_Asset_Depreciation_for_WWS_DataTypeRestricted_to_Books_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     * @return \StructType\Resume_Asset_Depreciation_for_WWS_DataType
     */
    public function setRestricted_to_Books_Reference(array $restricted_to_Books_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_to_Books_ReferenceArrayErrorMessage = self::validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference($restricted_to_Books_Reference))) {
            throw new \InvalidArgumentException($restricted_to_Books_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_to_Books_Reference = $restricted_to_Books_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Resume_Asset_Depreciation_for_WWS_DataType
     */
    public function addToRestricted_to_Books_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_to_Books_Reference[] = $item;
        return $this;
    }
}
