<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Pool_Hierarchy_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing request references for a Resource Pool Hierarchy.
 * @subpackage Structs
 */
class Resource_Pool_Hierarchy_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Resource_Pool_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: References for the Resource Pool Hierarchies.
     * - maxOccurs: unbounded
     * @var \StructType\Resource_Pool_HierarchyObjectType[]
     */
    public $Resource_Pool_Hierarchy_Reference;
    /**
     * Constructor method for Resource_Pool_Hierarchy_Request_ReferencesType
     * @uses Resource_Pool_Hierarchy_Request_ReferencesType::setResource_Pool_Hierarchy_Reference()
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $resource_Pool_Hierarchy_Reference
     */
    public function __construct(array $resource_Pool_Hierarchy_Reference = array())
    {
        $this
            ->setResource_Pool_Hierarchy_Reference($resource_Pool_Hierarchy_Reference);
    }
    /**
     * Get Resource_Pool_Hierarchy_Reference value
     * @return \StructType\Resource_Pool_HierarchyObjectType[]|null
     */
    public function getResource_Pool_Hierarchy_Reference()
    {
        return $this->Resource_Pool_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setResource_Pool_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResource_Pool_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResource_Pool_Hierarchy_ReferenceForArrayConstraintsFromSetResource_Pool_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Pool_Hierarchy_Request_ReferencesTypeResource_Pool_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Pool_Hierarchy_Request_ReferencesTypeResource_Pool_Hierarchy_ReferenceItem instanceof \StructType\Resource_Pool_HierarchyObjectType) {
                $invalidValues[] = is_object($resource_Pool_Hierarchy_Request_ReferencesTypeResource_Pool_Hierarchy_ReferenceItem) ? get_class($resource_Pool_Hierarchy_Request_ReferencesTypeResource_Pool_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Pool_Hierarchy_Request_ReferencesTypeResource_Pool_Hierarchy_ReferenceItem), var_export($resource_Pool_Hierarchy_Request_ReferencesTypeResource_Pool_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Resource_Pool_Hierarchy_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Resource_Pool_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType[] $resource_Pool_Hierarchy_Reference
     * @return \StructType\Resource_Pool_Hierarchy_Request_ReferencesType
     */
    public function setResource_Pool_Hierarchy_Reference(array $resource_Pool_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($resource_Pool_Hierarchy_ReferenceArrayErrorMessage = self::validateResource_Pool_Hierarchy_ReferenceForArrayConstraintsFromSetResource_Pool_Hierarchy_Reference($resource_Pool_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($resource_Pool_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Resource_Pool_Hierarchy_Reference = $resource_Pool_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Resource_Pool_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_Pool_HierarchyObjectType $item
     * @return \StructType\Resource_Pool_Hierarchy_Request_ReferencesType
     */
    public function addToResource_Pool_Hierarchy_Reference(\StructType\Resource_Pool_HierarchyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_Pool_HierarchyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Resource_Pool_Hierarchy_Reference property can only contain items of type \StructType\Resource_Pool_HierarchyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Resource_Pool_Hierarchy_Reference[] = $item;
        return $this;
    }
}
