<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Resource_Plan_Requirement_Parameter_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Resource Plan requirement Data sub element
 * @subpackage Structs
 */
class Resource_Plan_Requirement_Parameter_DataType extends AbstractStructBase
{
    /**
     * The Resource_Plan_Line_Requirement_Parameter_ID
     * Meta information extracted from the WSDL
     * - documentation: .
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Resource_Plan_Line_Requirement_Parameter_ID;
    /**
     * The Requirement_Field_Reference
     * Meta information extracted from the WSDL
     * - documentation: .
     * - minOccurs: 0
     * @var \StructType\External_FieldObjectType
     */
    public $Requirement_Field_Reference;
    /**
     * The Requirement_Value_Reference
     * Meta information extracted from the WSDL
     * - documentation: .
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InstanceObjectType[]
     */
    public $Requirement_Value_Reference;
    /**
     * The Optional_Requirement_Indicator
     * Meta information extracted from the WSDL
     * - documentation: Optional Requirement
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Optional_Requirement_Indicator;
    /**
     * The Delete
     * Meta information extracted from the WSDL
     * - documentation: Delete
     * @var bool
     */
    public $Delete;
    /**
     * Constructor method for Resource_Plan_Requirement_Parameter_DataType
     * @uses Resource_Plan_Requirement_Parameter_DataType::setResource_Plan_Line_Requirement_Parameter_ID()
     * @uses Resource_Plan_Requirement_Parameter_DataType::setRequirement_Field_Reference()
     * @uses Resource_Plan_Requirement_Parameter_DataType::setRequirement_Value_Reference()
     * @uses Resource_Plan_Requirement_Parameter_DataType::setOptional_Requirement_Indicator()
     * @uses Resource_Plan_Requirement_Parameter_DataType::setDelete()
     * @param string $resource_Plan_Line_Requirement_Parameter_ID
     * @param \StructType\External_FieldObjectType $requirement_Field_Reference
     * @param \StructType\InstanceObjectType[] $requirement_Value_Reference
     * @param bool $optional_Requirement_Indicator
     * @param bool $delete
     */
    public function __construct($resource_Plan_Line_Requirement_Parameter_ID = null, \StructType\External_FieldObjectType $requirement_Field_Reference = null, array $requirement_Value_Reference = array(), $optional_Requirement_Indicator = null, $delete = null)
    {
        $this
            ->setResource_Plan_Line_Requirement_Parameter_ID($resource_Plan_Line_Requirement_Parameter_ID)
            ->setRequirement_Field_Reference($requirement_Field_Reference)
            ->setRequirement_Value_Reference($requirement_Value_Reference)
            ->setOptional_Requirement_Indicator($optional_Requirement_Indicator)
            ->setDelete($delete);
    }
    /**
     * Get Resource_Plan_Line_Requirement_Parameter_ID value
     * @return string|null
     */
    public function getResource_Plan_Line_Requirement_Parameter_ID()
    {
        return $this->Resource_Plan_Line_Requirement_Parameter_ID;
    }
    /**
     * Set Resource_Plan_Line_Requirement_Parameter_ID value
     * @param string $resource_Plan_Line_Requirement_Parameter_ID
     * @return \StructType\Resource_Plan_Requirement_Parameter_DataType
     */
    public function setResource_Plan_Line_Requirement_Parameter_ID($resource_Plan_Line_Requirement_Parameter_ID = null)
    {
        // validation for constraint: string
        if (!is_null($resource_Plan_Line_Requirement_Parameter_ID) && !is_string($resource_Plan_Line_Requirement_Parameter_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resource_Plan_Line_Requirement_Parameter_ID, true), gettype($resource_Plan_Line_Requirement_Parameter_ID)), __LINE__);
        }
        $this->Resource_Plan_Line_Requirement_Parameter_ID = $resource_Plan_Line_Requirement_Parameter_ID;
        return $this;
    }
    /**
     * Get Requirement_Field_Reference value
     * @return \StructType\External_FieldObjectType|null
     */
    public function getRequirement_Field_Reference()
    {
        return $this->Requirement_Field_Reference;
    }
    /**
     * Set Requirement_Field_Reference value
     * @param \StructType\External_FieldObjectType $requirement_Field_Reference
     * @return \StructType\Resource_Plan_Requirement_Parameter_DataType
     */
    public function setRequirement_Field_Reference(\StructType\External_FieldObjectType $requirement_Field_Reference = null)
    {
        $this->Requirement_Field_Reference = $requirement_Field_Reference;
        return $this;
    }
    /**
     * Get Requirement_Value_Reference value
     * @return \StructType\InstanceObjectType[]|null
     */
    public function getRequirement_Value_Reference()
    {
        return $this->Requirement_Value_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequirement_Value_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequirement_Value_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequirement_Value_ReferenceForArrayConstraintsFromSetRequirement_Value_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $resource_Plan_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem) {
            // validation for constraint: itemType
            if (!$resource_Plan_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem instanceof \StructType\InstanceObjectType) {
                $invalidValues[] = is_object($resource_Plan_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem) ? get_class($resource_Plan_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem) : sprintf('%s(%s)', gettype($resource_Plan_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem), var_export($resource_Plan_Requirement_Parameter_DataTypeRequirement_Value_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requirement_Value_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requirement_Value_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType[] $requirement_Value_Reference
     * @return \StructType\Resource_Plan_Requirement_Parameter_DataType
     */
    public function setRequirement_Value_Reference(array $requirement_Value_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requirement_Value_ReferenceArrayErrorMessage = self::validateRequirement_Value_ReferenceForArrayConstraintsFromSetRequirement_Value_Reference($requirement_Value_Reference))) {
            throw new \InvalidArgumentException($requirement_Value_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requirement_Value_Reference = $requirement_Value_Reference;
        return $this;
    }
    /**
     * Add item to Requirement_Value_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\InstanceObjectType $item
     * @return \StructType\Resource_Plan_Requirement_Parameter_DataType
     */
    public function addToRequirement_Value_Reference(\StructType\InstanceObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InstanceObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requirement_Value_Reference property can only contain items of type \StructType\InstanceObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requirement_Value_Reference[] = $item;
        return $this;
    }
    /**
     * Get Optional_Requirement_Indicator value
     * @return bool|null
     */
    public function getOptional_Requirement_Indicator()
    {
        return $this->Optional_Requirement_Indicator;
    }
    /**
     * Set Optional_Requirement_Indicator value
     * @param bool $optional_Requirement_Indicator
     * @return \StructType\Resource_Plan_Requirement_Parameter_DataType
     */
    public function setOptional_Requirement_Indicator($optional_Requirement_Indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($optional_Requirement_Indicator) && !is_bool($optional_Requirement_Indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($optional_Requirement_Indicator, true), gettype($optional_Requirement_Indicator)), __LINE__);
        }
        $this->Optional_Requirement_Indicator = $optional_Requirement_Indicator;
        return $this;
    }
    /**
     * Get Delete value
     * @return bool|null
     */
    public function getDelete()
    {
        return $this->Delete;
    }
    /**
     * Set Delete value
     * @param bool $delete
     * @return \StructType\Resource_Plan_Requirement_Parameter_DataType
     */
    public function setDelete($delete = null)
    {
        // validation for constraint: boolean
        if (!is_null($delete) && !is_bool($delete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($delete, true), gettype($delete)), __LINE__);
        }
        $this->Delete = $delete;
        return $this;
    }
}
