<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Template_Service_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: You can't select Supplier Contract as a Fulfillment Source on this transaction type. | Only one worktag for each type is allowed for each document line. | Spend Category is required. | Item Description is Required | Element
 * containing all Service Requisition Line data. A Requisition may have multiple service requisition lines.
 * @subpackage Structs
 */
class Requisition_Template_Service_Line_DataType extends AbstractStructBase
{
    /**
     * The Requisition_Template_Service_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Service Requisition Line
     * - minOccurs: 0
     * @var \StructType\Service_Requisition_LineObjectType
     */
    public $Requisition_Template_Service_Line_Reference;
    /**
     * The Line_Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: The company at the line level that has an intercompany relationship with the company at the header level.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Line_Company_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an Item on the Requisition.
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType
     */
    public $Item_Reference;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: An optional description of the item, especially useful if only a Spend Category is selected for this line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Spend Category Usage Type for this Spend Category must be Procurement. | Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend
     * Category for the Purchase Item.
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Fulfillment_Source_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to Fulfilment source on Service Line.This is defaulted to Purchase Order for Service Requisition Lines.
     * - minOccurs: 0
     * @var \StructType\Requisition_SourceObjectType
     */
    public $Fulfillment_Source_Reference;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to an existing Supplier
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType
     */
    public $Supplier_Reference;
    /**
     * The Order_From_Connection_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a valid Order-From Supplier Connection
     * - minOccurs: 0
     * @var \StructType\Order_From_Supplier_ConnectionObjectType
     */
    public $Order_From_Connection_Reference;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Start_Date
     * Meta information extracted from the WSDL
     * - documentation: Start Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Start_Date;
    /**
     * The End_Date
     * Meta information extracted from the WSDL
     * - documentation: End Date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $End_Date;
    /**
     * The Ship_To_Address_Reference
     * Meta information extracted from the WSDL
     * - documentation: Optional Address Reference for an existing Ship-To Address.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Ship_To_Address_Reference;
    /**
     * The Ship_To_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Worker, who will be the designated Ship-To Contact.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Ship_To_Contact_Reference;
    /**
     * The Deliver_To_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Location, where the Goods or Services will be delivered.
     * - minOccurs: 0
     * @var \StructType\LocationObjectType
     */
    public $Deliver_To_Location_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Requisition Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: If Multi-Company is enabled, this validation compares against the Line Company and requires that the line Company is provided when Grant is supplied. | Reference to existing worktags. Worktags are a way to mark tasks and business
     * objects to make them easier to access and summarize. Each transaction can include one value for each worktag type and is subject to configurable validation when submitted for approval.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Requisition_Template_Service_Line_Split_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Business_Document_Line_Split_DataType[]
     */
    public $Requisition_Template_Service_Line_Split_Data;
    /**
     * Constructor method for Requisition_Template_Service_Line_DataType
     * @uses Requisition_Template_Service_Line_DataType::setRequisition_Template_Service_Line_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setLine_Company_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setItem_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setDescription()
     * @uses Requisition_Template_Service_Line_DataType::setSpend_Category_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setFulfillment_Source_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setSupplier_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setOrder_From_Connection_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setExtended_Amount()
     * @uses Requisition_Template_Service_Line_DataType::setStart_Date()
     * @uses Requisition_Template_Service_Line_DataType::setEnd_Date()
     * @uses Requisition_Template_Service_Line_DataType::setShip_To_Address_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setShip_To_Contact_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setDeliver_To_Location_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setMemo()
     * @uses Requisition_Template_Service_Line_DataType::setWorktag_Reference()
     * @uses Requisition_Template_Service_Line_DataType::setRequisition_Template_Service_Line_Split_Data()
     * @param \StructType\Service_Requisition_LineObjectType $requisition_Template_Service_Line_Reference
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @param string $description
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Requisition_SourceObjectType $fulfillment_Source_Reference
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @param float $extended_Amount
     * @param string $start_Date
     * @param string $end_Date
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @param string $memo
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @param \StructType\Business_Document_Line_Split_DataType[] $requisition_Template_Service_Line_Split_Data
     */
    public function __construct(\StructType\Service_Requisition_LineObjectType $requisition_Template_Service_Line_Reference = null, \StructType\CompanyObjectType $line_Company_Reference = null, \StructType\Procurement_ItemObjectType $item_Reference = null, $description = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Requisition_SourceObjectType $fulfillment_Source_Reference = null, \StructType\Resource_ProviderObjectType $supplier_Reference = null, \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null, $extended_Amount = null, $start_Date = null, $end_Date = null, \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null, \StructType\WorkerObjectType $ship_To_Contact_Reference = null, \StructType\LocationObjectType $deliver_To_Location_Reference = null, $memo = null, array $worktag_Reference = array(), array $requisition_Template_Service_Line_Split_Data = array())
    {
        $this
            ->setRequisition_Template_Service_Line_Reference($requisition_Template_Service_Line_Reference)
            ->setLine_Company_Reference($line_Company_Reference)
            ->setItem_Reference($item_Reference)
            ->setDescription($description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setFulfillment_Source_Reference($fulfillment_Source_Reference)
            ->setSupplier_Reference($supplier_Reference)
            ->setOrder_From_Connection_Reference($order_From_Connection_Reference)
            ->setExtended_Amount($extended_Amount)
            ->setStart_Date($start_Date)
            ->setEnd_Date($end_Date)
            ->setShip_To_Address_Reference($ship_To_Address_Reference)
            ->setShip_To_Contact_Reference($ship_To_Contact_Reference)
            ->setDeliver_To_Location_Reference($deliver_To_Location_Reference)
            ->setMemo($memo)
            ->setWorktag_Reference($worktag_Reference)
            ->setRequisition_Template_Service_Line_Split_Data($requisition_Template_Service_Line_Split_Data);
    }
    /**
     * Get Requisition_Template_Service_Line_Reference value
     * @return \StructType\Service_Requisition_LineObjectType|null
     */
    public function getRequisition_Template_Service_Line_Reference()
    {
        return $this->Requisition_Template_Service_Line_Reference;
    }
    /**
     * Set Requisition_Template_Service_Line_Reference value
     * @param \StructType\Service_Requisition_LineObjectType $requisition_Template_Service_Line_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setRequisition_Template_Service_Line_Reference(\StructType\Service_Requisition_LineObjectType $requisition_Template_Service_Line_Reference = null)
    {
        $this->Requisition_Template_Service_Line_Reference = $requisition_Template_Service_Line_Reference;
        return $this;
    }
    /**
     * Get Line_Company_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getLine_Company_Reference()
    {
        return $this->Line_Company_Reference;
    }
    /**
     * Set Line_Company_Reference value
     * @param \StructType\CompanyObjectType $line_Company_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setLine_Company_Reference(\StructType\CompanyObjectType $line_Company_Reference = null)
    {
        $this->Line_Company_Reference = $line_Company_Reference;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * Set Item_Reference value
     * @param \StructType\Procurement_ItemObjectType $item_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setItem_Reference(\StructType\Procurement_ItemObjectType $item_Reference = null)
    {
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Fulfillment_Source_Reference value
     * @return \StructType\Requisition_SourceObjectType|null
     */
    public function getFulfillment_Source_Reference()
    {
        return $this->Fulfillment_Source_Reference;
    }
    /**
     * Set Fulfillment_Source_Reference value
     * @param \StructType\Requisition_SourceObjectType $fulfillment_Source_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setFulfillment_Source_Reference(\StructType\Requisition_SourceObjectType $fulfillment_Source_Reference = null)
    {
        $this->Fulfillment_Source_Reference = $fulfillment_Source_Reference;
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * Set Supplier_Reference value
     * @param \StructType\Resource_ProviderObjectType $supplier_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setSupplier_Reference(\StructType\Resource_ProviderObjectType $supplier_Reference = null)
    {
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Get Order_From_Connection_Reference value
     * @return \StructType\Order_From_Supplier_ConnectionObjectType|null
     */
    public function getOrder_From_Connection_Reference()
    {
        return $this->{'Order-From_Connection_Reference'};
    }
    /**
     * Set Order_From_Connection_Reference value
     * @param \StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setOrder_From_Connection_Reference(\StructType\Order_From_Supplier_ConnectionObjectType $order_From_Connection_Reference = null)
    {
        $this->Order_From_Connection_Reference = $this->{'Order-From_Connection_Reference'} = $order_From_Connection_Reference;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Start_Date value
     * @return string|null
     */
    public function getStart_Date()
    {
        return $this->Start_Date;
    }
    /**
     * Set Start_Date value
     * @param string $start_Date
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setStart_Date($start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($start_Date) && !is_string($start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start_Date, true), gettype($start_Date)), __LINE__);
        }
        $this->Start_Date = $start_Date;
        return $this;
    }
    /**
     * Get End_Date value
     * @return string|null
     */
    public function getEnd_Date()
    {
        return $this->End_Date;
    }
    /**
     * Set End_Date value
     * @param string $end_Date
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setEnd_Date($end_Date = null)
    {
        // validation for constraint: string
        if (!is_null($end_Date) && !is_string($end_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end_Date, true), gettype($end_Date)), __LINE__);
        }
        $this->End_Date = $end_Date;
        return $this;
    }
    /**
     * Get Ship_To_Address_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getShip_To_Address_Reference()
    {
        return $this->{'Ship-To_Address_Reference'};
    }
    /**
     * Set Ship_To_Address_Reference value
     * @param \StructType\Unique_IdentifierObjectType $ship_To_Address_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setShip_To_Address_Reference(\StructType\Unique_IdentifierObjectType $ship_To_Address_Reference = null)
    {
        $this->Ship_To_Address_Reference = $this->{'Ship-To_Address_Reference'} = $ship_To_Address_Reference;
        return $this;
    }
    /**
     * Get Ship_To_Contact_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getShip_To_Contact_Reference()
    {
        return $this->{'Ship-To_Contact_Reference'};
    }
    /**
     * Set Ship_To_Contact_Reference value
     * @param \StructType\WorkerObjectType $ship_To_Contact_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setShip_To_Contact_Reference(\StructType\WorkerObjectType $ship_To_Contact_Reference = null)
    {
        $this->Ship_To_Contact_Reference = $this->{'Ship-To_Contact_Reference'} = $ship_To_Contact_Reference;
        return $this;
    }
    /**
     * Get Deliver_To_Location_Reference value
     * @return \StructType\LocationObjectType|null
     */
    public function getDeliver_To_Location_Reference()
    {
        return $this->{'Deliver-To_Location_Reference'};
    }
    /**
     * Set Deliver_To_Location_Reference value
     * @param \StructType\LocationObjectType $deliver_To_Location_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setDeliver_To_Location_Reference(\StructType\LocationObjectType $deliver_To_Location_Reference = null)
    {
        $this->Deliver_To_Location_Reference = $this->{'Deliver-To_Location_Reference'} = $deliver_To_Location_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_Service_Line_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_Service_Line_DataTypeWorktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($requisition_Template_Service_Line_DataTypeWorktag_ReferenceItem) ? get_class($requisition_Template_Service_Line_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Template_Service_Line_DataTypeWorktag_ReferenceItem), var_export($requisition_Template_Service_Line_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function addToWorktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Template_Service_Line_Split_Data value
     * @return \StructType\Business_Document_Line_Split_DataType[]|null
     */
    public function getRequisition_Template_Service_Line_Split_Data()
    {
        return $this->Requisition_Template_Service_Line_Split_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Template_Service_Line_Split_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Template_Service_Line_Split_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Template_Service_Line_Split_DataForArrayConstraintsFromSetRequisition_Template_Service_Line_Split_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Template_Service_Line_DataTypeRequisition_Template_Service_Line_Split_DataItem) {
            // validation for constraint: itemType
            if (!$requisition_Template_Service_Line_DataTypeRequisition_Template_Service_Line_Split_DataItem instanceof \StructType\Business_Document_Line_Split_DataType) {
                $invalidValues[] = is_object($requisition_Template_Service_Line_DataTypeRequisition_Template_Service_Line_Split_DataItem) ? get_class($requisition_Template_Service_Line_DataTypeRequisition_Template_Service_Line_Split_DataItem) : sprintf('%s(%s)', gettype($requisition_Template_Service_Line_DataTypeRequisition_Template_Service_Line_Split_DataItem), var_export($requisition_Template_Service_Line_DataTypeRequisition_Template_Service_Line_Split_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Template_Service_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Template_Service_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType[] $requisition_Template_Service_Line_Split_Data
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function setRequisition_Template_Service_Line_Split_Data(array $requisition_Template_Service_Line_Split_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Template_Service_Line_Split_DataArrayErrorMessage = self::validateRequisition_Template_Service_Line_Split_DataForArrayConstraintsFromSetRequisition_Template_Service_Line_Split_Data($requisition_Template_Service_Line_Split_Data))) {
            throw new \InvalidArgumentException($requisition_Template_Service_Line_Split_DataArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Template_Service_Line_Split_Data = $requisition_Template_Service_Line_Split_Data;
        return $this;
    }
    /**
     * Add item to Requisition_Template_Service_Line_Split_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_Document_Line_Split_DataType $item
     * @return \StructType\Requisition_Template_Service_Line_DataType
     */
    public function addToRequisition_Template_Service_Line_Split_Data(\StructType\Business_Document_Line_Split_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_Document_Line_Split_DataType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Template_Service_Line_Split_Data property can only contain items of type \StructType\Business_Document_Line_Split_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Template_Service_Line_Split_Data[] = $item;
        return $this;
    }
}
