<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Requisition_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Document Date On or After must be earlier than Document Date On or Before | Utilize the following element to find Requisitions in the Workday System
 * @subpackage Structs
 */
class Requisition_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_or_Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Company or Company Hierarchy
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_or_Company_Hierarchy_Reference;
    /**
     * The Requisition_ID
     * Meta information extracted from the WSDL
     * - documentation: Requisition Number
     * - base: xsd:string
     * - maxLength: 513
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Requisition_ID;
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requesting Worker for the Requisition
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Requisition_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requisition Type of the Requisition
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Requisition_TypeObjectType[]
     */
    public $Requisition_Type_Reference;
    /**
     * The Requisition_Sourcing_Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Requisition Sourcing Buyer for the Requisition
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Requisition_Sourcing_Buyer_Reference;
    /**
     * The Requisition_Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Currency of the Requisition.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Requisition_Currency_Reference;
    /**
     * The Requisition_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Requisition Date On or After
     * - maxOccurs: 1
     * @var string
     */
    public $Requisition_Date_On_or_After;
    /**
     * The Requisition_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Requisition Date On or Before
     * - maxOccurs: 1
     * @var string
     */
    public $Requisition_Date_On_or_Before;
    /**
     * The Has_Unsourced_Lines
     * Meta information extracted from the WSDL
     * - documentation: Use this to search for Requisitions with unsourced lines
     * - choice: Has_Unsourced_Lines | Fully_Sourced
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Has_Unsourced_Lines;
    /**
     * The Fully_Sourced
     * Meta information extracted from the WSDL
     * - documentation: Use this to search for fully sourced Requisitions
     * - choice: Has_Unsourced_Lines | Fully_Sourced
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Fully_Sourced;
    /**
     * The Supplier_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to an existing Supplier
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Resource_ProviderObjectType[]
     */
    public $Supplier_Reference;
    /**
     * The Contract_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Supplier Order Contract
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_ContractObjectType[]
     */
    public $Contract_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Spend Category. The Spend Category will default from the Purchase Item if the item is specified. This Spend Category must match the Spend Category for the Purchase Item.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType[]
     */
    public $Spend_Category_Reference;
    /**
     * The Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference of an Item on the Requisition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_ItemObjectType[]
     */
    public $Item_Reference;
    /**
     * The Purchase_Order_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Purchase Order
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_OrderObjectType[]
     */
    public $Purchase_Order_Reference;
    /**
     * The Approving_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Approving Worker for the Requisition
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Approving_Worker_Reference;
    /**
     * The Created_by_Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Creating Worker for the Requisition
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType[]
     */
    public $Created_by_Worker_Reference;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to existing Worktags or Add new Worktags
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * Constructor method for Requisition_Request_CriteriaType
     * @uses Requisition_Request_CriteriaType::setCompany_or_Company_Hierarchy_Reference()
     * @uses Requisition_Request_CriteriaType::setRequisition_ID()
     * @uses Requisition_Request_CriteriaType::setRequester_Reference()
     * @uses Requisition_Request_CriteriaType::setRequisition_Type_Reference()
     * @uses Requisition_Request_CriteriaType::setRequisition_Sourcing_Buyer_Reference()
     * @uses Requisition_Request_CriteriaType::setRequisition_Currency_Reference()
     * @uses Requisition_Request_CriteriaType::setRequisition_Date_On_or_After()
     * @uses Requisition_Request_CriteriaType::setRequisition_Date_On_or_Before()
     * @uses Requisition_Request_CriteriaType::setHas_Unsourced_Lines()
     * @uses Requisition_Request_CriteriaType::setFully_Sourced()
     * @uses Requisition_Request_CriteriaType::setSupplier_Reference()
     * @uses Requisition_Request_CriteriaType::setContract_Reference()
     * @uses Requisition_Request_CriteriaType::setSpend_Category_Reference()
     * @uses Requisition_Request_CriteriaType::setItem_Reference()
     * @uses Requisition_Request_CriteriaType::setPurchase_Order_Reference()
     * @uses Requisition_Request_CriteriaType::setApproving_Worker_Reference()
     * @uses Requisition_Request_CriteriaType::setCreated_by_Worker_Reference()
     * @uses Requisition_Request_CriteriaType::setWorktags_Reference()
     * @param \StructType\OrganizationObjectType[] $company_or_Company_Hierarchy_Reference
     * @param string $requisition_ID
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @param \StructType\WorkerObjectType[] $requisition_Sourcing_Buyer_Reference
     * @param \StructType\CurrencyObjectType $requisition_Currency_Reference
     * @param string $requisition_Date_On_or_After
     * @param string $requisition_Date_On_or_Before
     * @param bool $has_Unsourced_Lines
     * @param bool $fully_Sourced
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @param \StructType\Supplier_ContractObjectType[] $contract_Reference
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @param \StructType\Procurement_ItemObjectType[] $item_Reference
     * @param \StructType\Purchase_OrderObjectType[] $purchase_Order_Reference
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     * @param \StructType\WorkerObjectType[] $created_by_Worker_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     */
    public function __construct(array $company_or_Company_Hierarchy_Reference = array(), $requisition_ID = null, \StructType\WorkerObjectType $requester_Reference = null, array $requisition_Type_Reference = array(), array $requisition_Sourcing_Buyer_Reference = array(), \StructType\CurrencyObjectType $requisition_Currency_Reference = null, $requisition_Date_On_or_After = null, $requisition_Date_On_or_Before = null, $has_Unsourced_Lines = null, $fully_Sourced = null, array $supplier_Reference = array(), array $contract_Reference = array(), array $spend_Category_Reference = array(), array $item_Reference = array(), array $purchase_Order_Reference = array(), array $approving_Worker_Reference = array(), array $created_by_Worker_Reference = array(), array $worktags_Reference = array())
    {
        $this
            ->setCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference)
            ->setRequisition_ID($requisition_ID)
            ->setRequester_Reference($requester_Reference)
            ->setRequisition_Type_Reference($requisition_Type_Reference)
            ->setRequisition_Sourcing_Buyer_Reference($requisition_Sourcing_Buyer_Reference)
            ->setRequisition_Currency_Reference($requisition_Currency_Reference)
            ->setRequisition_Date_On_or_After($requisition_Date_On_or_After)
            ->setRequisition_Date_On_or_Before($requisition_Date_On_or_Before)
            ->setHas_Unsourced_Lines($has_Unsourced_Lines)
            ->setFully_Sourced($fully_Sourced)
            ->setSupplier_Reference($supplier_Reference)
            ->setContract_Reference($contract_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setItem_Reference($item_Reference)
            ->setPurchase_Order_Reference($purchase_Order_Reference)
            ->setApproving_Worker_Reference($approving_Worker_Reference)
            ->setCreated_by_Worker_Reference($created_by_Worker_Reference)
            ->setWorktags_Reference($worktags_Reference);
    }
    /**
     * Get Company_or_Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_or_Company_Hierarchy_Reference()
    {
        return $this->Company_or_Company_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_or_Company_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_or_Company_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_or_Company_Hierarchy_ReferenceForArrayConstraintsFromSetCompany_or_Company_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem), var_export($requisition_Request_CriteriaTypeCompany_or_Company_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_or_Company_Hierarchy_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_or_Company_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_or_Company_Hierarchy_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setCompany_or_Company_Hierarchy_Reference(array $company_or_Company_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_or_Company_Hierarchy_ReferenceArrayErrorMessage = self::validateCompany_or_Company_Hierarchy_ReferenceForArrayConstraintsFromSetCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($company_or_Company_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_or_Company_Hierarchy_Reference = $company_or_Company_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Company_or_Company_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToCompany_or_Company_Hierarchy_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_or_Company_Hierarchy_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_or_Company_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_ID value
     * @return string|null
     */
    public function getRequisition_ID()
    {
        return $this->Requisition_ID;
    }
    /**
     * Set Requisition_ID value
     * @param string $requisition_ID
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setRequisition_ID($requisition_ID = null)
    {
        // validation for constraint: string
        if (!is_null($requisition_ID) && !is_string($requisition_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requisition_ID, true), gettype($requisition_ID)), __LINE__);
        }
        // validation for constraint: maxLength(513)
        if (!is_null($requisition_ID) && mb_strlen($requisition_ID) > 513) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 513', mb_strlen($requisition_ID)), __LINE__);
        }
        $this->Requisition_ID = $requisition_ID;
        return $this;
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Requisition_Type_Reference value
     * @return \StructType\Requisition_TypeObjectType[]|null
     */
    public function getRequisition_Type_Reference()
    {
        return $this->Requisition_Type_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Type_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Type_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeRequisition_Type_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeRequisition_Type_ReferenceItem instanceof \StructType\Requisition_TypeObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeRequisition_Type_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeRequisition_Type_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeRequisition_Type_ReferenceItem), var_export($requisition_Request_CriteriaTypeRequisition_Type_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType[] $requisition_Type_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setRequisition_Type_Reference(array $requisition_Type_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Type_ReferenceArrayErrorMessage = self::validateRequisition_Type_ReferenceForArrayConstraintsFromSetRequisition_Type_Reference($requisition_Type_Reference))) {
            throw new \InvalidArgumentException($requisition_Type_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Type_Reference = $requisition_Type_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Type_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Requisition_TypeObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToRequisition_Type_Reference(\StructType\Requisition_TypeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Requisition_TypeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Type_Reference property can only contain items of type \StructType\Requisition_TypeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Type_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Sourcing_Buyer_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getRequisition_Sourcing_Buyer_Reference()
    {
        return $this->Requisition_Sourcing_Buyer_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRequisition_Sourcing_Buyer_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRequisition_Sourcing_Buyer_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRequisition_Sourcing_Buyer_ReferenceForArrayConstraintsFromSetRequisition_Sourcing_Buyer_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeRequisition_Sourcing_Buyer_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeRequisition_Sourcing_Buyer_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeRequisition_Sourcing_Buyer_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeRequisition_Sourcing_Buyer_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeRequisition_Sourcing_Buyer_ReferenceItem), var_export($requisition_Request_CriteriaTypeRequisition_Sourcing_Buyer_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Requisition_Sourcing_Buyer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Requisition_Sourcing_Buyer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $requisition_Sourcing_Buyer_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setRequisition_Sourcing_Buyer_Reference(array $requisition_Sourcing_Buyer_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($requisition_Sourcing_Buyer_ReferenceArrayErrorMessage = self::validateRequisition_Sourcing_Buyer_ReferenceForArrayConstraintsFromSetRequisition_Sourcing_Buyer_Reference($requisition_Sourcing_Buyer_Reference))) {
            throw new \InvalidArgumentException($requisition_Sourcing_Buyer_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Requisition_Sourcing_Buyer_Reference = $requisition_Sourcing_Buyer_Reference;
        return $this;
    }
    /**
     * Add item to Requisition_Sourcing_Buyer_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToRequisition_Sourcing_Buyer_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Requisition_Sourcing_Buyer_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Requisition_Sourcing_Buyer_Reference[] = $item;
        return $this;
    }
    /**
     * Get Requisition_Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getRequisition_Currency_Reference()
    {
        return $this->Requisition_Currency_Reference;
    }
    /**
     * Set Requisition_Currency_Reference value
     * @param \StructType\CurrencyObjectType $requisition_Currency_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setRequisition_Currency_Reference(\StructType\CurrencyObjectType $requisition_Currency_Reference = null)
    {
        $this->Requisition_Currency_Reference = $requisition_Currency_Reference;
        return $this;
    }
    /**
     * Get Requisition_Date_On_or_After value
     * @return string|null
     */
    public function getRequisition_Date_On_or_After()
    {
        return $this->Requisition_Date_On_or_After;
    }
    /**
     * Set Requisition_Date_On_or_After value
     * @param string $requisition_Date_On_or_After
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setRequisition_Date_On_or_After($requisition_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($requisition_Date_On_or_After) && !is_string($requisition_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requisition_Date_On_or_After, true), gettype($requisition_Date_On_or_After)), __LINE__);
        }
        $this->Requisition_Date_On_or_After = $requisition_Date_On_or_After;
        return $this;
    }
    /**
     * Get Requisition_Date_On_or_Before value
     * @return string|null
     */
    public function getRequisition_Date_On_or_Before()
    {
        return $this->Requisition_Date_On_or_Before;
    }
    /**
     * Set Requisition_Date_On_or_Before value
     * @param string $requisition_Date_On_or_Before
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setRequisition_Date_On_or_Before($requisition_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($requisition_Date_On_or_Before) && !is_string($requisition_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requisition_Date_On_or_Before, true), gettype($requisition_Date_On_or_Before)), __LINE__);
        }
        $this->Requisition_Date_On_or_Before = $requisition_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Has_Unsourced_Lines value
     * @return bool|null
     */
    public function getHas_Unsourced_Lines()
    {
        return isset($this->Has_Unsourced_Lines) ? $this->Has_Unsourced_Lines : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHas_Unsourced_Lines method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHas_Unsourced_Lines method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHas_Unsourced_LinesForChoiceConstraintsFromSetHas_Unsourced_Lines($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Fully_Sourced',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Has_Unsourced_Lines can\'t be set as the property %s is already set. Only one property must be set among these properties: Has_Unsourced_Lines, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Has_Unsourced_Lines value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $has_Unsourced_Lines
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setHas_Unsourced_Lines($has_Unsourced_Lines = null)
    {
        // validation for constraint: boolean
        if (!is_null($has_Unsourced_Lines) && !is_bool($has_Unsourced_Lines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($has_Unsourced_Lines, true), gettype($has_Unsourced_Lines)), __LINE__);
        }
        // validation for constraint: choice(Has_Unsourced_Lines, Fully_Sourced)
        if ('' !== ($has_Unsourced_LinesChoiceErrorMessage = self::validateHas_Unsourced_LinesForChoiceConstraintsFromSetHas_Unsourced_Lines($has_Unsourced_Lines))) {
            throw new \InvalidArgumentException($has_Unsourced_LinesChoiceErrorMessage, __LINE__);
        }
        if (is_null($has_Unsourced_Lines) || (is_array($has_Unsourced_Lines) && empty($has_Unsourced_Lines))) {
            unset($this->Has_Unsourced_Lines);
        } else {
            $this->Has_Unsourced_Lines = $has_Unsourced_Lines;
        }
        return $this;
    }
    /**
     * Get Fully_Sourced value
     * @return bool|null
     */
    public function getFully_Sourced()
    {
        return isset($this->Fully_Sourced) ? $this->Fully_Sourced : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFully_Sourced method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFully_Sourced method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFully_SourcedForChoiceConstraintsFromSetFully_Sourced($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Has_Unsourced_Lines',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Fully_Sourced can\'t be set as the property %s is already set. Only one property must be set among these properties: Fully_Sourced, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Fully_Sourced value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param bool $fully_Sourced
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setFully_Sourced($fully_Sourced = null)
    {
        // validation for constraint: boolean
        if (!is_null($fully_Sourced) && !is_bool($fully_Sourced)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fully_Sourced, true), gettype($fully_Sourced)), __LINE__);
        }
        // validation for constraint: choice(Has_Unsourced_Lines, Fully_Sourced)
        if ('' !== ($fully_SourcedChoiceErrorMessage = self::validateFully_SourcedForChoiceConstraintsFromSetFully_Sourced($fully_Sourced))) {
            throw new \InvalidArgumentException($fully_SourcedChoiceErrorMessage, __LINE__);
        }
        if (is_null($fully_Sourced) || (is_array($fully_Sourced) && empty($fully_Sourced))) {
            unset($this->Fully_Sourced);
        } else {
            $this->Fully_Sourced = $fully_Sourced;
        }
        return $this;
    }
    /**
     * Get Supplier_Reference value
     * @return \StructType\Resource_ProviderObjectType[]|null
     */
    public function getSupplier_Reference()
    {
        return $this->Supplier_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeSupplier_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeSupplier_ReferenceItem instanceof \StructType\Resource_ProviderObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeSupplier_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeSupplier_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeSupplier_ReferenceItem), var_export($requisition_Request_CriteriaTypeSupplier_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType[] $supplier_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setSupplier_Reference(array $supplier_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_ReferenceArrayErrorMessage = self::validateSupplier_ReferenceForArrayConstraintsFromSetSupplier_Reference($supplier_Reference))) {
            throw new \InvalidArgumentException($supplier_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Reference = $supplier_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Resource_ProviderObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToSupplier_Reference(\StructType\Resource_ProviderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Resource_ProviderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Reference property can only contain items of type \StructType\Resource_ProviderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Reference[] = $item;
        return $this;
    }
    /**
     * Get Contract_Reference value
     * @return \StructType\Supplier_ContractObjectType[]|null
     */
    public function getContract_Reference()
    {
        return $this->Contract_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setContract_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContract_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContract_ReferenceForArrayConstraintsFromSetContract_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeContract_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeContract_ReferenceItem instanceof \StructType\Supplier_ContractObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeContract_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeContract_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeContract_ReferenceItem), var_export($requisition_Request_CriteriaTypeContract_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType[] $contract_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setContract_Reference(array $contract_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($contract_ReferenceArrayErrorMessage = self::validateContract_ReferenceForArrayConstraintsFromSetContract_Reference($contract_Reference))) {
            throw new \InvalidArgumentException($contract_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Contract_Reference = $contract_Reference;
        return $this;
    }
    /**
     * Add item to Contract_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_ContractObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToContract_Reference(\StructType\Supplier_ContractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_ContractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Contract_Reference property can only contain items of type \StructType\Supplier_ContractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contract_Reference[] = $item;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType[]|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSpend_Category_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpend_Category_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeSpend_Category_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeSpend_Category_ReferenceItem instanceof \StructType\Spend_CategoryObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeSpend_Category_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeSpend_Category_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeSpend_Category_ReferenceItem), var_export($requisition_Request_CriteriaTypeSpend_Category_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType[] $spend_Category_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setSpend_Category_Reference(array $spend_Category_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($spend_Category_ReferenceArrayErrorMessage = self::validateSpend_Category_ReferenceForArrayConstraintsFromSetSpend_Category_Reference($spend_Category_Reference))) {
            throw new \InvalidArgumentException($spend_Category_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Add item to Spend_Category_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Spend_CategoryObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToSpend_Category_Reference(\StructType\Spend_CategoryObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Spend_CategoryObjectType) {
            throw new \InvalidArgumentException(sprintf('The Spend_Category_Reference property can only contain items of type \StructType\Spend_CategoryObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Spend_Category_Reference[] = $item;
        return $this;
    }
    /**
     * Get Item_Reference value
     * @return \StructType\Procurement_ItemObjectType[]|null
     */
    public function getItem_Reference()
    {
        return $this->Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_ReferenceForArrayConstraintsFromSetItem_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeItem_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeItem_ReferenceItem instanceof \StructType\Procurement_ItemObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeItem_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeItem_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeItem_ReferenceItem), var_export($requisition_Request_CriteriaTypeItem_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Reference property can only contain items of type \StructType\Procurement_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_ItemObjectType[] $item_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setItem_Reference(array $item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_ReferenceArrayErrorMessage = self::validateItem_ReferenceForArrayConstraintsFromSetItem_Reference($item_Reference))) {
            throw new \InvalidArgumentException($item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Reference = $item_Reference;
        return $this;
    }
    /**
     * Add item to Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_ItemObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToItem_Reference(\StructType\Procurement_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Reference property can only contain items of type \StructType\Procurement_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Reference[] = $item;
        return $this;
    }
    /**
     * Get Purchase_Order_Reference value
     * @return \StructType\Purchase_OrderObjectType[]|null
     */
    public function getPurchase_Order_Reference()
    {
        return $this->Purchase_Order_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_ReferenceForArrayConstraintsFromSetPurchase_Order_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypePurchase_Order_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypePurchase_Order_ReferenceItem instanceof \StructType\Purchase_OrderObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypePurchase_Order_ReferenceItem) ? get_class($requisition_Request_CriteriaTypePurchase_Order_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypePurchase_Order_ReferenceItem), var_export($requisition_Request_CriteriaTypePurchase_Order_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Reference property can only contain items of type \StructType\Purchase_OrderObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType[] $purchase_Order_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setPurchase_Order_Reference(array $purchase_Order_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_ReferenceArrayErrorMessage = self::validatePurchase_Order_ReferenceForArrayConstraintsFromSetPurchase_Order_Reference($purchase_Order_Reference))) {
            throw new \InvalidArgumentException($purchase_Order_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Reference = $purchase_Order_Reference;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_OrderObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToPurchase_Order_Reference(\StructType\Purchase_OrderObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_OrderObjectType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Reference property can only contain items of type \StructType\Purchase_OrderObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Reference[] = $item;
        return $this;
    }
    /**
     * Get Approving_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getApproving_Worker_Reference()
    {
        return $this->Approving_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setApproving_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApproving_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeApproving_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeApproving_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeApproving_Worker_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeApproving_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeApproving_Worker_ReferenceItem), var_export($requisition_Request_CriteriaTypeApproving_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $approving_Worker_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setApproving_Worker_Reference(array $approving_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($approving_Worker_ReferenceArrayErrorMessage = self::validateApproving_Worker_ReferenceForArrayConstraintsFromSetApproving_Worker_Reference($approving_Worker_Reference))) {
            throw new \InvalidArgumentException($approving_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Approving_Worker_Reference = $approving_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Approving_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToApproving_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Approving_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Approving_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Created_by_Worker_Reference value
     * @return \StructType\WorkerObjectType[]|null
     */
    public function getCreated_by_Worker_Reference()
    {
        return $this->Created_by_Worker_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCreated_by_Worker_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCreated_by_Worker_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCreated_by_Worker_ReferenceForArrayConstraintsFromSetCreated_by_Worker_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeCreated_by_Worker_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeCreated_by_Worker_ReferenceItem instanceof \StructType\WorkerObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeCreated_by_Worker_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeCreated_by_Worker_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeCreated_by_Worker_ReferenceItem), var_export($requisition_Request_CriteriaTypeCreated_by_Worker_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Created_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Created_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType[] $created_by_Worker_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setCreated_by_Worker_Reference(array $created_by_Worker_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($created_by_Worker_ReferenceArrayErrorMessage = self::validateCreated_by_Worker_ReferenceForArrayConstraintsFromSetCreated_by_Worker_Reference($created_by_Worker_Reference))) {
            throw new \InvalidArgumentException($created_by_Worker_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Created_by_Worker_Reference = $created_by_Worker_Reference;
        return $this;
    }
    /**
     * Add item to Created_by_Worker_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkerObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToCreated_by_Worker_Reference(\StructType\WorkerObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkerObjectType) {
            throw new \InvalidArgumentException(sprintf('The Created_by_Worker_Reference property can only contain items of type \StructType\WorkerObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Created_by_Worker_Reference[] = $item;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $requisition_Request_CriteriaTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$requisition_Request_CriteriaTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($requisition_Request_CriteriaTypeWorktags_ReferenceItem) ? get_class($requisition_Request_CriteriaTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($requisition_Request_CriteriaTypeWorktags_ReferenceItem), var_export($requisition_Request_CriteriaTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Requisition_Request_CriteriaType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
}
