<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Request_CriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request for Quote Request Criteria element contains criteria to find Request for Quotes.
 * @subpackage Structs
 */
class Request_for_Quote_Request_CriteriaType extends AbstractStructBase
{
    /**
     * The Company_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType[]
     */
    public $Company_Reference;
    /**
     * The RFQ_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Type Reference.
     * - minOccurs: 0
     * @var \StructType\Request_for_Quote_TypeObjectType
     */
    public $RFQ_Type_Reference;
    /**
     * The Document_Date
     * Meta information extracted from the WSDL
     * - documentation: The date of the Request for Quote.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Document_Date;
    /**
     * The RFQ_Start_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Start Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Start_Date_On_or_After;
    /**
     * The RFQ_Start_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Start Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_Start_Date_On_or_Before;
    /**
     * The RFQ_End_Date_On_or_After
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote End Date On or After
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_End_Date_On_or_After;
    /**
     * The RFQ_End_Date_On_or_Before
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote End Date On or Before
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RFQ_End_Date_On_or_Before;
    /**
     * The Sourcing_Buyer_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Sourcing Buyer of Request for Quote.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Sourcing_Buyer_Reference;
    /**
     * The RFQ_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Document Status for the Request for Quote. This field is read-only, and will be ignored on a Put or Submit.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType[]
     */
    public $RFQ_Status_Reference;
    /**
     * Constructor method for Request_for_Quote_Request_CriteriaType
     * @uses Request_for_Quote_Request_CriteriaType::setCompany_Reference()
     * @uses Request_for_Quote_Request_CriteriaType::setRFQ_Type_Reference()
     * @uses Request_for_Quote_Request_CriteriaType::setDocument_Date()
     * @uses Request_for_Quote_Request_CriteriaType::setRFQ_Start_Date_On_or_After()
     * @uses Request_for_Quote_Request_CriteriaType::setRFQ_Start_Date_On_or_Before()
     * @uses Request_for_Quote_Request_CriteriaType::setRFQ_End_Date_On_or_After()
     * @uses Request_for_Quote_Request_CriteriaType::setRFQ_End_Date_On_or_Before()
     * @uses Request_for_Quote_Request_CriteriaType::setSourcing_Buyer_Reference()
     * @uses Request_for_Quote_Request_CriteriaType::setRFQ_Status_Reference()
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @param \StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference
     * @param string $document_Date
     * @param string $rFQ_Start_Date_On_or_After
     * @param string $rFQ_Start_Date_On_or_Before
     * @param string $rFQ_End_Date_On_or_After
     * @param string $rFQ_End_Date_On_or_Before
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @param \StructType\Document_StatusObjectType[] $rFQ_Status_Reference
     */
    public function __construct(array $company_Reference = array(), \StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference = null, $document_Date = null, $rFQ_Start_Date_On_or_After = null, $rFQ_Start_Date_On_or_Before = null, $rFQ_End_Date_On_or_After = null, $rFQ_End_Date_On_or_Before = null, \StructType\WorkerObjectType $sourcing_Buyer_Reference = null, array $rFQ_Status_Reference = array())
    {
        $this
            ->setCompany_Reference($company_Reference)
            ->setRFQ_Type_Reference($rFQ_Type_Reference)
            ->setDocument_Date($document_Date)
            ->setRFQ_Start_Date_On_or_After($rFQ_Start_Date_On_or_After)
            ->setRFQ_Start_Date_On_or_Before($rFQ_Start_Date_On_or_Before)
            ->setRFQ_End_Date_On_or_After($rFQ_End_Date_On_or_After)
            ->setRFQ_End_Date_On_or_Before($rFQ_End_Date_On_or_Before)
            ->setSourcing_Buyer_Reference($sourcing_Buyer_Reference)
            ->setRFQ_Status_Reference($rFQ_Status_Reference);
    }
    /**
     * Get Company_Reference value
     * @return \StructType\CompanyObjectType[]|null
     */
    public function getCompany_Reference()
    {
        return $this->Company_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Request_CriteriaTypeCompany_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Request_CriteriaTypeCompany_ReferenceItem instanceof \StructType\CompanyObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Request_CriteriaTypeCompany_ReferenceItem) ? get_class($request_for_Quote_Request_CriteriaTypeCompany_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Request_CriteriaTypeCompany_ReferenceItem), var_export($request_for_Quote_Request_CriteriaTypeCompany_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType[] $company_Reference
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setCompany_Reference(array $company_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_ReferenceArrayErrorMessage = self::validateCompany_ReferenceForArrayConstraintsFromSetCompany_Reference($company_Reference))) {
            throw new \InvalidArgumentException($company_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_Reference = $company_Reference;
        return $this;
    }
    /**
     * Add item to Company_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\CompanyObjectType $item
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function addToCompany_Reference(\StructType\CompanyObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CompanyObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_Reference property can only contain items of type \StructType\CompanyObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_Reference[] = $item;
        return $this;
    }
    /**
     * Get RFQ_Type_Reference value
     * @return \StructType\Request_for_Quote_TypeObjectType|null
     */
    public function getRFQ_Type_Reference()
    {
        return $this->RFQ_Type_Reference;
    }
    /**
     * Set RFQ_Type_Reference value
     * @param \StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setRFQ_Type_Reference(\StructType\Request_for_Quote_TypeObjectType $rFQ_Type_Reference = null)
    {
        $this->RFQ_Type_Reference = $rFQ_Type_Reference;
        return $this;
    }
    /**
     * Get Document_Date value
     * @return string|null
     */
    public function getDocument_Date()
    {
        return $this->Document_Date;
    }
    /**
     * Set Document_Date value
     * @param string $document_Date
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setDocument_Date($document_Date = null)
    {
        // validation for constraint: string
        if (!is_null($document_Date) && !is_string($document_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($document_Date, true), gettype($document_Date)), __LINE__);
        }
        $this->Document_Date = $document_Date;
        return $this;
    }
    /**
     * Get RFQ_Start_Date_On_or_After value
     * @return string|null
     */
    public function getRFQ_Start_Date_On_or_After()
    {
        return $this->RFQ_Start_Date_On_or_After;
    }
    /**
     * Set RFQ_Start_Date_On_or_After value
     * @param string $rFQ_Start_Date_On_or_After
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setRFQ_Start_Date_On_or_After($rFQ_Start_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Start_Date_On_or_After) && !is_string($rFQ_Start_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Start_Date_On_or_After, true), gettype($rFQ_Start_Date_On_or_After)), __LINE__);
        }
        $this->RFQ_Start_Date_On_or_After = $rFQ_Start_Date_On_or_After;
        return $this;
    }
    /**
     * Get RFQ_Start_Date_On_or_Before value
     * @return string|null
     */
    public function getRFQ_Start_Date_On_or_Before()
    {
        return $this->RFQ_Start_Date_On_or_Before;
    }
    /**
     * Set RFQ_Start_Date_On_or_Before value
     * @param string $rFQ_Start_Date_On_or_Before
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setRFQ_Start_Date_On_or_Before($rFQ_Start_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_Start_Date_On_or_Before) && !is_string($rFQ_Start_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_Start_Date_On_or_Before, true), gettype($rFQ_Start_Date_On_or_Before)), __LINE__);
        }
        $this->RFQ_Start_Date_On_or_Before = $rFQ_Start_Date_On_or_Before;
        return $this;
    }
    /**
     * Get RFQ_End_Date_On_or_After value
     * @return string|null
     */
    public function getRFQ_End_Date_On_or_After()
    {
        return $this->RFQ_End_Date_On_or_After;
    }
    /**
     * Set RFQ_End_Date_On_or_After value
     * @param string $rFQ_End_Date_On_or_After
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setRFQ_End_Date_On_or_After($rFQ_End_Date_On_or_After = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_End_Date_On_or_After) && !is_string($rFQ_End_Date_On_or_After)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_End_Date_On_or_After, true), gettype($rFQ_End_Date_On_or_After)), __LINE__);
        }
        $this->RFQ_End_Date_On_or_After = $rFQ_End_Date_On_or_After;
        return $this;
    }
    /**
     * Get RFQ_End_Date_On_or_Before value
     * @return string|null
     */
    public function getRFQ_End_Date_On_or_Before()
    {
        return $this->RFQ_End_Date_On_or_Before;
    }
    /**
     * Set RFQ_End_Date_On_or_Before value
     * @param string $rFQ_End_Date_On_or_Before
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setRFQ_End_Date_On_or_Before($rFQ_End_Date_On_or_Before = null)
    {
        // validation for constraint: string
        if (!is_null($rFQ_End_Date_On_or_Before) && !is_string($rFQ_End_Date_On_or_Before)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rFQ_End_Date_On_or_Before, true), gettype($rFQ_End_Date_On_or_Before)), __LINE__);
        }
        $this->RFQ_End_Date_On_or_Before = $rFQ_End_Date_On_or_Before;
        return $this;
    }
    /**
     * Get Sourcing_Buyer_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getSourcing_Buyer_Reference()
    {
        return $this->Sourcing_Buyer_Reference;
    }
    /**
     * Set Sourcing_Buyer_Reference value
     * @param \StructType\WorkerObjectType $sourcing_Buyer_Reference
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setSourcing_Buyer_Reference(\StructType\WorkerObjectType $sourcing_Buyer_Reference = null)
    {
        $this->Sourcing_Buyer_Reference = $sourcing_Buyer_Reference;
        return $this;
    }
    /**
     * Get RFQ_Status_Reference value
     * @return \StructType\Document_StatusObjectType[]|null
     */
    public function getRFQ_Status_Reference()
    {
        return $this->RFQ_Status_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRFQ_Status_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRFQ_Status_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRFQ_Status_ReferenceForArrayConstraintsFromSetRFQ_Status_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $request_for_Quote_Request_CriteriaTypeRFQ_Status_ReferenceItem) {
            // validation for constraint: itemType
            if (!$request_for_Quote_Request_CriteriaTypeRFQ_Status_ReferenceItem instanceof \StructType\Document_StatusObjectType) {
                $invalidValues[] = is_object($request_for_Quote_Request_CriteriaTypeRFQ_Status_ReferenceItem) ? get_class($request_for_Quote_Request_CriteriaTypeRFQ_Status_ReferenceItem) : sprintf('%s(%s)', gettype($request_for_Quote_Request_CriteriaTypeRFQ_Status_ReferenceItem), var_export($request_for_Quote_Request_CriteriaTypeRFQ_Status_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RFQ_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RFQ_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType[] $rFQ_Status_Reference
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function setRFQ_Status_Reference(array $rFQ_Status_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($rFQ_Status_ReferenceArrayErrorMessage = self::validateRFQ_Status_ReferenceForArrayConstraintsFromSetRFQ_Status_Reference($rFQ_Status_Reference))) {
            throw new \InvalidArgumentException($rFQ_Status_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->RFQ_Status_Reference = $rFQ_Status_Reference;
        return $this;
    }
    /**
     * Add item to RFQ_Status_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Document_StatusObjectType $item
     * @return \StructType\Request_for_Quote_Request_CriteriaType
     */
    public function addToRFQ_Status_Reference(\StructType\Document_StatusObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Document_StatusObjectType) {
            throw new \InvalidArgumentException(sprintf('The RFQ_Status_Reference property can only contain items of type \StructType\Document_StatusObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RFQ_Status_Reference[] = $item;
        return $this;
    }
}
