<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Request_for_Quote_Bid_Requirement_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that contains the Request for Quote bid requirement data at header level.
 * @subpackage Structs
 */
class Request_for_Quote_Bid_Requirement_DataType extends AbstractStructBase
{
    /**
     * The Sequence_Number
     * Meta information extracted from the WSDL
     * - documentation: Sequence Number.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - totalDigits: 5
     * @var float
     */
    public $Sequence_Number;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name.
     * - maxOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Type of response for this bid requirement. Allowed types Date, Numeric and Text.
     * @var \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType
     */
    public $Type_Reference;
    /**
     * The Response_Required
     * Meta information extracted from the WSDL
     * - documentation: Response Required for the bid question.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Response_Required;
    /**
     * The Request_for_Quote_Bid_Requirement_Classification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Request for Quote Bid Requirement Classification Reference.
     * @var \StructType\Request_for_Quote_Bid_Requirement_ClassificationObjectType
     */
    public $Request_for_Quote_Bid_Requirement_Classification_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the bid requirement.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Request_for_Quote_Bid_Requirement_DataType
     * @uses Request_for_Quote_Bid_Requirement_DataType::setSequence_Number()
     * @uses Request_for_Quote_Bid_Requirement_DataType::setName()
     * @uses Request_for_Quote_Bid_Requirement_DataType::setType_Reference()
     * @uses Request_for_Quote_Bid_Requirement_DataType::setResponse_Required()
     * @uses Request_for_Quote_Bid_Requirement_DataType::setRequest_for_Quote_Bid_Requirement_Classification_Reference()
     * @uses Request_for_Quote_Bid_Requirement_DataType::setMemo()
     * @param float $sequence_Number
     * @param string $name
     * @param \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference
     * @param bool $response_Required
     * @param \StructType\Request_for_Quote_Bid_Requirement_ClassificationObjectType $request_for_Quote_Bid_Requirement_Classification_Reference
     * @param string $memo
     */
    public function __construct($sequence_Number = null, $name = null, \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference = null, $response_Required = null, \StructType\Request_for_Quote_Bid_Requirement_ClassificationObjectType $request_for_Quote_Bid_Requirement_Classification_Reference = null, $memo = null)
    {
        $this
            ->setSequence_Number($sequence_Number)
            ->setName($name)
            ->setType_Reference($type_Reference)
            ->setResponse_Required($response_Required)
            ->setRequest_for_Quote_Bid_Requirement_Classification_Reference($request_for_Quote_Bid_Requirement_Classification_Reference)
            ->setMemo($memo);
    }
    /**
     * Get Sequence_Number value
     * @return float|null
     */
    public function getSequence_Number()
    {
        return $this->Sequence_Number;
    }
    /**
     * Set Sequence_Number value
     * @param float $sequence_Number
     * @return \StructType\Request_for_Quote_Bid_Requirement_DataType
     */
    public function setSequence_Number($sequence_Number = null)
    {
        // validation for constraint: float
        if (!is_null($sequence_Number) && !(is_float($sequence_Number) || is_numeric($sequence_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sequence_Number, true), gettype($sequence_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($sequence_Number) && mb_strlen(mb_substr($sequence_Number, false !== mb_strpos($sequence_Number, '.') ? mb_strpos($sequence_Number, '.') + 1 : mb_strlen($sequence_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($sequence_Number, true), mb_strlen(mb_substr($sequence_Number, mb_strpos($sequence_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($sequence_Number) && $sequence_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($sequence_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($sequence_Number) && mb_strlen(preg_replace('/(\D)/', '', $sequence_Number)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($sequence_Number, true), mb_strlen(preg_replace('/(\D)/', '', $sequence_Number))), __LINE__);
        }
        $this->Sequence_Number = $sequence_Number;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Request_for_Quote_Bid_Requirement_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Type_Reference value
     * @return \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType|null
     */
    public function getType_Reference()
    {
        return $this->Type_Reference;
    }
    /**
     * Set Type_Reference value
     * @param \StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference
     * @return \StructType\Request_for_Quote_Bid_Requirement_DataType
     */
    public function setType_Reference(\StructType\Request_for_Quote_Bid_Requirement_TypeObjectType $type_Reference = null)
    {
        $this->Type_Reference = $type_Reference;
        return $this;
    }
    /**
     * Get Response_Required value
     * @return bool|null
     */
    public function getResponse_Required()
    {
        return $this->Response_Required;
    }
    /**
     * Set Response_Required value
     * @param bool $response_Required
     * @return \StructType\Request_for_Quote_Bid_Requirement_DataType
     */
    public function setResponse_Required($response_Required = null)
    {
        // validation for constraint: boolean
        if (!is_null($response_Required) && !is_bool($response_Required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($response_Required, true), gettype($response_Required)), __LINE__);
        }
        $this->Response_Required = $response_Required;
        return $this;
    }
    /**
     * Get Request_for_Quote_Bid_Requirement_Classification_Reference value
     * @return \StructType\Request_for_Quote_Bid_Requirement_ClassificationObjectType|null
     */
    public function getRequest_for_Quote_Bid_Requirement_Classification_Reference()
    {
        return $this->Request_for_Quote_Bid_Requirement_Classification_Reference;
    }
    /**
     * Set Request_for_Quote_Bid_Requirement_Classification_Reference value
     * @param \StructType\Request_for_Quote_Bid_Requirement_ClassificationObjectType $request_for_Quote_Bid_Requirement_Classification_Reference
     * @return \StructType\Request_for_Quote_Bid_Requirement_DataType
     */
    public function setRequest_for_Quote_Bid_Requirement_Classification_Reference(\StructType\Request_for_Quote_Bid_Requirement_ClassificationObjectType $request_for_Quote_Bid_Requirement_Classification_Reference = null)
    {
        $this->Request_for_Quote_Bid_Requirement_Classification_Reference = $request_for_Quote_Bid_Requirement_Classification_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Request_for_Quote_Bid_Requirement_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
