<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for a Receipt
 * @subpackage Structs
 */
class Receipt_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Receipt_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Receipt
     * - maxOccurs: unbounded
     * @var \StructType\ReceiptObjectType[]
     */
    public $Receipt_Reference;
    /**
     * Constructor method for Receipt_Request_ReferencesType
     * @uses Receipt_Request_ReferencesType::setReceipt_Reference()
     * @param \StructType\ReceiptObjectType[] $receipt_Reference
     */
    public function __construct(array $receipt_Reference = array())
    {
        $this
            ->setReceipt_Reference($receipt_Reference);
    }
    /**
     * Get Receipt_Reference value
     * @return \StructType\ReceiptObjectType[]|null
     */
    public function getReceipt_Reference()
    {
        return $this->Receipt_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setReceipt_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReceipt_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReceipt_ReferenceForArrayConstraintsFromSetReceipt_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Request_ReferencesTypeReceipt_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Request_ReferencesTypeReceipt_ReferenceItem instanceof \StructType\ReceiptObjectType) {
                $invalidValues[] = is_object($receipt_Request_ReferencesTypeReceipt_ReferenceItem) ? get_class($receipt_Request_ReferencesTypeReceipt_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Request_ReferencesTypeReceipt_ReferenceItem), var_export($receipt_Request_ReferencesTypeReceipt_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Receipt_Reference property can only contain items of type \StructType\ReceiptObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Receipt_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptObjectType[] $receipt_Reference
     * @return \StructType\Receipt_Request_ReferencesType
     */
    public function setReceipt_Reference(array $receipt_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($receipt_ReferenceArrayErrorMessage = self::validateReceipt_ReferenceForArrayConstraintsFromSetReceipt_Reference($receipt_Reference))) {
            throw new \InvalidArgumentException($receipt_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Receipt_Reference = $receipt_Reference;
        return $this;
    }
    /**
     * Add item to Receipt_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\ReceiptObjectType $item
     * @return \StructType\Receipt_Request_ReferencesType
     */
    public function addToReceipt_Reference(\StructType\ReceiptObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ReceiptObjectType) {
            throw new \InvalidArgumentException(sprintf('The Receipt_Reference property can only contain items of type \StructType\ReceiptObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Receipt_Reference[] = $item;
        return $this;
    }
}
