<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_Service_LineType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing all editable fields for Receipt Adjustment Service Line
 * @subpackage Structs
 */
class Receipt_Adjustment_Service_LineType extends AbstractStructBase
{
    /**
     * The Receipt_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Receipt Line Reference to be adjusted
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Receipt_Line_Reference;
    /**
     * The Actual_Amount_Received
     * Meta information extracted from the WSDL
     * - documentation: The Actual Amount Received for this Line
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Actual_Amount_Received;
    /**
     * The Receipt_Adjustment_Reason_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to Adjustment Reason for this Receipt Adjustment Line
     * - minOccurs: 0
     * @var \StructType\Reason_CodeObjectType
     */
    public $Receipt_Adjustment_Reason_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo for the Receipt Adjustment Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * Constructor method for Receipt_Adjustment_Service_LineType
     * @uses Receipt_Adjustment_Service_LineType::setReceipt_Line_Reference()
     * @uses Receipt_Adjustment_Service_LineType::setActual_Amount_Received()
     * @uses Receipt_Adjustment_Service_LineType::setReceipt_Adjustment_Reason_Reference()
     * @uses Receipt_Adjustment_Service_LineType::setMemo()
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @param float $actual_Amount_Received
     * @param \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference
     * @param string $memo
     */
    public function __construct(\StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null, $actual_Amount_Received = null, \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference = null, $memo = null)
    {
        $this
            ->setReceipt_Line_Reference($receipt_Line_Reference)
            ->setActual_Amount_Received($actual_Amount_Received)
            ->setReceipt_Adjustment_Reason_Reference($receipt_Adjustment_Reason_Reference)
            ->setMemo($memo);
    }
    /**
     * Get Receipt_Line_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReceipt_Line_Reference()
    {
        return $this->Receipt_Line_Reference;
    }
    /**
     * Set Receipt_Line_Reference value
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @return \StructType\Receipt_Adjustment_Service_LineType
     */
    public function setReceipt_Line_Reference(\StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null)
    {
        $this->Receipt_Line_Reference = $receipt_Line_Reference;
        return $this;
    }
    /**
     * Get Actual_Amount_Received value
     * @return float|null
     */
    public function getActual_Amount_Received()
    {
        return $this->Actual_Amount_Received;
    }
    /**
     * Set Actual_Amount_Received value
     * @param float $actual_Amount_Received
     * @return \StructType\Receipt_Adjustment_Service_LineType
     */
    public function setActual_Amount_Received($actual_Amount_Received = null)
    {
        // validation for constraint: float
        if (!is_null($actual_Amount_Received) && !(is_float($actual_Amount_Received) || is_numeric($actual_Amount_Received))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($actual_Amount_Received, true), gettype($actual_Amount_Received)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($actual_Amount_Received) && mb_strlen(mb_substr($actual_Amount_Received, false !== mb_strpos($actual_Amount_Received, '.') ? mb_strpos($actual_Amount_Received, '.') + 1 : mb_strlen($actual_Amount_Received))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($actual_Amount_Received, true), mb_strlen(mb_substr($actual_Amount_Received, mb_strpos($actual_Amount_Received, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($actual_Amount_Received) && mb_strlen(preg_replace('/(\D)/', '', $actual_Amount_Received)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($actual_Amount_Received, true), mb_strlen(preg_replace('/(\D)/', '', $actual_Amount_Received))), __LINE__);
        }
        $this->Actual_Amount_Received = $actual_Amount_Received;
        return $this;
    }
    /**
     * Get Receipt_Adjustment_Reason_Reference value
     * @return \StructType\Reason_CodeObjectType|null
     */
    public function getReceipt_Adjustment_Reason_Reference()
    {
        return $this->Receipt_Adjustment_Reason_Reference;
    }
    /**
     * Set Receipt_Adjustment_Reason_Reference value
     * @param \StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference
     * @return \StructType\Receipt_Adjustment_Service_LineType
     */
    public function setReceipt_Adjustment_Reason_Reference(\StructType\Reason_CodeObjectType $receipt_Adjustment_Reason_Reference = null)
    {
        $this->Receipt_Adjustment_Reason_Reference = $receipt_Adjustment_Reason_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Receipt_Adjustment_Service_LineType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
}
