<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt_Adjustment_Item_Line_LotType StructType
 * Meta information extracted from the WSDL
 * - documentation: Receipt Adjustment Item Line Lot Data
 * @subpackage Structs
 */
class Receipt_Adjustment_Item_Line_LotType extends AbstractStructBase
{
    /**
     * The Lot_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Lot Quantity for Lot Control Item
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - totalDigits: 22
     * @var float
     */
    public $Lot_Quantity;
    /**
     * The Item_Lot_Reference
     * Meta information extracted from the WSDL
     * - documentation: Enter Lot for Lot Control Item
     * - minOccurs: 0
     * @var \StructType\Item_LotObjectType
     */
    public $Item_Lot_Reference;
    /**
     * The Item_Serial_Reference
     * Meta information extracted from the WSDL
     * - documentation: Item Serial Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Item_SerialObjectType[]
     */
    public $Item_Serial_Reference;
    /**
     * Constructor method for Receipt_Adjustment_Item_Line_LotType
     * @uses Receipt_Adjustment_Item_Line_LotType::setLot_Quantity()
     * @uses Receipt_Adjustment_Item_Line_LotType::setItem_Lot_Reference()
     * @uses Receipt_Adjustment_Item_Line_LotType::setItem_Serial_Reference()
     * @param float $lot_Quantity
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @param \StructType\Item_SerialObjectType[] $item_Serial_Reference
     */
    public function __construct($lot_Quantity = null, \StructType\Item_LotObjectType $item_Lot_Reference = null, array $item_Serial_Reference = array())
    {
        $this
            ->setLot_Quantity($lot_Quantity)
            ->setItem_Lot_Reference($item_Lot_Reference)
            ->setItem_Serial_Reference($item_Serial_Reference);
    }
    /**
     * Get Lot_Quantity value
     * @return float|null
     */
    public function getLot_Quantity()
    {
        return $this->Lot_Quantity;
    }
    /**
     * Set Lot_Quantity value
     * @param float $lot_Quantity
     * @return \StructType\Receipt_Adjustment_Item_Line_LotType
     */
    public function setLot_Quantity($lot_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($lot_Quantity) && !(is_float($lot_Quantity) || is_numeric($lot_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($lot_Quantity, true), gettype($lot_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($lot_Quantity) && mb_strlen(mb_substr($lot_Quantity, false !== mb_strpos($lot_Quantity, '.') ? mb_strpos($lot_Quantity, '.') + 1 : mb_strlen($lot_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($lot_Quantity, true), mb_strlen(mb_substr($lot_Quantity, mb_strpos($lot_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($lot_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $lot_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($lot_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $lot_Quantity))), __LINE__);
        }
        $this->Lot_Quantity = $lot_Quantity;
        return $this;
    }
    /**
     * Get Item_Lot_Reference value
     * @return \StructType\Item_LotObjectType|null
     */
    public function getItem_Lot_Reference()
    {
        return $this->Item_Lot_Reference;
    }
    /**
     * Set Item_Lot_Reference value
     * @param \StructType\Item_LotObjectType $item_Lot_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_LotType
     */
    public function setItem_Lot_Reference(\StructType\Item_LotObjectType $item_Lot_Reference = null)
    {
        $this->Item_Lot_Reference = $item_Lot_Reference;
        return $this;
    }
    /**
     * Get Item_Serial_Reference value
     * @return \StructType\Item_SerialObjectType[]|null
     */
    public function getItem_Serial_Reference()
    {
        return $this->Item_Serial_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setItem_Serial_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItem_Serial_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItem_Serial_ReferenceForArrayConstraintsFromSetItem_Serial_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $receipt_Adjustment_Item_Line_LotTypeItem_Serial_ReferenceItem) {
            // validation for constraint: itemType
            if (!$receipt_Adjustment_Item_Line_LotTypeItem_Serial_ReferenceItem instanceof \StructType\Item_SerialObjectType) {
                $invalidValues[] = is_object($receipt_Adjustment_Item_Line_LotTypeItem_Serial_ReferenceItem) ? get_class($receipt_Adjustment_Item_Line_LotTypeItem_Serial_ReferenceItem) : sprintf('%s(%s)', gettype($receipt_Adjustment_Item_Line_LotTypeItem_Serial_ReferenceItem), var_export($receipt_Adjustment_Item_Line_LotTypeItem_Serial_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Item_Serial_Reference property can only contain items of type \StructType\Item_SerialObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Item_Serial_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_SerialObjectType[] $item_Serial_Reference
     * @return \StructType\Receipt_Adjustment_Item_Line_LotType
     */
    public function setItem_Serial_Reference(array $item_Serial_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($item_Serial_ReferenceArrayErrorMessage = self::validateItem_Serial_ReferenceForArrayConstraintsFromSetItem_Serial_Reference($item_Serial_Reference))) {
            throw new \InvalidArgumentException($item_Serial_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Item_Serial_Reference = $item_Serial_Reference;
        return $this;
    }
    /**
     * Add item to Item_Serial_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Item_SerialObjectType $item
     * @return \StructType\Receipt_Adjustment_Item_Line_LotType
     */
    public function addToItem_Serial_Reference(\StructType\Item_SerialObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Item_SerialObjectType) {
            throw new \InvalidArgumentException(sprintf('The Item_Serial_Reference property can only contain items of type \StructType\Item_SerialObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Item_Serial_Reference[] = $item;
        return $this;
    }
}
