<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Travel_City_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Create a new Travel City, or change 'Add Only' to 'false' to edit the existing Travel City. | Element containing Travel City reference for update and all Travel City data items
 * @subpackage Structs
 */
class Put_Travel_City_RequestType extends AbstractStructBase
{
    /**
     * The Travel_City_Reference
     * Meta information extracted from the WSDL
     * - documentation: Travel City Reference
     * - minOccurs: 0
     * @var \StructType\Travel_CityObjectType
     */
    public $Travel_City_Reference;
    /**
     * The Travel_City_Data
     * Meta information extracted from the WSDL
     * - documentation: Travel City Data
     * @var \StructType\Travel_City_DataType
     */
    public $Travel_City_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Travel_City_RequestType
     * @uses Put_Travel_City_RequestType::setTravel_City_Reference()
     * @uses Put_Travel_City_RequestType::setTravel_City_Data()
     * @uses Put_Travel_City_RequestType::setAdd_Only()
     * @uses Put_Travel_City_RequestType::setVersion()
     * @param \StructType\Travel_CityObjectType $travel_City_Reference
     * @param \StructType\Travel_City_DataType $travel_City_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Travel_CityObjectType $travel_City_Reference = null, \StructType\Travel_City_DataType $travel_City_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setTravel_City_Reference($travel_City_Reference)
            ->setTravel_City_Data($travel_City_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Travel_City_Reference value
     * @return \StructType\Travel_CityObjectType|null
     */
    public function getTravel_City_Reference()
    {
        return $this->Travel_City_Reference;
    }
    /**
     * Set Travel_City_Reference value
     * @param \StructType\Travel_CityObjectType $travel_City_Reference
     * @return \StructType\Put_Travel_City_RequestType
     */
    public function setTravel_City_Reference(\StructType\Travel_CityObjectType $travel_City_Reference = null)
    {
        $this->Travel_City_Reference = $travel_City_Reference;
        return $this;
    }
    /**
     * Get Travel_City_Data value
     * @return \StructType\Travel_City_DataType|null
     */
    public function getTravel_City_Data()
    {
        return $this->Travel_City_Data;
    }
    /**
     * Set Travel_City_Data value
     * @param \StructType\Travel_City_DataType $travel_City_Data
     * @return \StructType\Put_Travel_City_RequestType
     */
    public function setTravel_City_Data(\StructType\Travel_City_DataType $travel_City_Data = null)
    {
        $this->Travel_City_Data = $travel_City_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Travel_City_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Travel_City_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
