<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_External_Reference_on_Spend_Transaction_ResponseType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Response Element that contains a reference to the Spend Transaction that will be updated to set External Transaction Source and External Reference ID.
 * @subpackage Structs
 */
class Put_External_Reference_on_Spend_Transaction_ResponseType extends AbstractStructBase
{
    /**
     * The Spend_Transaction_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Transaction Reference whose External Reference ID and External Source were updated by this WWS operation.
     * - minOccurs: 0
     * @var \StructType\External_Sourceable_AbstractObjectType
     */
    public $Spend_Transaction_Reference;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_External_Reference_on_Spend_Transaction_ResponseType
     * @uses Put_External_Reference_on_Spend_Transaction_ResponseType::setSpend_Transaction_Reference()
     * @uses Put_External_Reference_on_Spend_Transaction_ResponseType::setVersion()
     * @param \StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference
     * @param string $version
     */
    public function __construct(\StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference = null, $version = null)
    {
        $this
            ->setSpend_Transaction_Reference($spend_Transaction_Reference)
            ->setVersion($version);
    }
    /**
     * Get Spend_Transaction_Reference value
     * @return \StructType\External_Sourceable_AbstractObjectType|null
     */
    public function getSpend_Transaction_Reference()
    {
        return $this->Spend_Transaction_Reference;
    }
    /**
     * Set Spend_Transaction_Reference value
     * @param \StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference
     * @return \StructType\Put_External_Reference_on_Spend_Transaction_ResponseType
     */
    public function setSpend_Transaction_Reference(\StructType\External_Sourceable_AbstractObjectType $spend_Transaction_Reference = null)
    {
        $this->Spend_Transaction_Reference = $spend_Transaction_Reference;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_External_Reference_on_Spend_Transaction_ResponseType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
