<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Put_Business_Entity_Contact_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for creating or updating Business Entity Contact data
 * @subpackage Structs
 */
class Put_Business_Entity_Contact_RequestType extends AbstractStructBase
{
    /**
     * The Business_Entity_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Business Entity Contact for update only purposes
     * - minOccurs: 0
     * @var \StructType\Business_Entity_ContactObjectType
     */
    public $Business_Entity_Contact_Reference;
    /**
     * The Business_Entity_Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: Only one Primary Bill To Contact can be set To True. | Business Entity Contact Data
     * @var \StructType\Business_Entity_Contact_DataType
     */
    public $Business_Entity_Contact_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Put_Business_Entity_Contact_RequestType
     * @uses Put_Business_Entity_Contact_RequestType::setBusiness_Entity_Contact_Reference()
     * @uses Put_Business_Entity_Contact_RequestType::setBusiness_Entity_Contact_Data()
     * @uses Put_Business_Entity_Contact_RequestType::setAdd_Only()
     * @uses Put_Business_Entity_Contact_RequestType::setVersion()
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @param \StructType\Business_Entity_Contact_DataType $business_Entity_Contact_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null, \StructType\Business_Entity_Contact_DataType $business_Entity_Contact_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setBusiness_Entity_Contact_Reference($business_Entity_Contact_Reference)
            ->setBusiness_Entity_Contact_Data($business_Entity_Contact_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Business_Entity_Contact_Reference value
     * @return \StructType\Business_Entity_ContactObjectType|null
     */
    public function getBusiness_Entity_Contact_Reference()
    {
        return $this->Business_Entity_Contact_Reference;
    }
    /**
     * Set Business_Entity_Contact_Reference value
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @return \StructType\Put_Business_Entity_Contact_RequestType
     */
    public function setBusiness_Entity_Contact_Reference(\StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null)
    {
        $this->Business_Entity_Contact_Reference = $business_Entity_Contact_Reference;
        return $this;
    }
    /**
     * Get Business_Entity_Contact_Data value
     * @return \StructType\Business_Entity_Contact_DataType|null
     */
    public function getBusiness_Entity_Contact_Data()
    {
        return $this->Business_Entity_Contact_Data;
    }
    /**
     * Set Business_Entity_Contact_Data value
     * @param \StructType\Business_Entity_Contact_DataType $business_Entity_Contact_Data
     * @return \StructType\Put_Business_Entity_Contact_RequestType
     */
    public function setBusiness_Entity_Contact_Data(\StructType\Business_Entity_Contact_DataType $business_Entity_Contact_Data = null)
    {
        $this->Business_Entity_Contact_Data = $business_Entity_Contact_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Put_Business_Entity_Contact_RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Put_Business_Entity_Contact_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
