<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Purchase_Order_Change_Order_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Purchase Order Change Orders Response Data
 * @subpackage Structs
 */
class Purchase_Order_Change_Order_Response_DataType extends AbstractStructBase
{
    /**
     * The Purchase_Order_Change_Order
     * Meta information extracted from the WSDL
     * - documentation: Element containing all Purchase Order Change Order data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purchase_Order_Change_Order_OutboundType[]
     */
    public $Purchase_Order_Change_Order;
    /**
     * Constructor method for Purchase_Order_Change_Order_Response_DataType
     * @uses Purchase_Order_Change_Order_Response_DataType::setPurchase_Order_Change_Order()
     * @param \StructType\Purchase_Order_Change_Order_OutboundType[] $purchase_Order_Change_Order
     */
    public function __construct(array $purchase_Order_Change_Order = array())
    {
        $this
            ->setPurchase_Order_Change_Order($purchase_Order_Change_Order);
    }
    /**
     * Get Purchase_Order_Change_Order value
     * @return \StructType\Purchase_Order_Change_Order_OutboundType[]|null
     */
    public function getPurchase_Order_Change_Order()
    {
        return $this->Purchase_Order_Change_Order;
    }
    /**
     * This method is responsible for validating the values passed to the setPurchase_Order_Change_Order method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPurchase_Order_Change_Order method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePurchase_Order_Change_OrderForArrayConstraintsFromSetPurchase_Order_Change_Order(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchase_Order_Change_Order_Response_DataTypePurchase_Order_Change_OrderItem) {
            // validation for constraint: itemType
            if (!$purchase_Order_Change_Order_Response_DataTypePurchase_Order_Change_OrderItem instanceof \StructType\Purchase_Order_Change_Order_OutboundType) {
                $invalidValues[] = is_object($purchase_Order_Change_Order_Response_DataTypePurchase_Order_Change_OrderItem) ? get_class($purchase_Order_Change_Order_Response_DataTypePurchase_Order_Change_OrderItem) : sprintf('%s(%s)', gettype($purchase_Order_Change_Order_Response_DataTypePurchase_Order_Change_OrderItem), var_export($purchase_Order_Change_Order_Response_DataTypePurchase_Order_Change_OrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Purchase_Order_Change_Order property can only contain items of type \StructType\Purchase_Order_Change_Order_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Purchase_Order_Change_Order value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Change_Order_OutboundType[] $purchase_Order_Change_Order
     * @return \StructType\Purchase_Order_Change_Order_Response_DataType
     */
    public function setPurchase_Order_Change_Order(array $purchase_Order_Change_Order = array())
    {
        // validation for constraint: array
        if ('' !== ($purchase_Order_Change_OrderArrayErrorMessage = self::validatePurchase_Order_Change_OrderForArrayConstraintsFromSetPurchase_Order_Change_Order($purchase_Order_Change_Order))) {
            throw new \InvalidArgumentException($purchase_Order_Change_OrderArrayErrorMessage, __LINE__);
        }
        $this->Purchase_Order_Change_Order = $purchase_Order_Change_Order;
        return $this;
    }
    /**
     * Add item to Purchase_Order_Change_Order value
     * @throws \InvalidArgumentException
     * @param \StructType\Purchase_Order_Change_Order_OutboundType $item
     * @return \StructType\Purchase_Order_Change_Order_Response_DataType
     */
    public function addToPurchase_Order_Change_Order(\StructType\Purchase_Order_Change_Order_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purchase_Order_Change_Order_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Purchase_Order_Change_Order property can only contain items of type \StructType\Purchase_Order_Change_Order_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Purchase_Order_Change_Order[] = $item;
        return $this;
    }
}
