<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Phase_Name_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Project Phase Name Data element must contain either a Phase Name ID or a Name. | Project phase name already exists. | Element containing phase name data.
 * @subpackage Structs
 */
class Project_Phase_Name_DataType extends AbstractStructBase
{
    /**
     * The Phase_Name_ID
     * Meta information extracted from the WSDL
     * - documentation: Phase Name ID. This is the phase name unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phase_Name_ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: This is the unique name of the phase.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Project_Phase_Name_DataType
     * @uses Project_Phase_Name_DataType::setPhase_Name_ID()
     * @uses Project_Phase_Name_DataType::setName()
     * @param string $phase_Name_ID
     * @param string $name
     */
    public function __construct($phase_Name_ID = null, $name = null)
    {
        $this
            ->setPhase_Name_ID($phase_Name_ID)
            ->setName($name);
    }
    /**
     * Get Phase_Name_ID value
     * @return string|null
     */
    public function getPhase_Name_ID()
    {
        return $this->Phase_Name_ID;
    }
    /**
     * Set Phase_Name_ID value
     * @param string $phase_Name_ID
     * @return \StructType\Project_Phase_Name_DataType
     */
    public function setPhase_Name_ID($phase_Name_ID = null)
    {
        // validation for constraint: string
        if (!is_null($phase_Name_ID) && !is_string($phase_Name_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phase_Name_ID, true), gettype($phase_Name_ID)), __LINE__);
        }
        $this->Phase_Name_ID = $phase_Name_ID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\Project_Phase_Name_DataType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
