<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Phase_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Containing Project Plan Phase Data.
 * @subpackage Structs
 */
class Project_Phase_DataType extends AbstractStructBase
{
    /**
     * The Phase_ID
     * Meta information extracted from the WSDL
     * - documentation: Phase ID. This is the phase unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phase_ID;
    /**
     * The Phase_Name
     * Meta information extracted from the WSDL
     * - documentation: Contains Project Phase Name
     * - maxOccurs: 1
     * @var string
     */
    public $Phase_Name;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Contains Project Phase Description
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Boolean flag to set the Project Phase to Inactive.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * Constructor method for Project_Phase_DataType
     * @uses Project_Phase_DataType::setPhase_ID()
     * @uses Project_Phase_DataType::setPhase_Name()
     * @uses Project_Phase_DataType::setDescription()
     * @uses Project_Phase_DataType::setInactive()
     * @param string $phase_ID
     * @param string $phase_Name
     * @param string $description
     * @param bool $inactive
     */
    public function __construct($phase_ID = null, $phase_Name = null, $description = null, $inactive = null)
    {
        $this
            ->setPhase_ID($phase_ID)
            ->setPhase_Name($phase_Name)
            ->setDescription($description)
            ->setInactive($inactive);
    }
    /**
     * Get Phase_ID value
     * @return string|null
     */
    public function getPhase_ID()
    {
        return $this->Phase_ID;
    }
    /**
     * Set Phase_ID value
     * @param string $phase_ID
     * @return \StructType\Project_Phase_DataType
     */
    public function setPhase_ID($phase_ID = null)
    {
        // validation for constraint: string
        if (!is_null($phase_ID) && !is_string($phase_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phase_ID, true), gettype($phase_ID)), __LINE__);
        }
        $this->Phase_ID = $phase_ID;
        return $this;
    }
    /**
     * Get Phase_Name value
     * @return string|null
     */
    public function getPhase_Name()
    {
        return $this->Phase_Name;
    }
    /**
     * Set Phase_Name value
     * @param string $phase_Name
     * @return \StructType\Project_Phase_DataType
     */
    public function setPhase_Name($phase_Name = null)
    {
        // validation for constraint: string
        if (!is_null($phase_Name) && !is_string($phase_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phase_Name, true), gettype($phase_Name)), __LINE__);
        }
        $this->Phase_Name = $phase_Name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Project_Phase_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Project_Phase_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
}
