<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Project_Asset_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Get Project Asset Response Data
 * @subpackage Structs
 */
class Project_Asset_Response_DataType extends AbstractStructBase
{
    /**
     * The Project_Asset
     * Meta information extracted from the WSDL
     * - documentation: Wrapper Element that includes Project Asset Instance and Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Project_AssetType[]
     */
    public $Project_Asset;
    /**
     * Constructor method for Project_Asset_Response_DataType
     * @uses Project_Asset_Response_DataType::setProject_Asset()
     * @param \StructType\Project_AssetType[] $project_Asset
     */
    public function __construct(array $project_Asset = array())
    {
        $this
            ->setProject_Asset($project_Asset);
    }
    /**
     * Get Project_Asset value
     * @return \StructType\Project_AssetType[]|null
     */
    public function getProject_Asset()
    {
        return $this->Project_Asset;
    }
    /**
     * This method is responsible for validating the values passed to the setProject_Asset method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProject_Asset method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProject_AssetForArrayConstraintsFromSetProject_Asset(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $project_Asset_Response_DataTypeProject_AssetItem) {
            // validation for constraint: itemType
            if (!$project_Asset_Response_DataTypeProject_AssetItem instanceof \StructType\Project_AssetType) {
                $invalidValues[] = is_object($project_Asset_Response_DataTypeProject_AssetItem) ? get_class($project_Asset_Response_DataTypeProject_AssetItem) : sprintf('%s(%s)', gettype($project_Asset_Response_DataTypeProject_AssetItem), var_export($project_Asset_Response_DataTypeProject_AssetItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Project_Asset property can only contain items of type \StructType\Project_AssetType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Project_Asset value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_AssetType[] $project_Asset
     * @return \StructType\Project_Asset_Response_DataType
     */
    public function setProject_Asset(array $project_Asset = array())
    {
        // validation for constraint: array
        if ('' !== ($project_AssetArrayErrorMessage = self::validateProject_AssetForArrayConstraintsFromSetProject_Asset($project_Asset))) {
            throw new \InvalidArgumentException($project_AssetArrayErrorMessage, __LINE__);
        }
        $this->Project_Asset = $project_Asset;
        return $this;
    }
    /**
     * Add item to Project_Asset value
     * @throws \InvalidArgumentException
     * @param \StructType\Project_AssetType $item
     * @return \StructType\Project_Asset_Response_DataType
     */
    public function addToProject_Asset(\StructType\Project_AssetType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Project_AssetType) {
            throw new \InvalidArgumentException(sprintf('The Project_Asset property can only contain items of type \StructType\Project_AssetType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Project_Asset[] = $item;
        return $this;
    }
}
