<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Document_Mass_ActionObjectType StructType
 * @subpackage Structs
 */
class Procurement_Document_Mass_ActionObjectType extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Document_Mass_ActionObjectIDType[]
     */
    public $ID;
    /**
     * The Descriptor
     * Meta information extracted from the WSDL
     * - documentation: Display information used to describe an instance of an object. This 'optional' information is for outbound descriptive purposes only and is not processed on inbound Workday Web Services requests.
     * @var string
     */
    public $Descriptor;
    /**
     * Constructor method for Procurement_Document_Mass_ActionObjectType
     * @uses Procurement_Document_Mass_ActionObjectType::setID()
     * @uses Procurement_Document_Mass_ActionObjectType::setDescriptor()
     * @param \StructType\Procurement_Document_Mass_ActionObjectIDType[] $iD
     * @param string $descriptor
     */
    public function __construct(array $iD = array(), $descriptor = null)
    {
        $this
            ->setID($iD)
            ->setDescriptor($descriptor);
    }
    /**
     * Get ID value
     * @return \StructType\Procurement_Document_Mass_ActionObjectIDType[]|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * This method is responsible for validating the values passed to the setID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIDForArrayConstraintsFromSetID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Document_Mass_ActionObjectTypeIDItem) {
            // validation for constraint: itemType
            if (!$procurement_Document_Mass_ActionObjectTypeIDItem instanceof \StructType\Procurement_Document_Mass_ActionObjectIDType) {
                $invalidValues[] = is_object($procurement_Document_Mass_ActionObjectTypeIDItem) ? get_class($procurement_Document_Mass_ActionObjectTypeIDItem) : sprintf('%s(%s)', gettype($procurement_Document_Mass_ActionObjectTypeIDItem), var_export($procurement_Document_Mass_ActionObjectTypeIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ID property can only contain items of type \StructType\Procurement_Document_Mass_ActionObjectIDType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Document_Mass_ActionObjectIDType[] $iD
     * @return \StructType\Procurement_Document_Mass_ActionObjectType
     */
    public function setID(array $iD = array())
    {
        // validation for constraint: array
        if ('' !== ($iDArrayErrorMessage = self::validateIDForArrayConstraintsFromSetID($iD))) {
            throw new \InvalidArgumentException($iDArrayErrorMessage, __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Add item to ID value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Document_Mass_ActionObjectIDType $item
     * @return \StructType\Procurement_Document_Mass_ActionObjectType
     */
    public function addToID(\StructType\Procurement_Document_Mass_ActionObjectIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Document_Mass_ActionObjectIDType) {
            throw new \InvalidArgumentException(sprintf('The ID property can only contain items of type \StructType\Procurement_Document_Mass_ActionObjectIDType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ID[] = $item;
        return $this;
    }
    /**
     * Get Descriptor value
     * @return string|null
     */
    public function getDescriptor()
    {
        return $this->Descriptor;
    }
    /**
     * Set Descriptor value
     * @param string $descriptor
     * @return \StructType\Procurement_Document_Mass_ActionObjectType
     */
    public function setDescriptor($descriptor = null)
    {
        // validation for constraint: string
        if (!is_null($descriptor) && !is_string($descriptor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descriptor, true), gettype($descriptor)), __LINE__);
        }
        $this->Descriptor = $descriptor;
        return $this;
    }
}
