<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Procurement_Card_Transaction_VerificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Wrapper element that includes Procurement Card Transaction Verification instance and data
 * @subpackage Structs
 */
class Procurement_Card_Transaction_VerificationType extends AbstractStructBase
{
    /**
     * The Procurement_Card_Transaction_Verification_Reference
     * Meta information extracted from the WSDL
     * - documentation: Procurement Card Transaction Verification Reference
     * - minOccurs: 0
     * @var \StructType\Procurement_Card_Transaction_VerificationObjectType
     */
    public $Procurement_Card_Transaction_Verification_Reference;
    /**
     * The Procurement_Card_Transaction_Verification_Data
     * Meta information extracted from the WSDL
     * - documentation: Element containing Procurement Card Transaction Verification Data.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Procurement_Card_Transaction_Verification_DataType[]
     */
    public $Procurement_Card_Transaction_Verification_Data;
    /**
     * Constructor method for Procurement_Card_Transaction_VerificationType
     * @uses Procurement_Card_Transaction_VerificationType::setProcurement_Card_Transaction_Verification_Reference()
     * @uses Procurement_Card_Transaction_VerificationType::setProcurement_Card_Transaction_Verification_Data()
     * @param \StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference
     * @param \StructType\Procurement_Card_Transaction_Verification_DataType[] $procurement_Card_Transaction_Verification_Data
     */
    public function __construct(\StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference = null, array $procurement_Card_Transaction_Verification_Data = array())
    {
        $this
            ->setProcurement_Card_Transaction_Verification_Reference($procurement_Card_Transaction_Verification_Reference)
            ->setProcurement_Card_Transaction_Verification_Data($procurement_Card_Transaction_Verification_Data);
    }
    /**
     * Get Procurement_Card_Transaction_Verification_Reference value
     * @return \StructType\Procurement_Card_Transaction_VerificationObjectType|null
     */
    public function getProcurement_Card_Transaction_Verification_Reference()
    {
        return $this->Procurement_Card_Transaction_Verification_Reference;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_Reference value
     * @param \StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference
     * @return \StructType\Procurement_Card_Transaction_VerificationType
     */
    public function setProcurement_Card_Transaction_Verification_Reference(\StructType\Procurement_Card_Transaction_VerificationObjectType $procurement_Card_Transaction_Verification_Reference = null)
    {
        $this->Procurement_Card_Transaction_Verification_Reference = $procurement_Card_Transaction_Verification_Reference;
        return $this;
    }
    /**
     * Get Procurement_Card_Transaction_Verification_Data value
     * @return \StructType\Procurement_Card_Transaction_Verification_DataType[]|null
     */
    public function getProcurement_Card_Transaction_Verification_Data()
    {
        return $this->Procurement_Card_Transaction_Verification_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setProcurement_Card_Transaction_Verification_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProcurement_Card_Transaction_Verification_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProcurement_Card_Transaction_Verification_DataForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $procurement_Card_Transaction_VerificationTypeProcurement_Card_Transaction_Verification_DataItem) {
            // validation for constraint: itemType
            if (!$procurement_Card_Transaction_VerificationTypeProcurement_Card_Transaction_Verification_DataItem instanceof \StructType\Procurement_Card_Transaction_Verification_DataType) {
                $invalidValues[] = is_object($procurement_Card_Transaction_VerificationTypeProcurement_Card_Transaction_Verification_DataItem) ? get_class($procurement_Card_Transaction_VerificationTypeProcurement_Card_Transaction_Verification_DataItem) : sprintf('%s(%s)', gettype($procurement_Card_Transaction_VerificationTypeProcurement_Card_Transaction_Verification_DataItem), var_export($procurement_Card_Transaction_VerificationTypeProcurement_Card_Transaction_Verification_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Procurement_Card_Transaction_Verification_Data property can only contain items of type \StructType\Procurement_Card_Transaction_Verification_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Procurement_Card_Transaction_Verification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_Verification_DataType[] $procurement_Card_Transaction_Verification_Data
     * @return \StructType\Procurement_Card_Transaction_VerificationType
     */
    public function setProcurement_Card_Transaction_Verification_Data(array $procurement_Card_Transaction_Verification_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($procurement_Card_Transaction_Verification_DataArrayErrorMessage = self::validateProcurement_Card_Transaction_Verification_DataForArrayConstraintsFromSetProcurement_Card_Transaction_Verification_Data($procurement_Card_Transaction_Verification_Data))) {
            throw new \InvalidArgumentException($procurement_Card_Transaction_Verification_DataArrayErrorMessage, __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Data = $procurement_Card_Transaction_Verification_Data;
        return $this;
    }
    /**
     * Add item to Procurement_Card_Transaction_Verification_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Procurement_Card_Transaction_Verification_DataType $item
     * @return \StructType\Procurement_Card_Transaction_VerificationType
     */
    public function addToProcurement_Card_Transaction_Verification_Data(\StructType\Procurement_Card_Transaction_Verification_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Procurement_Card_Transaction_Verification_DataType) {
            throw new \InvalidArgumentException(sprintf('The Procurement_Card_Transaction_Verification_Data property can only contain items of type \StructType\Procurement_Card_Transaction_Verification_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Procurement_Card_Transaction_Verification_Data[] = $item;
        return $this;
    }
}
