<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Place_Asset_in_Service_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Business Process Parameter, Business Asset Reference and place in service details.
 * @subpackage Structs
 */
class Place_Asset_in_Service_RequestType extends AbstractStructBase
{
    /**
     * The Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Business Asset that will be used for the Issue transaction.
     * @var \StructType\Business_AssetObjectType
     */
    public $Business_Asset_Reference;
    /**
     * The Place_Asset_in_Service_Data
     * Meta information extracted from the WSDL
     * - documentation: There is a pending event for the asset that should be completed before this asset can be placed in service. | Data values used to issue a business asset
     * @var \StructType\Asset_Place_in_Service_DataType
     */
    public $Place_Asset_in_Service_Data;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Place_Asset_in_Service_RequestType
     * @uses Place_Asset_in_Service_RequestType::setBusiness_Asset_Reference()
     * @uses Place_Asset_in_Service_RequestType::setPlace_Asset_in_Service_Data()
     * @uses Place_Asset_in_Service_RequestType::setVersion()
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @param \StructType\Asset_Place_in_Service_DataType $place_Asset_in_Service_Data
     * @param string $version
     */
    public function __construct(\StructType\Business_AssetObjectType $business_Asset_Reference = null, \StructType\Asset_Place_in_Service_DataType $place_Asset_in_Service_Data = null, $version = null)
    {
        $this
            ->setBusiness_Asset_Reference($business_Asset_Reference)
            ->setPlace_Asset_in_Service_Data($place_Asset_in_Service_Data)
            ->setVersion($version);
    }
    /**
     * Get Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getBusiness_Asset_Reference()
    {
        return $this->Business_Asset_Reference;
    }
    /**
     * Set Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $business_Asset_Reference
     * @return \StructType\Place_Asset_in_Service_RequestType
     */
    public function setBusiness_Asset_Reference(\StructType\Business_AssetObjectType $business_Asset_Reference = null)
    {
        $this->Business_Asset_Reference = $business_Asset_Reference;
        return $this;
    }
    /**
     * Get Place_Asset_in_Service_Data value
     * @return \StructType\Asset_Place_in_Service_DataType|null
     */
    public function getPlace_Asset_in_Service_Data()
    {
        return $this->Place_Asset_in_Service_Data;
    }
    /**
     * Set Place_Asset_in_Service_Data value
     * @param \StructType\Asset_Place_in_Service_DataType $place_Asset_in_Service_Data
     * @return \StructType\Place_Asset_in_Service_RequestType
     */
    public function setPlace_Asset_in_Service_Data(\StructType\Asset_Place_in_Service_DataType $place_Asset_in_Service_Data = null)
    {
        $this->Place_Asset_in_Service_Data = $place_Asset_in_Service_Data;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Place_Asset_in_Service_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
