<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payroll_Timesheet_Time_In_Time_Out_Data_WWSType StructType
 * Meta information extracted from the WSDL
 * - documentation: Encapsulates all the data for a Payroll Timesheet Time In Time Out. Contains the ID, Time Zone, Worker, Period, and all the time tracking information for each day on the timesheet.
 * @subpackage Structs
 */
class Payroll_Timesheet_Time_In_Time_Out_Data_WWSType extends AbstractStructBase
{
    /**
     * The Payroll_Timesheet_Time_In_Time_Out_ID
     * Meta information extracted from the WSDL
     * - documentation: ID for the Payroll Timesheet Time In Time Out. This is a unique identifier for this timesheet.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Payroll_Timesheet_Time_In_Time_Out_ID;
    /**
     * The Locked_in_Workday
     * Meta information extracted from the WSDL
     * - documentation: Set to True to disable editing and canceling the timesheet inside the Workday application. Timesheet can only be updated from the web service.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Locked_in_Workday;
    /**
     * The Time_Zone_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the time zone specified on the timesheet.
     * - minOccurs: 0
     * @var \StructType\Time_ZoneObjectType
     */
    public $Time_Zone_Reference;
    /**
     * The Worker_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference for the Worker this timesheet is for.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Worker_Reference;
    /**
     * The Period_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Period this timesheet is for.
     * - minOccurs: 0
     * @var \StructType\PeriodObjectType
     */
    public $Period_Reference;
    /**
     * The Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType[]
     */
    public $Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data;
    /**
     * Constructor method for Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     * @uses Payroll_Timesheet_Time_In_Time_Out_Data_WWSType::setPayroll_Timesheet_Time_In_Time_Out_ID()
     * @uses Payroll_Timesheet_Time_In_Time_Out_Data_WWSType::setLocked_in_Workday()
     * @uses Payroll_Timesheet_Time_In_Time_Out_Data_WWSType::setTime_Zone_Reference()
     * @uses Payroll_Timesheet_Time_In_Time_Out_Data_WWSType::setWorker_Reference()
     * @uses Payroll_Timesheet_Time_In_Time_Out_Data_WWSType::setPeriod_Reference()
     * @uses Payroll_Timesheet_Time_In_Time_Out_Data_WWSType::setPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data()
     * @param string $payroll_Timesheet_Time_In_Time_Out_ID
     * @param bool $locked_in_Workday
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     * @param \StructType\WorkerObjectType $worker_Reference
     * @param \StructType\PeriodObjectType $period_Reference
     * @param \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType[] $payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data
     */
    public function __construct($payroll_Timesheet_Time_In_Time_Out_ID = null, $locked_in_Workday = null, \StructType\Time_ZoneObjectType $time_Zone_Reference = null, \StructType\WorkerObjectType $worker_Reference = null, \StructType\PeriodObjectType $period_Reference = null, array $payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data = array())
    {
        $this
            ->setPayroll_Timesheet_Time_In_Time_Out_ID($payroll_Timesheet_Time_In_Time_Out_ID)
            ->setLocked_in_Workday($locked_in_Workday)
            ->setTime_Zone_Reference($time_Zone_Reference)
            ->setWorker_Reference($worker_Reference)
            ->setPeriod_Reference($period_Reference)
            ->setPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data($payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data);
    }
    /**
     * Get Payroll_Timesheet_Time_In_Time_Out_ID value
     * @return string|null
     */
    public function getPayroll_Timesheet_Time_In_Time_Out_ID()
    {
        return $this->Payroll_Timesheet_Time_In_Time_Out_ID;
    }
    /**
     * Set Payroll_Timesheet_Time_In_Time_Out_ID value
     * @param string $payroll_Timesheet_Time_In_Time_Out_ID
     * @return \StructType\Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     */
    public function setPayroll_Timesheet_Time_In_Time_Out_ID($payroll_Timesheet_Time_In_Time_Out_ID = null)
    {
        // validation for constraint: string
        if (!is_null($payroll_Timesheet_Time_In_Time_Out_ID) && !is_string($payroll_Timesheet_Time_In_Time_Out_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payroll_Timesheet_Time_In_Time_Out_ID, true), gettype($payroll_Timesheet_Time_In_Time_Out_ID)), __LINE__);
        }
        $this->Payroll_Timesheet_Time_In_Time_Out_ID = $payroll_Timesheet_Time_In_Time_Out_ID;
        return $this;
    }
    /**
     * Get Locked_in_Workday value
     * @return bool|null
     */
    public function getLocked_in_Workday()
    {
        return $this->Locked_in_Workday;
    }
    /**
     * Set Locked_in_Workday value
     * @param bool $locked_in_Workday
     * @return \StructType\Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     */
    public function setLocked_in_Workday($locked_in_Workday = null)
    {
        // validation for constraint: boolean
        if (!is_null($locked_in_Workday) && !is_bool($locked_in_Workday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($locked_in_Workday, true), gettype($locked_in_Workday)), __LINE__);
        }
        $this->Locked_in_Workday = $locked_in_Workday;
        return $this;
    }
    /**
     * Get Time_Zone_Reference value
     * @return \StructType\Time_ZoneObjectType|null
     */
    public function getTime_Zone_Reference()
    {
        return $this->Time_Zone_Reference;
    }
    /**
     * Set Time_Zone_Reference value
     * @param \StructType\Time_ZoneObjectType $time_Zone_Reference
     * @return \StructType\Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     */
    public function setTime_Zone_Reference(\StructType\Time_ZoneObjectType $time_Zone_Reference = null)
    {
        $this->Time_Zone_Reference = $time_Zone_Reference;
        return $this;
    }
    /**
     * Get Worker_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getWorker_Reference()
    {
        return $this->Worker_Reference;
    }
    /**
     * Set Worker_Reference value
     * @param \StructType\WorkerObjectType $worker_Reference
     * @return \StructType\Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     */
    public function setWorker_Reference(\StructType\WorkerObjectType $worker_Reference = null)
    {
        $this->Worker_Reference = $worker_Reference;
        return $this;
    }
    /**
     * Get Period_Reference value
     * @return \StructType\PeriodObjectType|null
     */
    public function getPeriod_Reference()
    {
        return $this->Period_Reference;
    }
    /**
     * Set Period_Reference value
     * @param \StructType\PeriodObjectType $period_Reference
     * @return \StructType\Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     */
    public function setPeriod_Reference(\StructType\PeriodObjectType $period_Reference = null)
    {
        $this->Period_Reference = $period_Reference;
        return $this;
    }
    /**
     * Get Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data value
     * @return \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType[]|null
     */
    public function getPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data()
    {
        return $this->Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataForArrayConstraintsFromSetPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payroll_Timesheet_Time_In_Time_Out_Data_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataItem) {
            // validation for constraint: itemType
            if (!$payroll_Timesheet_Time_In_Time_Out_Data_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataItem instanceof \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType) {
                $invalidValues[] = is_object($payroll_Timesheet_Time_In_Time_Out_Data_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataItem) ? get_class($payroll_Timesheet_Time_In_Time_Out_Data_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataItem) : sprintf('%s(%s)', gettype($payroll_Timesheet_Time_In_Time_Out_Data_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataItem), var_export($payroll_Timesheet_Time_In_Time_Out_Data_WWSTypePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data property can only contain items of type \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType[] $payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data
     * @return \StructType\Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     */
    public function setPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data(array $payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($payroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataArrayErrorMessage = self::validatePayroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataForArrayConstraintsFromSetPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data($payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data))) {
            throw new \InvalidArgumentException($payroll_Timesheet_Day_Time_In_Time_Out_Replacement_DataArrayErrorMessage, __LINE__);
        }
        $this->Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data = $payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data;
        return $this;
    }
    /**
     * Add item to Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType $item
     * @return \StructType\Payroll_Timesheet_Time_In_Time_Out_Data_WWSType
     */
    public function addToPayroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data(\StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType) {
            throw new \InvalidArgumentException(sprintf('The Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data property can only contain items of type \StructType\Payroll_Timesheet_Day_Time_In_Time_Out_WWSType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payroll_Timesheet_Day_Time_In_Time_Out_Replacement_Data[] = $item;
        return $this;
    }
}
