<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payroll_Timesheet_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Only one Timesheet Line per reporting criteria is permitted. | This element encapsulates data for a Payroll Timesheet Line, which contains multiple days' worth of timesheet information. A Payroll Timesheet Line is for one Time Code,
 * a Position, and a Cost Center, and can contain a memo.
 * @subpackage Structs
 */
class Payroll_Timesheet_Line_DataType extends AbstractStructBase
{
    /**
     * The Time_Code_Reference
     * Meta information extracted from the WSDL
     * - documentation: Time Code selected must be used by Earnings. | A reference to the Time Code for this line.
     * @var \StructType\Time_Entry_CodeObjectType
     */
    public $Time_Code_Reference;
    /**
     * The Cost_Center_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Cost Center this line is being tracked to.
     * - minOccurs: 0
     * @var \StructType\Cost_CenterObjectType
     */
    public $Cost_Center_Reference;
    /**
     * The Position_Reference
     * Meta information extracted from the WSDL
     * - documentation: The Position for the Timesheet line must be a valid position for the Worker on the Timesheet effective as of the Timesheet Period's End Date. The Position field is ignored if multiple positions is not configured in Tenant Setup, or
     * if the Worker only has one assigned position. | A reference to the Position for this line.
     * - minOccurs: 0
     * @var \StructType\PositionObjectType
     */
    public $Position_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: An optional memo for the Timesheet line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Payroll_Timesheet_Day_Total_Hours_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Payroll_Timesheet_Day_Total_Hours_DataType[]
     */
    public $Payroll_Timesheet_Day_Total_Hours_Data;
    /**
     * Constructor method for Payroll_Timesheet_Line_DataType
     * @uses Payroll_Timesheet_Line_DataType::setTime_Code_Reference()
     * @uses Payroll_Timesheet_Line_DataType::setCost_Center_Reference()
     * @uses Payroll_Timesheet_Line_DataType::setPosition_Reference()
     * @uses Payroll_Timesheet_Line_DataType::setMemo()
     * @uses Payroll_Timesheet_Line_DataType::setPayroll_Timesheet_Day_Total_Hours_Data()
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @param \StructType\PositionObjectType $position_Reference
     * @param string $memo
     * @param \StructType\Payroll_Timesheet_Day_Total_Hours_DataType[] $payroll_Timesheet_Day_Total_Hours_Data
     */
    public function __construct(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null, \StructType\Cost_CenterObjectType $cost_Center_Reference = null, \StructType\PositionObjectType $position_Reference = null, $memo = null, array $payroll_Timesheet_Day_Total_Hours_Data = array())
    {
        $this
            ->setTime_Code_Reference($time_Code_Reference)
            ->setCost_Center_Reference($cost_Center_Reference)
            ->setPosition_Reference($position_Reference)
            ->setMemo($memo)
            ->setPayroll_Timesheet_Day_Total_Hours_Data($payroll_Timesheet_Day_Total_Hours_Data);
    }
    /**
     * Get Time_Code_Reference value
     * @return \StructType\Time_Entry_CodeObjectType|null
     */
    public function getTime_Code_Reference()
    {
        return $this->Time_Code_Reference;
    }
    /**
     * Set Time_Code_Reference value
     * @param \StructType\Time_Entry_CodeObjectType $time_Code_Reference
     * @return \StructType\Payroll_Timesheet_Line_DataType
     */
    public function setTime_Code_Reference(\StructType\Time_Entry_CodeObjectType $time_Code_Reference = null)
    {
        $this->Time_Code_Reference = $time_Code_Reference;
        return $this;
    }
    /**
     * Get Cost_Center_Reference value
     * @return \StructType\Cost_CenterObjectType|null
     */
    public function getCost_Center_Reference()
    {
        return $this->Cost_Center_Reference;
    }
    /**
     * Set Cost_Center_Reference value
     * @param \StructType\Cost_CenterObjectType $cost_Center_Reference
     * @return \StructType\Payroll_Timesheet_Line_DataType
     */
    public function setCost_Center_Reference(\StructType\Cost_CenterObjectType $cost_Center_Reference = null)
    {
        $this->Cost_Center_Reference = $cost_Center_Reference;
        return $this;
    }
    /**
     * Get Position_Reference value
     * @return \StructType\PositionObjectType|null
     */
    public function getPosition_Reference()
    {
        return $this->Position_Reference;
    }
    /**
     * Set Position_Reference value
     * @param \StructType\PositionObjectType $position_Reference
     * @return \StructType\Payroll_Timesheet_Line_DataType
     */
    public function setPosition_Reference(\StructType\PositionObjectType $position_Reference = null)
    {
        $this->Position_Reference = $position_Reference;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Payroll_Timesheet_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Payroll_Timesheet_Day_Total_Hours_Data value
     * @return \StructType\Payroll_Timesheet_Day_Total_Hours_DataType[]|null
     */
    public function getPayroll_Timesheet_Day_Total_Hours_Data()
    {
        return $this->Payroll_Timesheet_Day_Total_Hours_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setPayroll_Timesheet_Day_Total_Hours_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayroll_Timesheet_Day_Total_Hours_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayroll_Timesheet_Day_Total_Hours_DataForArrayConstraintsFromSetPayroll_Timesheet_Day_Total_Hours_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $payroll_Timesheet_Line_DataTypePayroll_Timesheet_Day_Total_Hours_DataItem) {
            // validation for constraint: itemType
            if (!$payroll_Timesheet_Line_DataTypePayroll_Timesheet_Day_Total_Hours_DataItem instanceof \StructType\Payroll_Timesheet_Day_Total_Hours_DataType) {
                $invalidValues[] = is_object($payroll_Timesheet_Line_DataTypePayroll_Timesheet_Day_Total_Hours_DataItem) ? get_class($payroll_Timesheet_Line_DataTypePayroll_Timesheet_Day_Total_Hours_DataItem) : sprintf('%s(%s)', gettype($payroll_Timesheet_Line_DataTypePayroll_Timesheet_Day_Total_Hours_DataItem), var_export($payroll_Timesheet_Line_DataTypePayroll_Timesheet_Day_Total_Hours_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Payroll_Timesheet_Day_Total_Hours_Data property can only contain items of type \StructType\Payroll_Timesheet_Day_Total_Hours_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Payroll_Timesheet_Day_Total_Hours_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Day_Total_Hours_DataType[] $payroll_Timesheet_Day_Total_Hours_Data
     * @return \StructType\Payroll_Timesheet_Line_DataType
     */
    public function setPayroll_Timesheet_Day_Total_Hours_Data(array $payroll_Timesheet_Day_Total_Hours_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($payroll_Timesheet_Day_Total_Hours_DataArrayErrorMessage = self::validatePayroll_Timesheet_Day_Total_Hours_DataForArrayConstraintsFromSetPayroll_Timesheet_Day_Total_Hours_Data($payroll_Timesheet_Day_Total_Hours_Data))) {
            throw new \InvalidArgumentException($payroll_Timesheet_Day_Total_Hours_DataArrayErrorMessage, __LINE__);
        }
        $this->Payroll_Timesheet_Day_Total_Hours_Data = $payroll_Timesheet_Day_Total_Hours_Data;
        return $this;
    }
    /**
     * Add item to Payroll_Timesheet_Day_Total_Hours_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Payroll_Timesheet_Day_Total_Hours_DataType $item
     * @return \StructType\Payroll_Timesheet_Line_DataType
     */
    public function addToPayroll_Timesheet_Day_Total_Hours_Data(\StructType\Payroll_Timesheet_Day_Total_Hours_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Payroll_Timesheet_Day_Total_Hours_DataType) {
            throw new \InvalidArgumentException(sprintf('The Payroll_Timesheet_Day_Total_Hours_Data property can only contain items of type \StructType\Payroll_Timesheet_Day_Total_Hours_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Payroll_Timesheet_Day_Total_Hours_Data[] = $item;
        return $this;
    }
}
