<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PO_Acknowledgement_Line_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: A Purchase Order line in ‘Closed for Receiving’ status cannot be acknowledged. | Both Quantity and Backordered Quantity cannot be zero | POA Line Data contains duplicate POA Line References or Line Reference IDs. Each POA Line
 * should have a unique ID. | A Purchase Order line in 'Cancel' status cannot be acknowledged. | The Purchase Order line associated with the Purchase Order Acknowledgement line must be for a goods line. | Quantity cannot be negative | Element containing
 * Purchase Order Acknowledgement Line data. A Purchase Order Acknowledgement may have multiple acknowledgement lines related to goods purchase order lines.
 * @subpackage Structs
 */
class PO_Acknowledgement_Line_DataType extends AbstractStructBase
{
    /**
     * The PO_Acknowledgement_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to a POA line available for update only.
     * - minOccurs: 0
     * @var \StructType\PO_Acknowledgement_LineObjectType
     */
    public $PO_Acknowledgement_Line_Reference;
    /**
     * The Purchase_Order_Acknowledgement_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Acknowledgement already exists. Only existing lines on the Purchase Order Acknowledgement can be updated. | The Web Service is set to Add Only; Acknowledgement line cannot be resubmitted. | Cannot acknowledge an already acknowledged
     * purchase order line. | Refers to the unique purchase order acknowledgement line identifier. This Reference ID will be ignored if a Purchase Order Acknowledgement instance is already present.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Purchase_Order_Acknowledgement_Line_ID;
    /**
     * The Purchase_Order_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to a purchase order line for goods associated with a POA line.
     * @var \StructType\Purchase_Order_LineObjectType
     */
    public $Purchase_Order_Line_Reference;
    /**
     * The Item_Identifier
     * Meta information extracted from the WSDL
     * - documentation: Item Identifier for the associated purchase order line's Purchase or Catalog Item. Cannot be entered for Submit. It is only returned by Get.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Identifier;
    /**
     * The PO_Acknowledgement_Status_for_POA_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Not a valid acknowledgement status for a POA line. | Refers to the acknowledgement status for a POA line. The status may be either Accepted, Accepted with Changes, Rejected, or Unacknowledged.
     * @var \StructType\PO_Acknowledgement_StatusObjectType
     */
    public $PO_Acknowledgement_Status_for_POA_Line_Reference;
    /**
     * The PO_Acknowledgement_Line_Description
     * Meta information extracted from the WSDL
     * - documentation: Refers to a supplied text description of the purchase item for the POA line. The description will default as blank.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_Acknowledgement_Line_Description;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Refers to the item unit of measurement for the POA line.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Refers to the memo for the POA line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Backordered_Quantity
     * Meta information extracted from the WSDL
     * - documentation: Refers to the supplier backordered quantity for the purchase order acknowlegement.
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Backordered_Quantity;
    /**
     * The Backorder_Date
     * Meta information extracted from the WSDL
     * - documentation: Refers to the supplier backorder date for goods items.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Backorder_Date;
    /**
     * The Alternate_Item_Identifier_Data
     * Meta information extracted from the WSDL
     * - documentation: Alternate Item Identifiers for Item on Purchase Order Acknowledgement Line
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[]
     */
    public $Alternate_Item_Identifier_Data;
    /**
     * Constructor method for PO_Acknowledgement_Line_DataType
     * @uses PO_Acknowledgement_Line_DataType::setPO_Acknowledgement_Line_Reference()
     * @uses PO_Acknowledgement_Line_DataType::setPurchase_Order_Acknowledgement_Line_ID()
     * @uses PO_Acknowledgement_Line_DataType::setPurchase_Order_Line_Reference()
     * @uses PO_Acknowledgement_Line_DataType::setItem_Identifier()
     * @uses PO_Acknowledgement_Line_DataType::setPO_Acknowledgement_Status_for_POA_Line_Reference()
     * @uses PO_Acknowledgement_Line_DataType::setPO_Acknowledgement_Line_Description()
     * @uses PO_Acknowledgement_Line_DataType::setQuantity()
     * @uses PO_Acknowledgement_Line_DataType::setUnit_of_Measure_Reference()
     * @uses PO_Acknowledgement_Line_DataType::setUnit_Cost()
     * @uses PO_Acknowledgement_Line_DataType::setMemo()
     * @uses PO_Acknowledgement_Line_DataType::setBackordered_Quantity()
     * @uses PO_Acknowledgement_Line_DataType::setBackorder_Date()
     * @uses PO_Acknowledgement_Line_DataType::setAlternate_Item_Identifier_Data()
     * @param \StructType\PO_Acknowledgement_LineObjectType $pO_Acknowledgement_Line_Reference
     * @param string $purchase_Order_Acknowledgement_Line_ID
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @param string $item_Identifier
     * @param \StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Status_for_POA_Line_Reference
     * @param string $pO_Acknowledgement_Line_Description
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param string $memo
     * @param float $backordered_Quantity
     * @param string $backorder_Date
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[] $alternate_Item_Identifier_Data
     */
    public function __construct(\StructType\PO_Acknowledgement_LineObjectType $pO_Acknowledgement_Line_Reference = null, $purchase_Order_Acknowledgement_Line_ID = null, \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null, $item_Identifier = null, \StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Status_for_POA_Line_Reference = null, $pO_Acknowledgement_Line_Description = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $memo = null, $backordered_Quantity = null, $backorder_Date = null, array $alternate_Item_Identifier_Data = array())
    {
        $this
            ->setPO_Acknowledgement_Line_Reference($pO_Acknowledgement_Line_Reference)
            ->setPurchase_Order_Acknowledgement_Line_ID($purchase_Order_Acknowledgement_Line_ID)
            ->setPurchase_Order_Line_Reference($purchase_Order_Line_Reference)
            ->setItem_Identifier($item_Identifier)
            ->setPO_Acknowledgement_Status_for_POA_Line_Reference($pO_Acknowledgement_Status_for_POA_Line_Reference)
            ->setPO_Acknowledgement_Line_Description($pO_Acknowledgement_Line_Description)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setMemo($memo)
            ->setBackordered_Quantity($backordered_Quantity)
            ->setBackorder_Date($backorder_Date)
            ->setAlternate_Item_Identifier_Data($alternate_Item_Identifier_Data);
    }
    /**
     * Get PO_Acknowledgement_Line_Reference value
     * @return \StructType\PO_Acknowledgement_LineObjectType|null
     */
    public function getPO_Acknowledgement_Line_Reference()
    {
        return $this->PO_Acknowledgement_Line_Reference;
    }
    /**
     * Set PO_Acknowledgement_Line_Reference value
     * @param \StructType\PO_Acknowledgement_LineObjectType $pO_Acknowledgement_Line_Reference
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setPO_Acknowledgement_Line_Reference(\StructType\PO_Acknowledgement_LineObjectType $pO_Acknowledgement_Line_Reference = null)
    {
        $this->PO_Acknowledgement_Line_Reference = $pO_Acknowledgement_Line_Reference;
        return $this;
    }
    /**
     * Get Purchase_Order_Acknowledgement_Line_ID value
     * @return string|null
     */
    public function getPurchase_Order_Acknowledgement_Line_ID()
    {
        return $this->Purchase_Order_Acknowledgement_Line_ID;
    }
    /**
     * Set Purchase_Order_Acknowledgement_Line_ID value
     * @param string $purchase_Order_Acknowledgement_Line_ID
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setPurchase_Order_Acknowledgement_Line_ID($purchase_Order_Acknowledgement_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($purchase_Order_Acknowledgement_Line_ID) && !is_string($purchase_Order_Acknowledgement_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchase_Order_Acknowledgement_Line_ID, true), gettype($purchase_Order_Acknowledgement_Line_ID)), __LINE__);
        }
        $this->Purchase_Order_Acknowledgement_Line_ID = $purchase_Order_Acknowledgement_Line_ID;
        return $this;
    }
    /**
     * Get Purchase_Order_Line_Reference value
     * @return \StructType\Purchase_Order_LineObjectType|null
     */
    public function getPurchase_Order_Line_Reference()
    {
        return $this->Purchase_Order_Line_Reference;
    }
    /**
     * Set Purchase_Order_Line_Reference value
     * @param \StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setPurchase_Order_Line_Reference(\StructType\Purchase_Order_LineObjectType $purchase_Order_Line_Reference = null)
    {
        $this->Purchase_Order_Line_Reference = $purchase_Order_Line_Reference;
        return $this;
    }
    /**
     * Get Item_Identifier value
     * @return string|null
     */
    public function getItem_Identifier()
    {
        return $this->Item_Identifier;
    }
    /**
     * Set Item_Identifier value
     * @param string $item_Identifier
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setItem_Identifier($item_Identifier = null)
    {
        // validation for constraint: string
        if (!is_null($item_Identifier) && !is_string($item_Identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Identifier, true), gettype($item_Identifier)), __LINE__);
        }
        $this->Item_Identifier = $item_Identifier;
        return $this;
    }
    /**
     * Get PO_Acknowledgement_Status_for_POA_Line_Reference value
     * @return \StructType\PO_Acknowledgement_StatusObjectType|null
     */
    public function getPO_Acknowledgement_Status_for_POA_Line_Reference()
    {
        return $this->PO_Acknowledgement_Status_for_POA_Line_Reference;
    }
    /**
     * Set PO_Acknowledgement_Status_for_POA_Line_Reference value
     * @param \StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Status_for_POA_Line_Reference
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setPO_Acknowledgement_Status_for_POA_Line_Reference(\StructType\PO_Acknowledgement_StatusObjectType $pO_Acknowledgement_Status_for_POA_Line_Reference = null)
    {
        $this->PO_Acknowledgement_Status_for_POA_Line_Reference = $pO_Acknowledgement_Status_for_POA_Line_Reference;
        return $this;
    }
    /**
     * Get PO_Acknowledgement_Line_Description value
     * @return string|null
     */
    public function getPO_Acknowledgement_Line_Description()
    {
        return $this->PO_Acknowledgement_Line_Description;
    }
    /**
     * Set PO_Acknowledgement_Line_Description value
     * @param string $pO_Acknowledgement_Line_Description
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setPO_Acknowledgement_Line_Description($pO_Acknowledgement_Line_Description = null)
    {
        // validation for constraint: string
        if (!is_null($pO_Acknowledgement_Line_Description) && !is_string($pO_Acknowledgement_Line_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_Acknowledgement_Line_Description, true), gettype($pO_Acknowledgement_Line_Description)), __LINE__);
        }
        $this->PO_Acknowledgement_Line_Description = $pO_Acknowledgement_Line_Description;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Backordered_Quantity value
     * @return float|null
     */
    public function getBackordered_Quantity()
    {
        return $this->Backordered_Quantity;
    }
    /**
     * Set Backordered_Quantity value
     * @param float $backordered_Quantity
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setBackordered_Quantity($backordered_Quantity = null)
    {
        // validation for constraint: float
        if (!is_null($backordered_Quantity) && !(is_float($backordered_Quantity) || is_numeric($backordered_Quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($backordered_Quantity, true), gettype($backordered_Quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($backordered_Quantity) && mb_strlen(mb_substr($backordered_Quantity, false !== mb_strpos($backordered_Quantity, '.') ? mb_strpos($backordered_Quantity, '.') + 1 : mb_strlen($backordered_Quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($backordered_Quantity, true), mb_strlen(mb_substr($backordered_Quantity, mb_strpos($backordered_Quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($backordered_Quantity) && $backordered_Quantity < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($backordered_Quantity, true)), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($backordered_Quantity) && mb_strlen(preg_replace('/(\D)/', '', $backordered_Quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($backordered_Quantity, true), mb_strlen(preg_replace('/(\D)/', '', $backordered_Quantity))), __LINE__);
        }
        $this->Backordered_Quantity = $backordered_Quantity;
        return $this;
    }
    /**
     * Get Backorder_Date value
     * @return string|null
     */
    public function getBackorder_Date()
    {
        return $this->Backorder_Date;
    }
    /**
     * Set Backorder_Date value
     * @param string $backorder_Date
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setBackorder_Date($backorder_Date = null)
    {
        // validation for constraint: string
        if (!is_null($backorder_Date) && !is_string($backorder_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backorder_Date, true), gettype($backorder_Date)), __LINE__);
        }
        $this->Backorder_Date = $backorder_Date;
        return $this;
    }
    /**
     * Get Alternate_Item_Identifier_Data value
     * @return \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[]|null
     */
    public function getAlternate_Item_Identifier_Data()
    {
        return $this->Alternate_Item_Identifier_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Item_Identifier_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Item_Identifier_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Item_Identifier_DataForArrayConstraintsFromSetAlternate_Item_Identifier_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $pO_Acknowledgement_Line_DataTypeAlternate_Item_Identifier_DataItem) {
            // validation for constraint: itemType
            if (!$pO_Acknowledgement_Line_DataTypeAlternate_Item_Identifier_DataItem instanceof \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType) {
                $invalidValues[] = is_object($pO_Acknowledgement_Line_DataTypeAlternate_Item_Identifier_DataItem) ? get_class($pO_Acknowledgement_Line_DataTypeAlternate_Item_Identifier_DataItem) : sprintf('%s(%s)', gettype($pO_Acknowledgement_Line_DataTypeAlternate_Item_Identifier_DataItem), var_export($pO_Acknowledgement_Line_DataTypeAlternate_Item_Identifier_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Item_Identifier_Data property can only contain items of type \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Item_Identifier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType[] $alternate_Item_Identifier_Data
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function setAlternate_Item_Identifier_Data(array $alternate_Item_Identifier_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Item_Identifier_DataArrayErrorMessage = self::validateAlternate_Item_Identifier_DataForArrayConstraintsFromSetAlternate_Item_Identifier_Data($alternate_Item_Identifier_Data))) {
            throw new \InvalidArgumentException($alternate_Item_Identifier_DataArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Item_Identifier_Data = $alternate_Item_Identifier_Data;
        return $this;
    }
    /**
     * Add item to Alternate_Item_Identifier_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType $item
     * @return \StructType\PO_Acknowledgement_Line_DataType
     */
    public function addToAlternate_Item_Identifier_Data(\StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Item_Identifier_Data property can only contain items of type \StructType\Line_Alternate_Item_Attribute_Value_Data_InboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Item_Identifier_Data[] = $item;
        return $this;
    }
}
