<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Override_Depreciation_Period_Status_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element Containing the Data for Override Depreciation Period Status
 * @subpackage Structs
 */
class Override_Depreciation_Period_Status_DataType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: Specify the Business Asset that needs to be processed.
     * @var \StructType\Business_AssetObjectType
     */
    public $Asset_Reference;
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: Only Accounting Company Books are allowed.If no Books are specified then all the valid books are processed. All the books that were processed are returned in the Response Message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Asset_Book_Reference;
    /**
     * The Clear_Accounted_Status
     * Meta information extracted from the WSDL
     * - documentation: This field is mutually exclusive with the Accounted Status On or Before Date field. If a value of 1 is specified in this field then the all the periods which have period status set to Accounted will become available.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Clear_Accounted_Status;
    /**
     * The Accounted_Status_On_or_Before_Date
     * Meta information extracted from the WSDL
     * - documentation: This field is mutually exclusive with the Accounted Status On or Before Date field. This field is used to specify the Date till which you want to Accounted Status to be set.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Accounted_Status_On_or_Before_Date;
    /**
     * Constructor method for Override_Depreciation_Period_Status_DataType
     * @uses Override_Depreciation_Period_Status_DataType::setAsset_Reference()
     * @uses Override_Depreciation_Period_Status_DataType::setAsset_Book_Reference()
     * @uses Override_Depreciation_Period_Status_DataType::setClear_Accounted_Status()
     * @uses Override_Depreciation_Period_Status_DataType::setAccounted_Status_On_or_Before_Date()
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     * @param bool $clear_Accounted_Status
     * @param string $accounted_Status_On_or_Before_Date
     */
    public function __construct(\StructType\Business_AssetObjectType $asset_Reference = null, array $asset_Book_Reference = array(), $clear_Accounted_Status = null, $accounted_Status_On_or_Before_Date = null)
    {
        $this
            ->setAsset_Reference($asset_Reference)
            ->setAsset_Book_Reference($asset_Book_Reference)
            ->setClear_Accounted_Status($clear_Accounted_Status)
            ->setAccounted_Status_On_or_Before_Date($accounted_Status_On_or_Before_Date);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * Set Asset_Reference value
     * @param \StructType\Business_AssetObjectType $asset_Reference
     * @return \StructType\Override_Depreciation_Period_Status_DataType
     */
    public function setAsset_Reference(\StructType\Business_AssetObjectType $asset_Reference = null)
    {
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $override_Depreciation_Period_Status_DataTypeAsset_Book_ReferenceItem) {
            // validation for constraint: itemType
            if (!$override_Depreciation_Period_Status_DataTypeAsset_Book_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($override_Depreciation_Period_Status_DataTypeAsset_Book_ReferenceItem) ? get_class($override_Depreciation_Period_Status_DataTypeAsset_Book_ReferenceItem) : sprintf('%s(%s)', gettype($override_Depreciation_Period_Status_DataTypeAsset_Book_ReferenceItem), var_export($override_Depreciation_Period_Status_DataTypeAsset_Book_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $asset_Book_Reference
     * @return \StructType\Override_Depreciation_Period_Status_DataType
     */
    public function setAsset_Book_Reference(array $asset_Book_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_ReferenceArrayErrorMessage = self::validateAsset_Book_ReferenceForArrayConstraintsFromSetAsset_Book_Reference($asset_Book_Reference))) {
            throw new \InvalidArgumentException($asset_Book_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Book_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Override_Depreciation_Period_Status_DataType
     */
    public function addToAsset_Book_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Reference[] = $item;
        return $this;
    }
    /**
     * Get Clear_Accounted_Status value
     * @return bool|null
     */
    public function getClear_Accounted_Status()
    {
        return $this->Clear_Accounted_Status;
    }
    /**
     * Set Clear_Accounted_Status value
     * @param bool $clear_Accounted_Status
     * @return \StructType\Override_Depreciation_Period_Status_DataType
     */
    public function setClear_Accounted_Status($clear_Accounted_Status = null)
    {
        // validation for constraint: boolean
        if (!is_null($clear_Accounted_Status) && !is_bool($clear_Accounted_Status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($clear_Accounted_Status, true), gettype($clear_Accounted_Status)), __LINE__);
        }
        $this->Clear_Accounted_Status = $clear_Accounted_Status;
        return $this;
    }
    /**
     * Get Accounted_Status_On_or_Before_Date value
     * @return string|null
     */
    public function getAccounted_Status_On_or_Before_Date()
    {
        return $this->Accounted_Status_On_or_Before_Date;
    }
    /**
     * Set Accounted_Status_On_or_Before_Date value
     * @param string $accounted_Status_On_or_Before_Date
     * @return \StructType\Override_Depreciation_Period_Status_DataType
     */
    public function setAccounted_Status_On_or_Before_Date($accounted_Status_On_or_Before_Date = null)
    {
        // validation for constraint: string
        if (!is_null($accounted_Status_On_or_Before_Date) && !is_string($accounted_Status_On_or_Before_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accounted_Status_On_or_Before_Date, true), gettype($accounted_Status_On_or_Before_Date)), __LINE__);
        }
        $this->Accounted_Status_On_or_Before_Date = $accounted_Status_On_or_Before_Date;
        return $this;
    }
}
