<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Order-From_Connection_Alternate_Name_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Alternate Name used by Order-From Connection
 * @subpackage Structs
 */
class Order_From_Connection_Alternate_Name_DataType extends AbstractStructBase
{
    /**
     * The Alternate_Name
     * Meta information extracted from the WSDL
     * - documentation: Alternate Name Text. The value should be one of the alternate names for the supplier.
     * - maxOccurs: 1
     * @var string
     */
    public $Alternate_Name;
    /**
     * The Alternate_Name_Usage_Reference
     * Meta information extracted from the WSDL
     * - documentation: Usage of the Alternate Name. This field is optional - if provided, it'll be used to match the right Alternate Name record for the supplier, along with Alternate Name attribute. If it's not provided, only the Alternate Name will be
     * used to match the alternate name record for the supplier.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Alternate_Name_UsageObjectType[]
     */
    public $Alternate_Name_Usage_Reference;
    /**
     * Constructor method for Order-From_Connection_Alternate_Name_DataType
     * @uses Order_From_Connection_Alternate_Name_DataType::setAlternate_Name()
     * @uses Order_From_Connection_Alternate_Name_DataType::setAlternate_Name_Usage_Reference()
     * @param string $alternate_Name
     * @param \StructType\Alternate_Name_UsageObjectType[] $alternate_Name_Usage_Reference
     */
    public function __construct($alternate_Name = null, array $alternate_Name_Usage_Reference = array())
    {
        $this
            ->setAlternate_Name($alternate_Name)
            ->setAlternate_Name_Usage_Reference($alternate_Name_Usage_Reference);
    }
    /**
     * Get Alternate_Name value
     * @return string|null
     */
    public function getAlternate_Name()
    {
        return $this->Alternate_Name;
    }
    /**
     * Set Alternate_Name value
     * @param string $alternate_Name
     * @return \StructType\Order_From_Connection_Alternate_Name_DataType
     */
    public function setAlternate_Name($alternate_Name = null)
    {
        // validation for constraint: string
        if (!is_null($alternate_Name) && !is_string($alternate_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternate_Name, true), gettype($alternate_Name)), __LINE__);
        }
        $this->Alternate_Name = $alternate_Name;
        return $this;
    }
    /**
     * Get Alternate_Name_Usage_Reference value
     * @return \StructType\Alternate_Name_UsageObjectType[]|null
     */
    public function getAlternate_Name_Usage_Reference()
    {
        return $this->Alternate_Name_Usage_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternate_Name_Usage_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternate_Name_Usage_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternate_Name_Usage_ReferenceForArrayConstraintsFromSetAlternate_Name_Usage_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $order_From_Connection_Alternate_Name_DataTypeAlternate_Name_Usage_ReferenceItem) {
            // validation for constraint: itemType
            if (!$order_From_Connection_Alternate_Name_DataTypeAlternate_Name_Usage_ReferenceItem instanceof \StructType\Alternate_Name_UsageObjectType) {
                $invalidValues[] = is_object($order_From_Connection_Alternate_Name_DataTypeAlternate_Name_Usage_ReferenceItem) ? get_class($order_From_Connection_Alternate_Name_DataTypeAlternate_Name_Usage_ReferenceItem) : sprintf('%s(%s)', gettype($order_From_Connection_Alternate_Name_DataTypeAlternate_Name_Usage_ReferenceItem), var_export($order_From_Connection_Alternate_Name_DataTypeAlternate_Name_Usage_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Alternate_Name_Usage_Reference property can only contain items of type \StructType\Alternate_Name_UsageObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Alternate_Name_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Name_UsageObjectType[] $alternate_Name_Usage_Reference
     * @return \StructType\Order_From_Connection_Alternate_Name_DataType
     */
    public function setAlternate_Name_Usage_Reference(array $alternate_Name_Usage_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($alternate_Name_Usage_ReferenceArrayErrorMessage = self::validateAlternate_Name_Usage_ReferenceForArrayConstraintsFromSetAlternate_Name_Usage_Reference($alternate_Name_Usage_Reference))) {
            throw new \InvalidArgumentException($alternate_Name_Usage_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Alternate_Name_Usage_Reference = $alternate_Name_Usage_Reference;
        return $this;
    }
    /**
     * Add item to Alternate_Name_Usage_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Alternate_Name_UsageObjectType $item
     * @return \StructType\Order_From_Connection_Alternate_Name_DataType
     */
    public function addToAlternate_Name_Usage_Reference(\StructType\Alternate_Name_UsageObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Alternate_Name_UsageObjectType) {
            throw new \InvalidArgumentException(sprintf('The Alternate_Name_Usage_Reference property can only contain items of type \StructType\Alternate_Name_UsageObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Alternate_Name_Usage_Reference[] = $item;
        return $this;
    }
}
