<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice_Type_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Invoice Type is currently in use, you cannot change the country. | The combination of the Invoice Type Name and the related Country must be unique. | Element that encapsulates all of the data related to the Invoice Type.
 * @subpackage Structs
 */
class Invoice_Type_DataType extends AbstractStructBase
{
    /**
     * The Invoice_Type_ID
     * Meta information extracted from the WSDL
     * - documentation: Invoice Type ID. This is the Invoice Type unique identifier.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Type_ID;
    /**
     * The Invoice_Type_Value
     * Meta information extracted from the WSDL
     * - documentation: The name of the Invoice Type
     * - maxOccurs: 1
     * @var string
     */
    public $Invoice_Type_Value;
    /**
     * The Country_Reference
     * Meta information extracted from the WSDL
     * - documentation: The country for this Invoice Type. Any country is available to choose. This cannot be edited once the Invoice Type is in use.
     * @var \StructType\CountryObjectType
     */
    public $Country_Reference;
    /**
     * The Invoice_Type_Description
     * Meta information extracted from the WSDL
     * - documentation: The description of the Invoice Type. This is not required.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Invoice_Type_Description;
    /**
     * The Usage_Location_Reference
     * Meta information extracted from the WSDL
     * - documentation: The usage location of the Invoice Type. If this is left blank, the Invoice Type will not be available anywhere. Only in the chosen usage locations will the Invoice Type be available for selection.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType[]
     */
    public $Usage_Location_Reference;
    /**
     * The Invoice_Type_Inactive
     * Meta information extracted from the WSDL
     * - documentation: This boolean attribute activates or deactivates the Invoice Type. If an Invoice Type in inactive, it will no longer show up in its usage locations.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Invoice_Type_Inactive;
    /**
     * The Invoice_Type_In_Use
     * Meta information extracted from the WSDL
     * - documentation: This field identifies if the invoice type is in use within Workday. The field is only for informational purposes and is ignored by Workday if it's used to submit data.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Invoice_Type_In_Use;
    /**
     * Constructor method for Invoice_Type_DataType
     * @uses Invoice_Type_DataType::setInvoice_Type_ID()
     * @uses Invoice_Type_DataType::setInvoice_Type_Value()
     * @uses Invoice_Type_DataType::setCountry_Reference()
     * @uses Invoice_Type_DataType::setInvoice_Type_Description()
     * @uses Invoice_Type_DataType::setUsage_Location_Reference()
     * @uses Invoice_Type_DataType::setInvoice_Type_Inactive()
     * @uses Invoice_Type_DataType::setInvoice_Type_In_Use()
     * @param string $invoice_Type_ID
     * @param string $invoice_Type_Value
     * @param \StructType\CountryObjectType $country_Reference
     * @param string $invoice_Type_Description
     * @param \StructType\Unique_IdentifierObjectType[] $usage_Location_Reference
     * @param bool $invoice_Type_Inactive
     * @param bool $invoice_Type_In_Use
     */
    public function __construct($invoice_Type_ID = null, $invoice_Type_Value = null, \StructType\CountryObjectType $country_Reference = null, $invoice_Type_Description = null, array $usage_Location_Reference = array(), $invoice_Type_Inactive = null, $invoice_Type_In_Use = null)
    {
        $this
            ->setInvoice_Type_ID($invoice_Type_ID)
            ->setInvoice_Type_Value($invoice_Type_Value)
            ->setCountry_Reference($country_Reference)
            ->setInvoice_Type_Description($invoice_Type_Description)
            ->setUsage_Location_Reference($usage_Location_Reference)
            ->setInvoice_Type_Inactive($invoice_Type_Inactive)
            ->setInvoice_Type_In_Use($invoice_Type_In_Use);
    }
    /**
     * Get Invoice_Type_ID value
     * @return string|null
     */
    public function getInvoice_Type_ID()
    {
        return $this->Invoice_Type_ID;
    }
    /**
     * Set Invoice_Type_ID value
     * @param string $invoice_Type_ID
     * @return \StructType\Invoice_Type_DataType
     */
    public function setInvoice_Type_ID($invoice_Type_ID = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Type_ID) && !is_string($invoice_Type_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Type_ID, true), gettype($invoice_Type_ID)), __LINE__);
        }
        $this->Invoice_Type_ID = $invoice_Type_ID;
        return $this;
    }
    /**
     * Get Invoice_Type_Value value
     * @return string|null
     */
    public function getInvoice_Type_Value()
    {
        return $this->Invoice_Type_Value;
    }
    /**
     * Set Invoice_Type_Value value
     * @param string $invoice_Type_Value
     * @return \StructType\Invoice_Type_DataType
     */
    public function setInvoice_Type_Value($invoice_Type_Value = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Type_Value) && !is_string($invoice_Type_Value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Type_Value, true), gettype($invoice_Type_Value)), __LINE__);
        }
        $this->Invoice_Type_Value = $invoice_Type_Value;
        return $this;
    }
    /**
     * Get Country_Reference value
     * @return \StructType\CountryObjectType|null
     */
    public function getCountry_Reference()
    {
        return $this->Country_Reference;
    }
    /**
     * Set Country_Reference value
     * @param \StructType\CountryObjectType $country_Reference
     * @return \StructType\Invoice_Type_DataType
     */
    public function setCountry_Reference(\StructType\CountryObjectType $country_Reference = null)
    {
        $this->Country_Reference = $country_Reference;
        return $this;
    }
    /**
     * Get Invoice_Type_Description value
     * @return string|null
     */
    public function getInvoice_Type_Description()
    {
        return $this->Invoice_Type_Description;
    }
    /**
     * Set Invoice_Type_Description value
     * @param string $invoice_Type_Description
     * @return \StructType\Invoice_Type_DataType
     */
    public function setInvoice_Type_Description($invoice_Type_Description = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_Type_Description) && !is_string($invoice_Type_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoice_Type_Description, true), gettype($invoice_Type_Description)), __LINE__);
        }
        $this->Invoice_Type_Description = $invoice_Type_Description;
        return $this;
    }
    /**
     * Get Usage_Location_Reference value
     * @return \StructType\Unique_IdentifierObjectType[]|null
     */
    public function getUsage_Location_Reference()
    {
        return $this->Usage_Location_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setUsage_Location_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUsage_Location_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUsage_Location_ReferenceForArrayConstraintsFromSetUsage_Location_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $invoice_Type_DataTypeUsage_Location_ReferenceItem) {
            // validation for constraint: itemType
            if (!$invoice_Type_DataTypeUsage_Location_ReferenceItem instanceof \StructType\Unique_IdentifierObjectType) {
                $invalidValues[] = is_object($invoice_Type_DataTypeUsage_Location_ReferenceItem) ? get_class($invoice_Type_DataTypeUsage_Location_ReferenceItem) : sprintf('%s(%s)', gettype($invoice_Type_DataTypeUsage_Location_ReferenceItem), var_export($invoice_Type_DataTypeUsage_Location_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Usage_Location_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Usage_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType[] $usage_Location_Reference
     * @return \StructType\Invoice_Type_DataType
     */
    public function setUsage_Location_Reference(array $usage_Location_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($usage_Location_ReferenceArrayErrorMessage = self::validateUsage_Location_ReferenceForArrayConstraintsFromSetUsage_Location_Reference($usage_Location_Reference))) {
            throw new \InvalidArgumentException($usage_Location_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Usage_Location_Reference = $usage_Location_Reference;
        return $this;
    }
    /**
     * Add item to Usage_Location_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Unique_IdentifierObjectType $item
     * @return \StructType\Invoice_Type_DataType
     */
    public function addToUsage_Location_Reference(\StructType\Unique_IdentifierObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unique_IdentifierObjectType) {
            throw new \InvalidArgumentException(sprintf('The Usage_Location_Reference property can only contain items of type \StructType\Unique_IdentifierObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Usage_Location_Reference[] = $item;
        return $this;
    }
    /**
     * Get Invoice_Type_Inactive value
     * @return bool|null
     */
    public function getInvoice_Type_Inactive()
    {
        return $this->Invoice_Type_Inactive;
    }
    /**
     * Set Invoice_Type_Inactive value
     * @param bool $invoice_Type_Inactive
     * @return \StructType\Invoice_Type_DataType
     */
    public function setInvoice_Type_Inactive($invoice_Type_Inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($invoice_Type_Inactive) && !is_bool($invoice_Type_Inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invoice_Type_Inactive, true), gettype($invoice_Type_Inactive)), __LINE__);
        }
        $this->Invoice_Type_Inactive = $invoice_Type_Inactive;
        return $this;
    }
    /**
     * Get Invoice_Type_In_Use value
     * @return bool|null
     */
    public function getInvoice_Type_In_Use()
    {
        return $this->Invoice_Type_In_Use;
    }
    /**
     * Set Invoice_Type_In_Use value
     * @param bool $invoice_Type_In_Use
     * @return \StructType\Invoice_Type_DataType
     */
    public function setInvoice_Type_In_Use($invoice_Type_In_Use = null)
    {
        // validation for constraint: boolean
        if (!is_null($invoice_Type_In_Use) && !is_bool($invoice_Type_In_Use)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($invoice_Type_In_Use, true), gettype($invoice_Type_In_Use)), __LINE__);
        }
        $this->Invoice_Type_In_Use = $invoice_Type_In_Use;
        return $this;
    }
}
