<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Provider_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Two Reference ID's have been provided that resolve to different instances. Please provide only one Reference ID or verify that both Reference ID's resolve to the same instance. | Element that represents the contents of the Internal
 * Service Provider.
 * @subpackage Structs
 */
class Internal_Service_Provider_DataType extends AbstractStructBase
{
    /**
     * The Internal_Service_Provider_Reference_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Service_Provider_Reference_ID;
    /**
     * The Internal_Service_Provider_Name
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Provider Name.
     * - maxOccurs: 1
     * @var string
     */
    public $Internal_Service_Provider_Name;
    /**
     * The Internal_Service_Provider_ID
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Provider ID.
     * - maxOccurs: 1
     * @var string
     */
    public $Internal_Service_Provider_ID;
    /**
     * The Currency_Reference
     * Meta information extracted from the WSDL
     * - documentation: Currency for an Internal Service Provider.
     * - minOccurs: 0
     * @var \StructType\CurrencyObjectType
     */
    public $Currency_Reference;
    /**
     * The Inactive
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether the Internal Service Provider is inactive or not.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Inactive;
    /**
     * The Internal_Catalog_Reference
     * Meta information extracted from the WSDL
     * - documentation: Internal Catalogs associated with an Internal Service Provider. This is read-only and cannot be specified when creating an Internal Service Provider.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Abstract_Procurement_CatalogObjectType[]
     */
    public $Internal_Catalog_Reference;
    /**
     * The Company_or_Company_Hierarchy_Reference
     * Meta information extracted from the WSDL
     * - documentation: Companies or company hierarchies associated with an Internal Service Provider.
     * - maxOccurs: unbounded
     * @var \StructType\OrganizationObjectType[]
     */
    public $Company_or_Company_Hierarchy_Reference;
    /**
     * The Review_Date
     * Meta information extracted from the WSDL
     * - documentation: The date on which the Internal Service Provider was last reviewed.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Review_Date;
    /**
     * The Next_Review_Date
     * Meta information extracted from the WSDL
     * - documentation: The date on which the Internal Service Provider becomes eligible for review.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Next_Review_Date;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: The descriptive information or comments about the Internal Service Provider.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Revenue_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Revenue category associated with an Internal Service Provider.
     * - minOccurs: 0
     * @var \StructType\Revenue_CategoryObjectType
     */
    public $Revenue_Category_Reference;
    /**
     * The Internal_Service_Provider_Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags associated with an Internal Service Provider
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Internal_Service_Provider_Worktag_Reference;
    /**
     * The Attachment_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Financials_Attachment_DataType[]
     */
    public $Attachment_Data;
    /**
     * Constructor method for Internal_Service_Provider_DataType
     * @uses Internal_Service_Provider_DataType::setInternal_Service_Provider_Reference_ID()
     * @uses Internal_Service_Provider_DataType::setInternal_Service_Provider_Name()
     * @uses Internal_Service_Provider_DataType::setInternal_Service_Provider_ID()
     * @uses Internal_Service_Provider_DataType::setCurrency_Reference()
     * @uses Internal_Service_Provider_DataType::setInactive()
     * @uses Internal_Service_Provider_DataType::setInternal_Catalog_Reference()
     * @uses Internal_Service_Provider_DataType::setCompany_or_Company_Hierarchy_Reference()
     * @uses Internal_Service_Provider_DataType::setReview_Date()
     * @uses Internal_Service_Provider_DataType::setNext_Review_Date()
     * @uses Internal_Service_Provider_DataType::setDescription()
     * @uses Internal_Service_Provider_DataType::setRevenue_Category_Reference()
     * @uses Internal_Service_Provider_DataType::setInternal_Service_Provider_Worktag_Reference()
     * @uses Internal_Service_Provider_DataType::setAttachment_Data()
     * @param string $internal_Service_Provider_Reference_ID
     * @param string $internal_Service_Provider_Name
     * @param string $internal_Service_Provider_ID
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @param bool $inactive
     * @param \StructType\Abstract_Procurement_CatalogObjectType[] $internal_Catalog_Reference
     * @param \StructType\OrganizationObjectType[] $company_or_Company_Hierarchy_Reference
     * @param string $review_Date
     * @param string $next_Review_Date
     * @param string $description
     * @param \StructType\Revenue_CategoryObjectType $revenue_Category_Reference
     * @param \StructType\Accounting_WorktagObjectType[] $internal_Service_Provider_Worktag_Reference
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     */
    public function __construct($internal_Service_Provider_Reference_ID = null, $internal_Service_Provider_Name = null, $internal_Service_Provider_ID = null, \StructType\CurrencyObjectType $currency_Reference = null, $inactive = null, array $internal_Catalog_Reference = array(), array $company_or_Company_Hierarchy_Reference = array(), $review_Date = null, $next_Review_Date = null, $description = null, \StructType\Revenue_CategoryObjectType $revenue_Category_Reference = null, array $internal_Service_Provider_Worktag_Reference = array(), array $attachment_Data = array())
    {
        $this
            ->setInternal_Service_Provider_Reference_ID($internal_Service_Provider_Reference_ID)
            ->setInternal_Service_Provider_Name($internal_Service_Provider_Name)
            ->setInternal_Service_Provider_ID($internal_Service_Provider_ID)
            ->setCurrency_Reference($currency_Reference)
            ->setInactive($inactive)
            ->setInternal_Catalog_Reference($internal_Catalog_Reference)
            ->setCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference)
            ->setReview_Date($review_Date)
            ->setNext_Review_Date($next_Review_Date)
            ->setDescription($description)
            ->setRevenue_Category_Reference($revenue_Category_Reference)
            ->setInternal_Service_Provider_Worktag_Reference($internal_Service_Provider_Worktag_Reference)
            ->setAttachment_Data($attachment_Data);
    }
    /**
     * Get Internal_Service_Provider_Reference_ID value
     * @return string|null
     */
    public function getInternal_Service_Provider_Reference_ID()
    {
        return $this->Internal_Service_Provider_Reference_ID;
    }
    /**
     * Set Internal_Service_Provider_Reference_ID value
     * @param string $internal_Service_Provider_Reference_ID
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setInternal_Service_Provider_Reference_ID($internal_Service_Provider_Reference_ID = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Provider_Reference_ID) && !is_string($internal_Service_Provider_Reference_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Provider_Reference_ID, true), gettype($internal_Service_Provider_Reference_ID)), __LINE__);
        }
        $this->Internal_Service_Provider_Reference_ID = $internal_Service_Provider_Reference_ID;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Name value
     * @return string|null
     */
    public function getInternal_Service_Provider_Name()
    {
        return $this->Internal_Service_Provider_Name;
    }
    /**
     * Set Internal_Service_Provider_Name value
     * @param string $internal_Service_Provider_Name
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setInternal_Service_Provider_Name($internal_Service_Provider_Name = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Provider_Name) && !is_string($internal_Service_Provider_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Provider_Name, true), gettype($internal_Service_Provider_Name)), __LINE__);
        }
        $this->Internal_Service_Provider_Name = $internal_Service_Provider_Name;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_ID value
     * @return string|null
     */
    public function getInternal_Service_Provider_ID()
    {
        return $this->Internal_Service_Provider_ID;
    }
    /**
     * Set Internal_Service_Provider_ID value
     * @param string $internal_Service_Provider_ID
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setInternal_Service_Provider_ID($internal_Service_Provider_ID = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Provider_ID) && !is_string($internal_Service_Provider_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Provider_ID, true), gettype($internal_Service_Provider_ID)), __LINE__);
        }
        $this->Internal_Service_Provider_ID = $internal_Service_Provider_ID;
        return $this;
    }
    /**
     * Get Currency_Reference value
     * @return \StructType\CurrencyObjectType|null
     */
    public function getCurrency_Reference()
    {
        return $this->Currency_Reference;
    }
    /**
     * Set Currency_Reference value
     * @param \StructType\CurrencyObjectType $currency_Reference
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setCurrency_Reference(\StructType\CurrencyObjectType $currency_Reference = null)
    {
        $this->Currency_Reference = $currency_Reference;
        return $this;
    }
    /**
     * Get Inactive value
     * @return bool|null
     */
    public function getInactive()
    {
        return $this->Inactive;
    }
    /**
     * Set Inactive value
     * @param bool $inactive
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setInactive($inactive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inactive) && !is_bool($inactive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inactive, true), gettype($inactive)), __LINE__);
        }
        $this->Inactive = $inactive;
        return $this;
    }
    /**
     * Get Internal_Catalog_Reference value
     * @return \StructType\Abstract_Procurement_CatalogObjectType[]|null
     */
    public function getInternal_Catalog_Reference()
    {
        return $this->Internal_Catalog_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Catalog_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Catalog_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Catalog_ReferenceForArrayConstraintsFromSetInternal_Catalog_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_DataTypeInternal_Catalog_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_DataTypeInternal_Catalog_ReferenceItem instanceof \StructType\Abstract_Procurement_CatalogObjectType) {
                $invalidValues[] = is_object($internal_Service_Provider_DataTypeInternal_Catalog_ReferenceItem) ? get_class($internal_Service_Provider_DataTypeInternal_Catalog_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_DataTypeInternal_Catalog_ReferenceItem), var_export($internal_Service_Provider_DataTypeInternal_Catalog_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Catalog_Reference property can only contain items of type \StructType\Abstract_Procurement_CatalogObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Abstract_Procurement_CatalogObjectType[] $internal_Catalog_Reference
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setInternal_Catalog_Reference(array $internal_Catalog_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Catalog_ReferenceArrayErrorMessage = self::validateInternal_Catalog_ReferenceForArrayConstraintsFromSetInternal_Catalog_Reference($internal_Catalog_Reference))) {
            throw new \InvalidArgumentException($internal_Catalog_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Internal_Catalog_Reference = $internal_Catalog_Reference;
        return $this;
    }
    /**
     * Add item to Internal_Catalog_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Abstract_Procurement_CatalogObjectType $item
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function addToInternal_Catalog_Reference(\StructType\Abstract_Procurement_CatalogObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Abstract_Procurement_CatalogObjectType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Catalog_Reference property can only contain items of type \StructType\Abstract_Procurement_CatalogObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Catalog_Reference[] = $item;
        return $this;
    }
    /**
     * Get Company_or_Company_Hierarchy_Reference value
     * @return \StructType\OrganizationObjectType[]|null
     */
    public function getCompany_or_Company_Hierarchy_Reference()
    {
        return $this->Company_or_Company_Hierarchy_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCompany_or_Company_Hierarchy_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompany_or_Company_Hierarchy_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompany_or_Company_Hierarchy_ReferenceForArrayConstraintsFromSetCompany_or_Company_Hierarchy_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_DataTypeCompany_or_Company_Hierarchy_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_DataTypeCompany_or_Company_Hierarchy_ReferenceItem instanceof \StructType\OrganizationObjectType) {
                $invalidValues[] = is_object($internal_Service_Provider_DataTypeCompany_or_Company_Hierarchy_ReferenceItem) ? get_class($internal_Service_Provider_DataTypeCompany_or_Company_Hierarchy_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_DataTypeCompany_or_Company_Hierarchy_ReferenceItem), var_export($internal_Service_Provider_DataTypeCompany_or_Company_Hierarchy_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Company_or_Company_Hierarchy_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Company_or_Company_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType[] $company_or_Company_Hierarchy_Reference
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setCompany_or_Company_Hierarchy_Reference(array $company_or_Company_Hierarchy_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($company_or_Company_Hierarchy_ReferenceArrayErrorMessage = self::validateCompany_or_Company_Hierarchy_ReferenceForArrayConstraintsFromSetCompany_or_Company_Hierarchy_Reference($company_or_Company_Hierarchy_Reference))) {
            throw new \InvalidArgumentException($company_or_Company_Hierarchy_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Company_or_Company_Hierarchy_Reference = $company_or_Company_Hierarchy_Reference;
        return $this;
    }
    /**
     * Add item to Company_or_Company_Hierarchy_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\OrganizationObjectType $item
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function addToCompany_or_Company_Hierarchy_Reference(\StructType\OrganizationObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrganizationObjectType) {
            throw new \InvalidArgumentException(sprintf('The Company_or_Company_Hierarchy_Reference property can only contain items of type \StructType\OrganizationObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Company_or_Company_Hierarchy_Reference[] = $item;
        return $this;
    }
    /**
     * Get Review_Date value
     * @return string|null
     */
    public function getReview_Date()
    {
        return $this->Review_Date;
    }
    /**
     * Set Review_Date value
     * @param string $review_Date
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setReview_Date($review_Date = null)
    {
        // validation for constraint: string
        if (!is_null($review_Date) && !is_string($review_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($review_Date, true), gettype($review_Date)), __LINE__);
        }
        $this->Review_Date = $review_Date;
        return $this;
    }
    /**
     * Get Next_Review_Date value
     * @return string|null
     */
    public function getNext_Review_Date()
    {
        return $this->Next_Review_Date;
    }
    /**
     * Set Next_Review_Date value
     * @param string $next_Review_Date
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setNext_Review_Date($next_Review_Date = null)
    {
        // validation for constraint: string
        if (!is_null($next_Review_Date) && !is_string($next_Review_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($next_Review_Date, true), gettype($next_Review_Date)), __LINE__);
        }
        $this->Next_Review_Date = $next_Review_Date;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Revenue_Category_Reference value
     * @return \StructType\Revenue_CategoryObjectType|null
     */
    public function getRevenue_Category_Reference()
    {
        return $this->Revenue_Category_Reference;
    }
    /**
     * Set Revenue_Category_Reference value
     * @param \StructType\Revenue_CategoryObjectType $revenue_Category_Reference
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setRevenue_Category_Reference(\StructType\Revenue_CategoryObjectType $revenue_Category_Reference = null)
    {
        $this->Revenue_Category_Reference = $revenue_Category_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Provider_Worktag_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getInternal_Service_Provider_Worktag_Reference()
    {
        return $this->Internal_Service_Provider_Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Provider_Worktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Provider_Worktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Provider_Worktag_ReferenceForArrayConstraintsFromSetInternal_Service_Provider_Worktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_DataTypeInternal_Service_Provider_Worktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_DataTypeInternal_Service_Provider_Worktag_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($internal_Service_Provider_DataTypeInternal_Service_Provider_Worktag_ReferenceItem) ? get_class($internal_Service_Provider_DataTypeInternal_Service_Provider_Worktag_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_DataTypeInternal_Service_Provider_Worktag_ReferenceItem), var_export($internal_Service_Provider_DataTypeInternal_Service_Provider_Worktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Provider_Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Provider_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $internal_Service_Provider_Worktag_Reference
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setInternal_Service_Provider_Worktag_Reference(array $internal_Service_Provider_Worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Provider_Worktag_ReferenceArrayErrorMessage = self::validateInternal_Service_Provider_Worktag_ReferenceForArrayConstraintsFromSetInternal_Service_Provider_Worktag_Reference($internal_Service_Provider_Worktag_Reference))) {
            throw new \InvalidArgumentException($internal_Service_Provider_Worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Provider_Worktag_Reference = $internal_Service_Provider_Worktag_Reference;
        return $this;
    }
    /**
     * Add item to Internal_Service_Provider_Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function addToInternal_Service_Provider_Worktag_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Provider_Worktag_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Provider_Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Attachment_Data value
     * @return \StructType\Financials_Attachment_DataType[]|null
     */
    public function getAttachment_Data()
    {
        return $this->Attachment_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAttachment_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAttachment_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAttachment_DataForArrayConstraintsFromSetAttachment_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Provider_DataTypeAttachment_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Provider_DataTypeAttachment_DataItem instanceof \StructType\Financials_Attachment_DataType) {
                $invalidValues[] = is_object($internal_Service_Provider_DataTypeAttachment_DataItem) ? get_class($internal_Service_Provider_DataTypeAttachment_DataItem) : sprintf('%s(%s)', gettype($internal_Service_Provider_DataTypeAttachment_DataItem), var_export($internal_Service_Provider_DataTypeAttachment_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType[] $attachment_Data
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function setAttachment_Data(array $attachment_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($attachment_DataArrayErrorMessage = self::validateAttachment_DataForArrayConstraintsFromSetAttachment_Data($attachment_Data))) {
            throw new \InvalidArgumentException($attachment_DataArrayErrorMessage, __LINE__);
        }
        $this->Attachment_Data = $attachment_Data;
        return $this;
    }
    /**
     * Add item to Attachment_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Financials_Attachment_DataType $item
     * @return \StructType\Internal_Service_Provider_DataType
     */
    public function addToAttachment_Data(\StructType\Financials_Attachment_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Financials_Attachment_DataType) {
            throw new \InvalidArgumentException(sprintf('The Attachment_Data property can only contain items of type \StructType\Financials_Attachment_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Attachment_Data[] = $item;
        return $this;
    }
}
