<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Delivery_OutboundType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents the Reference to the Internal Service Delivery Document along with its content
 * @subpackage Structs
 */
class Internal_Service_Delivery_OutboundType extends AbstractStructBase
{
    /**
     * The Internal_Service_Delivery_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Internal Service Delivery.
     * - minOccurs: 0
     * @var \StructType\Internal_Service_DeliveryObjectType
     */
    public $Internal_Service_Delivery_Reference;
    /**
     * The Internal_Service_Delivery_Data
     * Meta information extracted from the WSDL
     * - documentation: Element that represents the contents of the entire Internal Service Delivery, including Lines (with and without splits) and Attachments.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Delivery_Data_OutboundType[]
     */
    public $Internal_Service_Delivery_Data;
    /**
     * Constructor method for Internal_Service_Delivery_OutboundType
     * @uses Internal_Service_Delivery_OutboundType::setInternal_Service_Delivery_Reference()
     * @uses Internal_Service_Delivery_OutboundType::setInternal_Service_Delivery_Data()
     * @param \StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference
     * @param \StructType\Internal_Service_Delivery_Data_OutboundType[] $internal_Service_Delivery_Data
     */
    public function __construct(\StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference = null, array $internal_Service_Delivery_Data = array())
    {
        $this
            ->setInternal_Service_Delivery_Reference($internal_Service_Delivery_Reference)
            ->setInternal_Service_Delivery_Data($internal_Service_Delivery_Data);
    }
    /**
     * Get Internal_Service_Delivery_Reference value
     * @return \StructType\Internal_Service_DeliveryObjectType|null
     */
    public function getInternal_Service_Delivery_Reference()
    {
        return $this->Internal_Service_Delivery_Reference;
    }
    /**
     * Set Internal_Service_Delivery_Reference value
     * @param \StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference
     * @return \StructType\Internal_Service_Delivery_OutboundType
     */
    public function setInternal_Service_Delivery_Reference(\StructType\Internal_Service_DeliveryObjectType $internal_Service_Delivery_Reference = null)
    {
        $this->Internal_Service_Delivery_Reference = $internal_Service_Delivery_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Delivery_Data value
     * @return \StructType\Internal_Service_Delivery_Data_OutboundType[]|null
     */
    public function getInternal_Service_Delivery_Data()
    {
        return $this->Internal_Service_Delivery_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Delivery_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Delivery_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Delivery_DataForArrayConstraintsFromSetInternal_Service_Delivery_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_OutboundTypeInternal_Service_Delivery_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_OutboundTypeInternal_Service_Delivery_DataItem instanceof \StructType\Internal_Service_Delivery_Data_OutboundType) {
                $invalidValues[] = is_object($internal_Service_Delivery_OutboundTypeInternal_Service_Delivery_DataItem) ? get_class($internal_Service_Delivery_OutboundTypeInternal_Service_Delivery_DataItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_OutboundTypeInternal_Service_Delivery_DataItem), var_export($internal_Service_Delivery_OutboundTypeInternal_Service_Delivery_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Delivery_Data property can only contain items of type \StructType\Internal_Service_Delivery_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Delivery_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Data_OutboundType[] $internal_Service_Delivery_Data
     * @return \StructType\Internal_Service_Delivery_OutboundType
     */
    public function setInternal_Service_Delivery_Data(array $internal_Service_Delivery_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Delivery_DataArrayErrorMessage = self::validateInternal_Service_Delivery_DataForArrayConstraintsFromSetInternal_Service_Delivery_Data($internal_Service_Delivery_Data))) {
            throw new \InvalidArgumentException($internal_Service_Delivery_DataArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Delivery_Data = $internal_Service_Delivery_Data;
        return $this;
    }
    /**
     * Add item to Internal_Service_Delivery_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Data_OutboundType $item
     * @return \StructType\Internal_Service_Delivery_OutboundType
     */
    public function addToInternal_Service_Delivery_Data(\StructType\Internal_Service_Delivery_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_Delivery_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Delivery_Data property can only contain items of type \StructType\Internal_Service_Delivery_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Delivery_Data[] = $item;
        return $this;
    }
}
