<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Internal_Service_Delivery_Line_Data_OutboundType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element that represents Internal Service Delivery Line information. An Internal Service Delivery may have multiple lines, with or without Splits.
 * @subpackage Structs
 */
class Internal_Service_Delivery_Line_Data_OutboundType extends AbstractStructBase
{
    /**
     * The Internal_Service_Delivery_Line_ID
     * Meta information extracted from the WSDL
     * - documentation: Reference ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Internal_Service_Delivery_Line_ID;
    /**
     * The Internal_Service_Delivery_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Delivery Line Reference
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Delivery_LineObjectType
     */
    public $Internal_Service_Delivery_Line_Reference;
    /**
     * The Internal_Service_Delivery_Line_Number
     * Meta information extracted from the WSDL
     * - documentation: Internal Service Delivery Line Number | Internal Service Delivery Line Number. This should be unique for each Internal Service Delivery Line.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 5
     * @var float
     */
    public $Internal_Service_Delivery_Line_Number;
    /**
     * The Intercompany_Affiliate_Reference
     * Meta information extracted from the WSDL
     * - documentation: Intercompany Affiliate on the Internal Service Delivery Line.
     * - minOccurs: 0
     * @var \StructType\CompanyObjectType
     */
    public $Intercompany_Affiliate_Reference;
    /**
     * The Catalog_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item on the Internal Service Delivery Line.
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Catalog_Item_Reference;
    /**
     * The Item_Description
     * Meta information extracted from the WSDL
     * - documentation: Item Description on the Internal Service Delivery Line. If a Catalog Item is used on the line, then the description of the catalog item is returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Item_Description;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Spend Category on the Internal Service Delivery Line. If Item is referenced on the Line, then the Item's Spend Category is returned.
     * - minOccurs: 0
     * @var \StructType\Accounting_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Revenue_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: Revenue Category on the Internal Service Delivery Line.
     * - minOccurs: 0
     * @var \StructType\Revenue_CategoryObjectType
     */
    public $Revenue_Category_Reference;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: The quantity of the Purchase Item ordered. Quantity will be defaulted to 1 if left blank. | Quantity for the expense report line. Leave blank if you are entering a credit card transaction. | Quantity to receive | Number of units to
     * assign. | Quantity for the Spend Authorization Line | You must enter a Quantity when Line Split Allocation Reference is Split by Quantity. | Quantity must be empty when Line Split Allocation Reference is Split by Amount. | The number of units |
     * Quantity. If you supply this value as an override, you must also enable the Override Line flag. | Although Supplier Invoice Schedules may distribute installments by Amount or Quantity, Purchase Order Schedules always distribute by Quantity. |
     * Quantity of the asset component. | Quantity Returned | If this is blank, Workday will automatically calculate quantity from unit cost and extended amount. But if the line references either a Purchase Order or Contract Line, the quantity must be blank
     * and extended amount will not be calculated. | Quantity on Request for Quote Line. | The quantity for the split line. This is optional and should be absent when we split by amount. | Quantity on Award Line Split. | The quantity of the Purchase Item
     * ordered. For new line, quantity will be defaulted to 1 if left blank. | The quantity for the split line. This is optional and should be absent when splitting by amount. | Quantity on the Internal Service Delivery Line. | The quantity for the split
     * line. This is optional and will not be populated when the Internal Service Delivery Line is split by amount. | Quantity on the Internal Service Delivery Line. If the Internal Service Delivery Line references a Catalog Item, then Quantity cannot be
     * blank. | Quantity on the Internal Service Delivery Line Split. This is optional and must not be included when the Internal Service Delivery Line is split by Amount. | Quantity on the Supplier Invoice Request Line | The quantity for the split line.
     * This is optional and will not be populated when the Supplier Invoice Request Line is split by amount. | Quantity for the Supplier Invoice Request Line | Quantity on the Supplier Invoice Request Line Split. This is optional and must not be included
     * when the Supplier Invoice Request Line is split by Amount. | Shipped Quantity for Lot | Refers to the supplier item quantity for the POA line. | Quantity for Purchase Order LinecXML Notes:Request/OrderRequest/OrderRequestHeader/ItemOut@quantity |
     * Quantity for Requisition Line | Quantity | Item Lot Quantity
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 22
     * @var float
     */
    public $Quantity;
    /**
     * The Unit_of_Measure_Reference
     * Meta information extracted from the WSDL
     * - documentation: Unit of Measure on the Internal Service Delivery Line. This is optional and is relevant only if Quantity is also present on the line.
     * - minOccurs: 0
     * @var \StructType\Unit_of_MeasureObjectType
     */
    public $Unit_of_Measure_Reference;
    /**
     * The Unit_Cost
     * Meta information extracted from the WSDL
     * - documentation: Unit Cost for the Spend Authorization Line | Installment Line Unit Cost. If you supply this value as an override, you must also enable the Override Line flag. The Unit Cost can only be entered for Supplier Invoice Schedules
     * distributed by Amount. | Unit Cost for Return. If not provided this will be derived from the parent document line. | Unit cost of the asset component. | This is the Unit Price. If this is blank, Workday will default the unit price from the item if
     * one is configured. If invoice line has a quantity and unit price, then Workday will automatically calculate extended amount.. But if the line references either a Service or Project-Based Purchase Order or Contract Line, the Unit Price must be blank.
     * | Unit Cost on RFQ Award Line | The unit cost of the item specified in the currency associated to the Purchase Order currency. | Unit Cost on the Internal Service Delivery line. | Unit Cost of the Service provided. This is required only if Quantity
     * is also specified on the Internal Service Delivery Line. | Unit Cost on the Supplier Invoice Request Line | This is the Unit Price. | Refers to the item unit cost on the POA line. | Purchase Order Line Unit CostcXML
     * Notes:Request/OrderRequest/OrderRequestHeader/ItemOut/ItemDetail/UnitPrice | Unit Cost for Requisition Line | Unit Cost | Unit Cost for Receipt Adjustment Line. This field is outbound only; any data submitted will be ignored.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Unit_Cost;
    /**
     * The Extended_Amount
     * Meta information extracted from the WSDL
     * - documentation: The Extended Amount for the Project-Based Order Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Order Line. | The Extended Amount for the Contingent Worker Order Line.
     * | The control value Entered for Extended Amount does not match calculated Extended Amount. Extended Amount is an optional field but it can be used to control the anticipated line amount. If you do not wish to control the line amount, please leave
     * this field blank. | The Extended Amount for the Project-Based Requisition Line. This amount is automatically calculated by adding the amounts of the multiple subtasks of the Project-Based Requisition Line. | This is the invoice line amount. If the
     * invoice line has a quantity and unit price, then Workday will automatically calculate extended amount. | Transaction Extended Amount | The Extended Amount for the Service Order Line. This value must be the same sign as the Requisition Line Reference
     * or zero, if present, and must be positive if there is a Supplier Contract Line Reference, if present. | The Extended Amount for the RFQ Goods line. This amount is automatically calculated by multiplying the Quantity by the Unit Cost in the currency
     * specified on the Goods Line. | Service Line Extended Amount should be greater than zero. | Amount to Receive | Extended amount for the split line. This is an optional field for split line. If value is present it must be equal to Quantity times Unit
     * Cost of parent line. | Extended Amount on Award Line Split | The extended amount for the split line. This is always required and must be correct (quantity * unit cost of parent line). | The Extended Amount for the Purchase Order line. This amount is
     * automatically calculated by multiplying the Quantity by the Unit Cost in the currency specified on the Purchase Order. | Extended Amount on the Internal Service Delivery Line. If Unit Cost and Quantity are present on the line, Extended Amount is
     * always equal to their product. | Extended amount for the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Internal Service Delivery Line. | Internal Service Delivery Line Amount. If Unit Cost and
     * Quantity are also specified on the Internal Service Delivery Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Internal Service Delivery Line Split. This is always required and the total Line Split amount must equal the
     * (Unit Cost * Quantity) of the parent Internal Service Delivery Line. | Extended Amount on the Supplier Invoice Request Line. If Unit Cost and Quantity are present on the line, Extended Amount is always equal to their product. | Extended amount for
     * the split line. This is an optional field ,but if present it is equal to Quantity times Unit Cost of parent Supplier Invoice Request Line. | Supplier Invoice Request Line Extended Amount. If Unit Cost and Quantity are also specified on the Supplier
     * Invoice Request Line, then Extended Amount must equal Unit Cost * Quantity. | Amount on the Supplier Invoice Request Line Split. This is always required and the total Line Split amount must equal the (Unit Cost * Quantity) of the parent Supplier
     * Invoice Request Line. | Extended Amount on the Advanced Ship Notice Line. | Purchase Order Line Amount | The Extended Amount for the Service Line | The Extended Amount for the Requisition line. This amount is automatically calculated by multiplying
     * the Quantity by the Unit Cost in the currency specified on the Requisition. | Extended Amount | The Actual Quantity Received for this Line. | The Extended Amount for the Receipt Adjustment line. This amount is automatically calculated by multiplying
     * the Actual Quantity to Receive by the Unit Cost in the currency specified on the Receipt.
     * - base: xsd:decimal
     * - fractionDigits: 3
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 18
     * @var float
     */
    public $Extended_Amount;
    /**
     * The Requester_Reference
     * Meta information extracted from the WSDL
     * - documentation: Requester on the Internal Service Delivery line. This could be either an Employee or a Contingent Worker.
     * - minOccurs: 0
     * @var \StructType\WorkerObjectType
     */
    public $Requester_Reference;
    /**
     * The Delivery_Date
     * Meta information extracted from the WSDL
     * - documentation: Date on which the service was requested.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Delivery_Date;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo on the Internal Service Delivery Line.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: Worktags entered on the Internal Service Delivery Line.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Worktags_Reference;
    /**
     * The Internal_Service_Delivery_Line_Splits_Data
     * Meta information extracted from the WSDL
     * - documentation: Optional element that represents Split information for the Internal Service Delivery Line.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType[]
     */
    public $Internal_Service_Delivery_Line_Splits_Data;
    /**
     * Constructor method for Internal_Service_Delivery_Line_Data_OutboundType
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setInternal_Service_Delivery_Line_ID()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setInternal_Service_Delivery_Line_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setInternal_Service_Delivery_Line_Number()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setIntercompany_Affiliate_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setCatalog_Item_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setItem_Description()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setSpend_Category_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setRevenue_Category_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setQuantity()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setUnit_of_Measure_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setUnit_Cost()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setExtended_Amount()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setRequester_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setDelivery_Date()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setMemo()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setWorktags_Reference()
     * @uses Internal_Service_Delivery_Line_Data_OutboundType::setInternal_Service_Delivery_Line_Splits_Data()
     * @param string $internal_Service_Delivery_Line_ID
     * @param \StructType\Internal_Service_Delivery_LineObjectType $internal_Service_Delivery_Line_Reference
     * @param float $internal_Service_Delivery_Line_Number
     * @param \StructType\CompanyObjectType $intercompany_Affiliate_Reference
     * @param \StructType\Item_DescriptorObjectType $catalog_Item_Reference
     * @param string $item_Description
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Revenue_CategoryObjectType $revenue_Category_Reference
     * @param float $quantity
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @param float $unit_Cost
     * @param float $extended_Amount
     * @param \StructType\WorkerObjectType $requester_Reference
     * @param string $delivery_Date
     * @param string $memo
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @param \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType[] $internal_Service_Delivery_Line_Splits_Data
     */
    public function __construct($internal_Service_Delivery_Line_ID = null, \StructType\Internal_Service_Delivery_LineObjectType $internal_Service_Delivery_Line_Reference = null, $internal_Service_Delivery_Line_Number = null, \StructType\CompanyObjectType $intercompany_Affiliate_Reference = null, \StructType\Item_DescriptorObjectType $catalog_Item_Reference = null, $item_Description = null, \StructType\Accounting_CategoryObjectType $spend_Category_Reference = null, \StructType\Revenue_CategoryObjectType $revenue_Category_Reference = null, $quantity = null, \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null, $unit_Cost = null, $extended_Amount = null, \StructType\WorkerObjectType $requester_Reference = null, $delivery_Date = null, $memo = null, array $worktags_Reference = array(), array $internal_Service_Delivery_Line_Splits_Data = array())
    {
        $this
            ->setInternal_Service_Delivery_Line_ID($internal_Service_Delivery_Line_ID)
            ->setInternal_Service_Delivery_Line_Reference($internal_Service_Delivery_Line_Reference)
            ->setInternal_Service_Delivery_Line_Number($internal_Service_Delivery_Line_Number)
            ->setIntercompany_Affiliate_Reference($intercompany_Affiliate_Reference)
            ->setCatalog_Item_Reference($catalog_Item_Reference)
            ->setItem_Description($item_Description)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setRevenue_Category_Reference($revenue_Category_Reference)
            ->setQuantity($quantity)
            ->setUnit_of_Measure_Reference($unit_of_Measure_Reference)
            ->setUnit_Cost($unit_Cost)
            ->setExtended_Amount($extended_Amount)
            ->setRequester_Reference($requester_Reference)
            ->setDelivery_Date($delivery_Date)
            ->setMemo($memo)
            ->setWorktags_Reference($worktags_Reference)
            ->setInternal_Service_Delivery_Line_Splits_Data($internal_Service_Delivery_Line_Splits_Data);
    }
    /**
     * Get Internal_Service_Delivery_Line_ID value
     * @return string|null
     */
    public function getInternal_Service_Delivery_Line_ID()
    {
        return $this->Internal_Service_Delivery_Line_ID;
    }
    /**
     * Set Internal_Service_Delivery_Line_ID value
     * @param string $internal_Service_Delivery_Line_ID
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setInternal_Service_Delivery_Line_ID($internal_Service_Delivery_Line_ID = null)
    {
        // validation for constraint: string
        if (!is_null($internal_Service_Delivery_Line_ID) && !is_string($internal_Service_Delivery_Line_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internal_Service_Delivery_Line_ID, true), gettype($internal_Service_Delivery_Line_ID)), __LINE__);
        }
        $this->Internal_Service_Delivery_Line_ID = $internal_Service_Delivery_Line_ID;
        return $this;
    }
    /**
     * Get Internal_Service_Delivery_Line_Reference value
     * @return \StructType\Internal_Service_Delivery_LineObjectType|null
     */
    public function getInternal_Service_Delivery_Line_Reference()
    {
        return $this->Internal_Service_Delivery_Line_Reference;
    }
    /**
     * Set Internal_Service_Delivery_Line_Reference value
     * @param \StructType\Internal_Service_Delivery_LineObjectType $internal_Service_Delivery_Line_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setInternal_Service_Delivery_Line_Reference(\StructType\Internal_Service_Delivery_LineObjectType $internal_Service_Delivery_Line_Reference = null)
    {
        $this->Internal_Service_Delivery_Line_Reference = $internal_Service_Delivery_Line_Reference;
        return $this;
    }
    /**
     * Get Internal_Service_Delivery_Line_Number value
     * @return float|null
     */
    public function getInternal_Service_Delivery_Line_Number()
    {
        return $this->Internal_Service_Delivery_Line_Number;
    }
    /**
     * Set Internal_Service_Delivery_Line_Number value
     * @param float $internal_Service_Delivery_Line_Number
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setInternal_Service_Delivery_Line_Number($internal_Service_Delivery_Line_Number = null)
    {
        // validation for constraint: float
        if (!is_null($internal_Service_Delivery_Line_Number) && !(is_float($internal_Service_Delivery_Line_Number) || is_numeric($internal_Service_Delivery_Line_Number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($internal_Service_Delivery_Line_Number, true), gettype($internal_Service_Delivery_Line_Number)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($internal_Service_Delivery_Line_Number) && mb_strlen(mb_substr($internal_Service_Delivery_Line_Number, false !== mb_strpos($internal_Service_Delivery_Line_Number, '.') ? mb_strpos($internal_Service_Delivery_Line_Number, '.') + 1 : mb_strlen($internal_Service_Delivery_Line_Number))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($internal_Service_Delivery_Line_Number, true), mb_strlen(mb_substr($internal_Service_Delivery_Line_Number, mb_strpos($internal_Service_Delivery_Line_Number, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($internal_Service_Delivery_Line_Number) && $internal_Service_Delivery_Line_Number < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($internal_Service_Delivery_Line_Number, true)), __LINE__);
        }
        // validation for constraint: totalDigits(5)
        if (!is_null($internal_Service_Delivery_Line_Number) && mb_strlen(preg_replace('/(\D)/', '', $internal_Service_Delivery_Line_Number)) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 5 digits, "%d" given', var_export($internal_Service_Delivery_Line_Number, true), mb_strlen(preg_replace('/(\D)/', '', $internal_Service_Delivery_Line_Number))), __LINE__);
        }
        $this->Internal_Service_Delivery_Line_Number = $internal_Service_Delivery_Line_Number;
        return $this;
    }
    /**
     * Get Intercompany_Affiliate_Reference value
     * @return \StructType\CompanyObjectType|null
     */
    public function getIntercompany_Affiliate_Reference()
    {
        return $this->Intercompany_Affiliate_Reference;
    }
    /**
     * Set Intercompany_Affiliate_Reference value
     * @param \StructType\CompanyObjectType $intercompany_Affiliate_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setIntercompany_Affiliate_Reference(\StructType\CompanyObjectType $intercompany_Affiliate_Reference = null)
    {
        $this->Intercompany_Affiliate_Reference = $intercompany_Affiliate_Reference;
        return $this;
    }
    /**
     * Get Catalog_Item_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getCatalog_Item_Reference()
    {
        return $this->Catalog_Item_Reference;
    }
    /**
     * Set Catalog_Item_Reference value
     * @param \StructType\Item_DescriptorObjectType $catalog_Item_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setCatalog_Item_Reference(\StructType\Item_DescriptorObjectType $catalog_Item_Reference = null)
    {
        $this->Catalog_Item_Reference = $catalog_Item_Reference;
        return $this;
    }
    /**
     * Get Item_Description value
     * @return string|null
     */
    public function getItem_Description()
    {
        return $this->Item_Description;
    }
    /**
     * Set Item_Description value
     * @param string $item_Description
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setItem_Description($item_Description = null)
    {
        // validation for constraint: string
        if (!is_null($item_Description) && !is_string($item_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($item_Description, true), gettype($item_Description)), __LINE__);
        }
        $this->Item_Description = $item_Description;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Accounting_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Accounting_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setSpend_Category_Reference(\StructType\Accounting_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Revenue_Category_Reference value
     * @return \StructType\Revenue_CategoryObjectType|null
     */
    public function getRevenue_Category_Reference()
    {
        return $this->Revenue_Category_Reference;
    }
    /**
     * Set Revenue_Category_Reference value
     * @param \StructType\Revenue_CategoryObjectType $revenue_Category_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setRevenue_Category_Reference(\StructType\Revenue_CategoryObjectType $revenue_Category_Reference = null)
    {
        $this->Revenue_Category_Reference = $revenue_Category_Reference;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($quantity) && mb_strlen(mb_substr($quantity, false !== mb_strpos($quantity, '.') ? mb_strpos($quantity, '.') + 1 : mb_strlen($quantity))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($quantity, true), mb_strlen(mb_substr($quantity, mb_strpos($quantity, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(22)
        if (!is_null($quantity) && mb_strlen(preg_replace('/(\D)/', '', $quantity)) > 22) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 22 digits, "%d" given', var_export($quantity, true), mb_strlen(preg_replace('/(\D)/', '', $quantity))), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Unit_of_Measure_Reference value
     * @return \StructType\Unit_of_MeasureObjectType|null
     */
    public function getUnit_of_Measure_Reference()
    {
        return $this->Unit_of_Measure_Reference;
    }
    /**
     * Set Unit_of_Measure_Reference value
     * @param \StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setUnit_of_Measure_Reference(\StructType\Unit_of_MeasureObjectType $unit_of_Measure_Reference = null)
    {
        $this->Unit_of_Measure_Reference = $unit_of_Measure_Reference;
        return $this;
    }
    /**
     * Get Unit_Cost value
     * @return float|null
     */
    public function getUnit_Cost()
    {
        return $this->Unit_Cost;
    }
    /**
     * Set Unit_Cost value
     * @param float $unit_Cost
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setUnit_Cost($unit_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($unit_Cost) && !(is_float($unit_Cost) || is_numeric($unit_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($unit_Cost, true), gettype($unit_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($unit_Cost) && mb_strlen(mb_substr($unit_Cost, false !== mb_strpos($unit_Cost, '.') ? mb_strpos($unit_Cost, '.') + 1 : mb_strlen($unit_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($unit_Cost, true), mb_strlen(mb_substr($unit_Cost, mb_strpos($unit_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($unit_Cost) && mb_strlen(preg_replace('/(\D)/', '', $unit_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($unit_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $unit_Cost))), __LINE__);
        }
        $this->Unit_Cost = $unit_Cost;
        return $this;
    }
    /**
     * Get Extended_Amount value
     * @return float|null
     */
    public function getExtended_Amount()
    {
        return $this->Extended_Amount;
    }
    /**
     * Set Extended_Amount value
     * @param float $extended_Amount
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setExtended_Amount($extended_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($extended_Amount) && !(is_float($extended_Amount) || is_numeric($extended_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($extended_Amount, true), gettype($extended_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(3)
        if (!is_null($extended_Amount) && mb_strlen(mb_substr($extended_Amount, false !== mb_strpos($extended_Amount, '.') ? mb_strpos($extended_Amount, '.') + 1 : mb_strlen($extended_Amount))) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 3 fraction digits, %d given', var_export($extended_Amount, true), mb_strlen(mb_substr($extended_Amount, mb_strpos($extended_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(18)
        if (!is_null($extended_Amount) && mb_strlen(preg_replace('/(\D)/', '', $extended_Amount)) > 18) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 18 digits, "%d" given', var_export($extended_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $extended_Amount))), __LINE__);
        }
        $this->Extended_Amount = $extended_Amount;
        return $this;
    }
    /**
     * Get Requester_Reference value
     * @return \StructType\WorkerObjectType|null
     */
    public function getRequester_Reference()
    {
        return $this->Requester_Reference;
    }
    /**
     * Set Requester_Reference value
     * @param \StructType\WorkerObjectType $requester_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setRequester_Reference(\StructType\WorkerObjectType $requester_Reference = null)
    {
        $this->Requester_Reference = $requester_Reference;
        return $this;
    }
    /**
     * Get Delivery_Date value
     * @return string|null
     */
    public function getDelivery_Date()
    {
        return $this->Delivery_Date;
    }
    /**
     * Set Delivery_Date value
     * @param string $delivery_Date
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setDelivery_Date($delivery_Date = null)
    {
        // validation for constraint: string
        if (!is_null($delivery_Date) && !is_string($delivery_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delivery_Date, true), gettype($delivery_Date)), __LINE__);
        }
        $this->Delivery_Date = $delivery_Date;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getWorktags_Reference()
    {
        return $this->Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Line_Data_OutboundTypeWorktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Line_Data_OutboundTypeWorktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Line_Data_OutboundTypeWorktags_ReferenceItem) ? get_class($internal_Service_Delivery_Line_Data_OutboundTypeWorktags_ReferenceItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Line_Data_OutboundTypeWorktags_ReferenceItem), var_export($internal_Service_Delivery_Line_Data_OutboundTypeWorktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $worktags_Reference
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setWorktags_Reference(array $worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktags_ReferenceArrayErrorMessage = self::validateWorktags_ReferenceForArrayConstraintsFromSetWorktags_Reference($worktags_Reference))) {
            throw new \InvalidArgumentException($worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktags_Reference = $worktags_Reference;
        return $this;
    }
    /**
     * Add item to Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function addToWorktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktags_Reference[] = $item;
        return $this;
    }
    /**
     * Get Internal_Service_Delivery_Line_Splits_Data value
     * @return \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType[]|null
     */
    public function getInternal_Service_Delivery_Line_Splits_Data()
    {
        return $this->Internal_Service_Delivery_Line_Splits_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setInternal_Service_Delivery_Line_Splits_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternal_Service_Delivery_Line_Splits_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternal_Service_Delivery_Line_Splits_DataForArrayConstraintsFromSetInternal_Service_Delivery_Line_Splits_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $internal_Service_Delivery_Line_Data_OutboundTypeInternal_Service_Delivery_Line_Splits_DataItem) {
            // validation for constraint: itemType
            if (!$internal_Service_Delivery_Line_Data_OutboundTypeInternal_Service_Delivery_Line_Splits_DataItem instanceof \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType) {
                $invalidValues[] = is_object($internal_Service_Delivery_Line_Data_OutboundTypeInternal_Service_Delivery_Line_Splits_DataItem) ? get_class($internal_Service_Delivery_Line_Data_OutboundTypeInternal_Service_Delivery_Line_Splits_DataItem) : sprintf('%s(%s)', gettype($internal_Service_Delivery_Line_Data_OutboundTypeInternal_Service_Delivery_Line_Splits_DataItem), var_export($internal_Service_Delivery_Line_Data_OutboundTypeInternal_Service_Delivery_Line_Splits_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Internal_Service_Delivery_Line_Splits_Data property can only contain items of type \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Internal_Service_Delivery_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType[] $internal_Service_Delivery_Line_Splits_Data
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function setInternal_Service_Delivery_Line_Splits_Data(array $internal_Service_Delivery_Line_Splits_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($internal_Service_Delivery_Line_Splits_DataArrayErrorMessage = self::validateInternal_Service_Delivery_Line_Splits_DataForArrayConstraintsFromSetInternal_Service_Delivery_Line_Splits_Data($internal_Service_Delivery_Line_Splits_Data))) {
            throw new \InvalidArgumentException($internal_Service_Delivery_Line_Splits_DataArrayErrorMessage, __LINE__);
        }
        $this->Internal_Service_Delivery_Line_Splits_Data = $internal_Service_Delivery_Line_Splits_Data;
        return $this;
    }
    /**
     * Add item to Internal_Service_Delivery_Line_Splits_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType $item
     * @return \StructType\Internal_Service_Delivery_Line_Data_OutboundType
     */
    public function addToInternal_Service_Delivery_Line_Splits_Data(\StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType) {
            throw new \InvalidArgumentException(sprintf('The Internal_Service_Delivery_Line_Splits_Data property can only contain items of type \StructType\Internal_Service_Delivery_Line_Split_Data_OutboundType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Internal_Service_Delivery_Line_Splits_Data[] = $item;
        return $this;
    }
}
