<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Guest_Header__HV__RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Web Service is set to Add Only; but the Guest Listing File already exists. | Guest Header Request.
 * @subpackage Structs
 */
class Guest_Header__HV__RequestType extends AbstractStructBase
{
    /**
     * The Guest_Listing_File_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Guest Listing File for update only purposes.
     * - minOccurs: 0
     * @var \StructType\Guest_Listing_FileObjectType
     */
    public $Guest_Listing_File_Reference;
    /**
     * The Guest_Listing_File_Data
     * Meta information extracted from the WSDL
     * - documentation: Guest Listing File Data
     * @var \StructType\Guest_Listing_File__HV__DataType
     */
    public $Guest_Listing_File_Data;
    /**
     * The Add_Only
     * Meta information extracted from the WSDL
     * - documentation: Add Only Flag. Indicates that the service is an add only, not an update.
     * @var bool
     */
    public $Add_Only;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Guest_Header__HV__RequestType
     * @uses Guest_Header__HV__RequestType::setGuest_Listing_File_Reference()
     * @uses Guest_Header__HV__RequestType::setGuest_Listing_File_Data()
     * @uses Guest_Header__HV__RequestType::setAdd_Only()
     * @uses Guest_Header__HV__RequestType::setVersion()
     * @param \StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference
     * @param \StructType\Guest_Listing_File__HV__DataType $guest_Listing_File_Data
     * @param bool $add_Only
     * @param string $version
     */
    public function __construct(\StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference = null, \StructType\Guest_Listing_File__HV__DataType $guest_Listing_File_Data = null, $add_Only = null, $version = null)
    {
        $this
            ->setGuest_Listing_File_Reference($guest_Listing_File_Reference)
            ->setGuest_Listing_File_Data($guest_Listing_File_Data)
            ->setAdd_Only($add_Only)
            ->setVersion($version);
    }
    /**
     * Get Guest_Listing_File_Reference value
     * @return \StructType\Guest_Listing_FileObjectType|null
     */
    public function getGuest_Listing_File_Reference()
    {
        return $this->Guest_Listing_File_Reference;
    }
    /**
     * Set Guest_Listing_File_Reference value
     * @param \StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference
     * @return \StructType\Guest_Header__HV__RequestType
     */
    public function setGuest_Listing_File_Reference(\StructType\Guest_Listing_FileObjectType $guest_Listing_File_Reference = null)
    {
        $this->Guest_Listing_File_Reference = $guest_Listing_File_Reference;
        return $this;
    }
    /**
     * Get Guest_Listing_File_Data value
     * @return \StructType\Guest_Listing_File__HV__DataType|null
     */
    public function getGuest_Listing_File_Data()
    {
        return $this->Guest_Listing_File_Data;
    }
    /**
     * Set Guest_Listing_File_Data value
     * @param \StructType\Guest_Listing_File__HV__DataType $guest_Listing_File_Data
     * @return \StructType\Guest_Header__HV__RequestType
     */
    public function setGuest_Listing_File_Data(\StructType\Guest_Listing_File__HV__DataType $guest_Listing_File_Data = null)
    {
        $this->Guest_Listing_File_Data = $guest_Listing_File_Data;
        return $this;
    }
    /**
     * Get Add_Only value
     * @return bool|null
     */
    public function getAdd_Only()
    {
        return $this->Add_Only;
    }
    /**
     * Set Add_Only value
     * @param bool $add_Only
     * @return \StructType\Guest_Header__HV__RequestType
     */
    public function setAdd_Only($add_Only = null)
    {
        // validation for constraint: boolean
        if (!is_null($add_Only) && !is_bool($add_Only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($add_Only, true), gettype($add_Only)), __LINE__);
        }
        $this->Add_Only = $add_Only;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Guest_Header__HV__RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
