<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Fulfillment_Attributes_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Attributes related to fulfillment for the Site/Item combination.
 * @subpackage Structs
 */
class Fulfillment_Attributes_DataType extends AbstractStructBase
{
    /**
     * The Fulfillment_Lead_Time
     * Meta information extracted from the WSDL
     * - documentation: Lead time for the Site/Item combination.
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Fulfillment_Lead_Time;
    /**
     * Constructor method for Fulfillment_Attributes_DataType
     * @uses Fulfillment_Attributes_DataType::setFulfillment_Lead_Time()
     * @param float $fulfillment_Lead_Time
     */
    public function __construct($fulfillment_Lead_Time = null)
    {
        $this
            ->setFulfillment_Lead_Time($fulfillment_Lead_Time);
    }
    /**
     * Get Fulfillment_Lead_Time value
     * @return float|null
     */
    public function getFulfillment_Lead_Time()
    {
        return $this->Fulfillment_Lead_Time;
    }
    /**
     * Set Fulfillment_Lead_Time value
     * @param float $fulfillment_Lead_Time
     * @return \StructType\Fulfillment_Attributes_DataType
     */
    public function setFulfillment_Lead_Time($fulfillment_Lead_Time = null)
    {
        // validation for constraint: float
        if (!is_null($fulfillment_Lead_Time) && !(is_float($fulfillment_Lead_Time) || is_numeric($fulfillment_Lead_Time))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fulfillment_Lead_Time, true), gettype($fulfillment_Lead_Time)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($fulfillment_Lead_Time) && mb_strlen(mb_substr($fulfillment_Lead_Time, false !== mb_strpos($fulfillment_Lead_Time, '.') ? mb_strpos($fulfillment_Lead_Time, '.') + 1 : mb_strlen($fulfillment_Lead_Time))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($fulfillment_Lead_Time, true), mb_strlen(mb_substr($fulfillment_Lead_Time, mb_strpos($fulfillment_Lead_Time, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($fulfillment_Lead_Time) && $fulfillment_Lead_Time < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($fulfillment_Lead_Time, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($fulfillment_Lead_Time) && mb_strlen(preg_replace('/(\D)/', '', $fulfillment_Lead_Time)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($fulfillment_Lead_Time, true), mb_strlen(preg_replace('/(\D)/', '', $fulfillment_Lead_Time))), __LINE__);
        }
        $this->Fulfillment_Lead_Time = $fulfillment_Lead_Time;
        return $this;
    }
}
