<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for External_Business_Entity_ContactType StructType
 * Meta information extracted from the WSDL
 * - documentation: External Business Entity Contact Response Data
 * @subpackage Structs
 */
class External_Business_Entity_ContactType extends AbstractStructBase
{
    /**
     * The Business_Entity_Contact_Reference
     * Meta information extracted from the WSDL
     * - documentation: External Business Entity Contact.
     * - minOccurs: 0
     * @var \StructType\Business_Entity_ContactObjectType
     */
    public $Business_Entity_Contact_Reference;
    /**
     * The External_Business_Entity_Contact_Data
     * Meta information extracted from the WSDL
     * - documentation: External Business Entity Contact Data
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\External_Business_Entity_Contact_DataType[]
     */
    public $External_Business_Entity_Contact_Data;
    /**
     * Constructor method for External_Business_Entity_ContactType
     * @uses External_Business_Entity_ContactType::setBusiness_Entity_Contact_Reference()
     * @uses External_Business_Entity_ContactType::setExternal_Business_Entity_Contact_Data()
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @param \StructType\External_Business_Entity_Contact_DataType[] $external_Business_Entity_Contact_Data
     */
    public function __construct(\StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null, array $external_Business_Entity_Contact_Data = array())
    {
        $this
            ->setBusiness_Entity_Contact_Reference($business_Entity_Contact_Reference)
            ->setExternal_Business_Entity_Contact_Data($external_Business_Entity_Contact_Data);
    }
    /**
     * Get Business_Entity_Contact_Reference value
     * @return \StructType\Business_Entity_ContactObjectType|null
     */
    public function getBusiness_Entity_Contact_Reference()
    {
        return $this->Business_Entity_Contact_Reference;
    }
    /**
     * Set Business_Entity_Contact_Reference value
     * @param \StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference
     * @return \StructType\External_Business_Entity_ContactType
     */
    public function setBusiness_Entity_Contact_Reference(\StructType\Business_Entity_ContactObjectType $business_Entity_Contact_Reference = null)
    {
        $this->Business_Entity_Contact_Reference = $business_Entity_Contact_Reference;
        return $this;
    }
    /**
     * Get External_Business_Entity_Contact_Data value
     * @return \StructType\External_Business_Entity_Contact_DataType[]|null
     */
    public function getExternal_Business_Entity_Contact_Data()
    {
        return $this->External_Business_Entity_Contact_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExternal_Business_Entity_Contact_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExternal_Business_Entity_Contact_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExternal_Business_Entity_Contact_DataForArrayConstraintsFromSetExternal_Business_Entity_Contact_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $external_Business_Entity_ContactTypeExternal_Business_Entity_Contact_DataItem) {
            // validation for constraint: itemType
            if (!$external_Business_Entity_ContactTypeExternal_Business_Entity_Contact_DataItem instanceof \StructType\External_Business_Entity_Contact_DataType) {
                $invalidValues[] = is_object($external_Business_Entity_ContactTypeExternal_Business_Entity_Contact_DataItem) ? get_class($external_Business_Entity_ContactTypeExternal_Business_Entity_Contact_DataItem) : sprintf('%s(%s)', gettype($external_Business_Entity_ContactTypeExternal_Business_Entity_Contact_DataItem), var_export($external_Business_Entity_ContactTypeExternal_Business_Entity_Contact_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The External_Business_Entity_Contact_Data property can only contain items of type \StructType\External_Business_Entity_Contact_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set External_Business_Entity_Contact_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Business_Entity_Contact_DataType[] $external_Business_Entity_Contact_Data
     * @return \StructType\External_Business_Entity_ContactType
     */
    public function setExternal_Business_Entity_Contact_Data(array $external_Business_Entity_Contact_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($external_Business_Entity_Contact_DataArrayErrorMessage = self::validateExternal_Business_Entity_Contact_DataForArrayConstraintsFromSetExternal_Business_Entity_Contact_Data($external_Business_Entity_Contact_Data))) {
            throw new \InvalidArgumentException($external_Business_Entity_Contact_DataArrayErrorMessage, __LINE__);
        }
        $this->External_Business_Entity_Contact_Data = $external_Business_Entity_Contact_Data;
        return $this;
    }
    /**
     * Add item to External_Business_Entity_Contact_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\External_Business_Entity_Contact_DataType $item
     * @return \StructType\External_Business_Entity_ContactType
     */
    public function addToExternal_Business_Entity_Contact_Data(\StructType\External_Business_Entity_Contact_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\External_Business_Entity_Contact_DataType) {
            throw new \InvalidArgumentException(sprintf('The External_Business_Entity_Contact_Data property can only contain items of type \StructType\External_Business_Entity_Contact_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->External_Business_Entity_Contact_Data[] = $item;
        return $this;
    }
}
