<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Expense_Report_Credit_Card_Transactions_DataType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Expense Credit Card Transaction data
 * @subpackage Structs
 */
class Expense_Report_Credit_Card_Transactions_DataType extends AbstractStructBase
{
    /**
     * The Expense_Report_Reference
     * Meta information extracted from the WSDL
     * - documentation: Expense report reference.
     * - minOccurs: 0
     * @var \StructType\Expense_ReportObjectType
     */
    public $Expense_Report_Reference;
    /**
     * The Expense_Report_Number
     * Meta information extracted from the WSDL
     * - documentation: The document number that will be assigned to the expense report. Leave it blank to have the number auto-assigned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Report_Number;
    /**
     * The Expense_Payee_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to the person who the expense report is for.
     * - minOccurs: 0
     * @var \StructType\Expense_PayeeObjectType
     */
    public $Expense_Payee_Reference;
    /**
     * The Expense_Report_Line_Credit_Card_Transaction_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType[]
     */
    public $Expense_Report_Line_Credit_Card_Transaction_Data;
    /**
     * Constructor method for Expense_Report_Credit_Card_Transactions_DataType
     * @uses Expense_Report_Credit_Card_Transactions_DataType::setExpense_Report_Reference()
     * @uses Expense_Report_Credit_Card_Transactions_DataType::setExpense_Report_Number()
     * @uses Expense_Report_Credit_Card_Transactions_DataType::setExpense_Payee_Reference()
     * @uses Expense_Report_Credit_Card_Transactions_DataType::setExpense_Report_Line_Credit_Card_Transaction_Data()
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @param string $expense_Report_Number
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @param \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType[] $expense_Report_Line_Credit_Card_Transaction_Data
     */
    public function __construct(\StructType\Expense_ReportObjectType $expense_Report_Reference = null, $expense_Report_Number = null, \StructType\Expense_PayeeObjectType $expense_Payee_Reference = null, array $expense_Report_Line_Credit_Card_Transaction_Data = array())
    {
        $this
            ->setExpense_Report_Reference($expense_Report_Reference)
            ->setExpense_Report_Number($expense_Report_Number)
            ->setExpense_Payee_Reference($expense_Payee_Reference)
            ->setExpense_Report_Line_Credit_Card_Transaction_Data($expense_Report_Line_Credit_Card_Transaction_Data);
    }
    /**
     * Get Expense_Report_Reference value
     * @return \StructType\Expense_ReportObjectType|null
     */
    public function getExpense_Report_Reference()
    {
        return $this->Expense_Report_Reference;
    }
    /**
     * Set Expense_Report_Reference value
     * @param \StructType\Expense_ReportObjectType $expense_Report_Reference
     * @return \StructType\Expense_Report_Credit_Card_Transactions_DataType
     */
    public function setExpense_Report_Reference(\StructType\Expense_ReportObjectType $expense_Report_Reference = null)
    {
        $this->Expense_Report_Reference = $expense_Report_Reference;
        return $this;
    }
    /**
     * Get Expense_Report_Number value
     * @return string|null
     */
    public function getExpense_Report_Number()
    {
        return $this->Expense_Report_Number;
    }
    /**
     * Set Expense_Report_Number value
     * @param string $expense_Report_Number
     * @return \StructType\Expense_Report_Credit_Card_Transactions_DataType
     */
    public function setExpense_Report_Number($expense_Report_Number = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Report_Number) && !is_string($expense_Report_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Report_Number, true), gettype($expense_Report_Number)), __LINE__);
        }
        $this->Expense_Report_Number = $expense_Report_Number;
        return $this;
    }
    /**
     * Get Expense_Payee_Reference value
     * @return \StructType\Expense_PayeeObjectType|null
     */
    public function getExpense_Payee_Reference()
    {
        return $this->Expense_Payee_Reference;
    }
    /**
     * Set Expense_Payee_Reference value
     * @param \StructType\Expense_PayeeObjectType $expense_Payee_Reference
     * @return \StructType\Expense_Report_Credit_Card_Transactions_DataType
     */
    public function setExpense_Payee_Reference(\StructType\Expense_PayeeObjectType $expense_Payee_Reference = null)
    {
        $this->Expense_Payee_Reference = $expense_Payee_Reference;
        return $this;
    }
    /**
     * Get Expense_Report_Line_Credit_Card_Transaction_Data value
     * @return \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType[]|null
     */
    public function getExpense_Report_Line_Credit_Card_Transaction_Data()
    {
        return $this->Expense_Report_Line_Credit_Card_Transaction_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setExpense_Report_Line_Credit_Card_Transaction_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExpense_Report_Line_Credit_Card_Transaction_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExpense_Report_Line_Credit_Card_Transaction_DataForArrayConstraintsFromSetExpense_Report_Line_Credit_Card_Transaction_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $expense_Report_Credit_Card_Transactions_DataTypeExpense_Report_Line_Credit_Card_Transaction_DataItem) {
            // validation for constraint: itemType
            if (!$expense_Report_Credit_Card_Transactions_DataTypeExpense_Report_Line_Credit_Card_Transaction_DataItem instanceof \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType) {
                $invalidValues[] = is_object($expense_Report_Credit_Card_Transactions_DataTypeExpense_Report_Line_Credit_Card_Transaction_DataItem) ? get_class($expense_Report_Credit_Card_Transactions_DataTypeExpense_Report_Line_Credit_Card_Transaction_DataItem) : sprintf('%s(%s)', gettype($expense_Report_Credit_Card_Transactions_DataTypeExpense_Report_Line_Credit_Card_Transaction_DataItem), var_export($expense_Report_Credit_Card_Transactions_DataTypeExpense_Report_Line_Credit_Card_Transaction_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Expense_Report_Line_Credit_Card_Transaction_Data property can only contain items of type \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Expense_Report_Line_Credit_Card_Transaction_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType[] $expense_Report_Line_Credit_Card_Transaction_Data
     * @return \StructType\Expense_Report_Credit_Card_Transactions_DataType
     */
    public function setExpense_Report_Line_Credit_Card_Transaction_Data(array $expense_Report_Line_Credit_Card_Transaction_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($expense_Report_Line_Credit_Card_Transaction_DataArrayErrorMessage = self::validateExpense_Report_Line_Credit_Card_Transaction_DataForArrayConstraintsFromSetExpense_Report_Line_Credit_Card_Transaction_Data($expense_Report_Line_Credit_Card_Transaction_Data))) {
            throw new \InvalidArgumentException($expense_Report_Line_Credit_Card_Transaction_DataArrayErrorMessage, __LINE__);
        }
        $this->Expense_Report_Line_Credit_Card_Transaction_Data = $expense_Report_Line_Credit_Card_Transaction_Data;
        return $this;
    }
    /**
     * Add item to Expense_Report_Line_Credit_Card_Transaction_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType $item
     * @return \StructType\Expense_Report_Credit_Card_Transactions_DataType
     */
    public function addToExpense_Report_Line_Credit_Card_Transaction_Data(\StructType\Expense_Report_Line_Credit_Card_Transaction_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType) {
            throw new \InvalidArgumentException(sprintf('The Expense_Report_Line_Credit_Card_Transaction_Data property can only contain items of type \StructType\Expense_Report_Line_Credit_Card_Transaction_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Expense_Report_Line_Credit_Card_Transaction_Data[] = $item;
        return $this;
    }
}
