<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Credit_Card_Code_Mapping_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Credit Card Code Mapping Data
 * @subpackage Structs
 */
class Credit_Card_Code_Mapping_DataType extends AbstractStructBase
{
    /**
     * The Expense_Item_ID
     * Meta information extracted from the WSDL
     * - documentation: Expense Item ID
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Expense_Item_ID;
    /**
     * The Merchant_Codes_for_Expense_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Merchant Codes for Expense Item Reference
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Merchant_CodeObjectType[]
     */
    public $Merchant_Codes_for_Expense_Item_Reference;
    /**
     * Constructor method for Credit_Card_Code_Mapping_DataType
     * @uses Credit_Card_Code_Mapping_DataType::setExpense_Item_ID()
     * @uses Credit_Card_Code_Mapping_DataType::setMerchant_Codes_for_Expense_Item_Reference()
     * @param string $expense_Item_ID
     * @param \StructType\Merchant_CodeObjectType[] $merchant_Codes_for_Expense_Item_Reference
     */
    public function __construct($expense_Item_ID = null, array $merchant_Codes_for_Expense_Item_Reference = array())
    {
        $this
            ->setExpense_Item_ID($expense_Item_ID)
            ->setMerchant_Codes_for_Expense_Item_Reference($merchant_Codes_for_Expense_Item_Reference);
    }
    /**
     * Get Expense_Item_ID value
     * @return string|null
     */
    public function getExpense_Item_ID()
    {
        return $this->Expense_Item_ID;
    }
    /**
     * Set Expense_Item_ID value
     * @param string $expense_Item_ID
     * @return \StructType\Credit_Card_Code_Mapping_DataType
     */
    public function setExpense_Item_ID($expense_Item_ID = null)
    {
        // validation for constraint: string
        if (!is_null($expense_Item_ID) && !is_string($expense_Item_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expense_Item_ID, true), gettype($expense_Item_ID)), __LINE__);
        }
        $this->Expense_Item_ID = $expense_Item_ID;
        return $this;
    }
    /**
     * Get Merchant_Codes_for_Expense_Item_Reference value
     * @return \StructType\Merchant_CodeObjectType[]|null
     */
    public function getMerchant_Codes_for_Expense_Item_Reference()
    {
        return $this->Merchant_Codes_for_Expense_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setMerchant_Codes_for_Expense_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMerchant_Codes_for_Expense_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMerchant_Codes_for_Expense_Item_ReferenceForArrayConstraintsFromSetMerchant_Codes_for_Expense_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $credit_Card_Code_Mapping_DataTypeMerchant_Codes_for_Expense_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$credit_Card_Code_Mapping_DataTypeMerchant_Codes_for_Expense_Item_ReferenceItem instanceof \StructType\Merchant_CodeObjectType) {
                $invalidValues[] = is_object($credit_Card_Code_Mapping_DataTypeMerchant_Codes_for_Expense_Item_ReferenceItem) ? get_class($credit_Card_Code_Mapping_DataTypeMerchant_Codes_for_Expense_Item_ReferenceItem) : sprintf('%s(%s)', gettype($credit_Card_Code_Mapping_DataTypeMerchant_Codes_for_Expense_Item_ReferenceItem), var_export($credit_Card_Code_Mapping_DataTypeMerchant_Codes_for_Expense_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Merchant_Codes_for_Expense_Item_Reference property can only contain items of type \StructType\Merchant_CodeObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Merchant_Codes_for_Expense_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Merchant_CodeObjectType[] $merchant_Codes_for_Expense_Item_Reference
     * @return \StructType\Credit_Card_Code_Mapping_DataType
     */
    public function setMerchant_Codes_for_Expense_Item_Reference(array $merchant_Codes_for_Expense_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($merchant_Codes_for_Expense_Item_ReferenceArrayErrorMessage = self::validateMerchant_Codes_for_Expense_Item_ReferenceForArrayConstraintsFromSetMerchant_Codes_for_Expense_Item_Reference($merchant_Codes_for_Expense_Item_Reference))) {
            throw new \InvalidArgumentException($merchant_Codes_for_Expense_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Merchant_Codes_for_Expense_Item_Reference = $merchant_Codes_for_Expense_Item_Reference;
        return $this;
    }
    /**
     * Add item to Merchant_Codes_for_Expense_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Merchant_CodeObjectType $item
     * @return \StructType\Credit_Card_Code_Mapping_DataType
     */
    public function addToMerchant_Codes_for_Expense_Item_Reference(\StructType\Merchant_CodeObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Merchant_CodeObjectType) {
            throw new \InvalidArgumentException(sprintf('The Merchant_Codes_for_Expense_Item_Reference property can only contain items of type \StructType\Merchant_CodeObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Merchant_Codes_for_Expense_Item_Reference[] = $item;
        return $this;
    }
}
