<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company_Industry_Code_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Company Industry Code Data element to specify DUNS number for a company.
 * @subpackage Structs
 */
class Company_Industry_Code_DataType extends AbstractStructBase
{
    /**
     * The Industry_Code_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Company Industry Code Type
     * - minOccurs: 0
     * @var \StructType\Industry_Code_TypeObjectType
     */
    public $Industry_Code_Type_Reference;
    /**
     * The Industry_Code
     * Meta information extracted from the WSDL
     * - documentation: Industry Code Value.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Industry_Code;
    /**
     * Constructor method for Company_Industry_Code_DataType
     * @uses Company_Industry_Code_DataType::setIndustry_Code_Type_Reference()
     * @uses Company_Industry_Code_DataType::setIndustry_Code()
     * @param \StructType\Industry_Code_TypeObjectType $industry_Code_Type_Reference
     * @param string $industry_Code
     */
    public function __construct(\StructType\Industry_Code_TypeObjectType $industry_Code_Type_Reference = null, $industry_Code = null)
    {
        $this
            ->setIndustry_Code_Type_Reference($industry_Code_Type_Reference)
            ->setIndustry_Code($industry_Code);
    }
    /**
     * Get Industry_Code_Type_Reference value
     * @return \StructType\Industry_Code_TypeObjectType|null
     */
    public function getIndustry_Code_Type_Reference()
    {
        return $this->Industry_Code_Type_Reference;
    }
    /**
     * Set Industry_Code_Type_Reference value
     * @param \StructType\Industry_Code_TypeObjectType $industry_Code_Type_Reference
     * @return \StructType\Company_Industry_Code_DataType
     */
    public function setIndustry_Code_Type_Reference(\StructType\Industry_Code_TypeObjectType $industry_Code_Type_Reference = null)
    {
        $this->Industry_Code_Type_Reference = $industry_Code_Type_Reference;
        return $this;
    }
    /**
     * Get Industry_Code value
     * @return string|null
     */
    public function getIndustry_Code()
    {
        return $this->Industry_Code;
    }
    /**
     * Set Industry_Code value
     * @param string $industry_Code
     * @return \StructType\Company_Industry_Code_DataType
     */
    public function setIndustry_Code($industry_Code = null)
    {
        // validation for constraint: string
        if (!is_null($industry_Code) && !is_string($industry_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industry_Code, true), gettype($industry_Code)), __LINE__);
        }
        $this->Industry_Code = $industry_Code;
        return $this;
    }
}
