<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalog_Item_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Catalog Item Request References
 * @subpackage Structs
 */
class Catalog_Item_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Catalog_Item_Reference
     * Meta information extracted from the WSDL
     * - documentation: Catalog Item Reference
     * - maxOccurs: unbounded
     * @var \StructType\Catalog_ItemObjectType[]
     */
    public $Catalog_Item_Reference;
    /**
     * Constructor method for Catalog_Item_Request_ReferencesType
     * @uses Catalog_Item_Request_ReferencesType::setCatalog_Item_Reference()
     * @param \StructType\Catalog_ItemObjectType[] $catalog_Item_Reference
     */
    public function __construct(array $catalog_Item_Reference = array())
    {
        $this
            ->setCatalog_Item_Reference($catalog_Item_Reference);
    }
    /**
     * Get Catalog_Item_Reference value
     * @return \StructType\Catalog_ItemObjectType[]|null
     */
    public function getCatalog_Item_Reference()
    {
        return $this->Catalog_Item_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setCatalog_Item_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCatalog_Item_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCatalog_Item_ReferenceForArrayConstraintsFromSetCatalog_Item_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $catalog_Item_Request_ReferencesTypeCatalog_Item_ReferenceItem) {
            // validation for constraint: itemType
            if (!$catalog_Item_Request_ReferencesTypeCatalog_Item_ReferenceItem instanceof \StructType\Catalog_ItemObjectType) {
                $invalidValues[] = is_object($catalog_Item_Request_ReferencesTypeCatalog_Item_ReferenceItem) ? get_class($catalog_Item_Request_ReferencesTypeCatalog_Item_ReferenceItem) : sprintf('%s(%s)', gettype($catalog_Item_Request_ReferencesTypeCatalog_Item_ReferenceItem), var_export($catalog_Item_Request_ReferencesTypeCatalog_Item_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Catalog_Item_Reference property can only contain items of type \StructType\Catalog_ItemObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Catalog_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_ItemObjectType[] $catalog_Item_Reference
     * @return \StructType\Catalog_Item_Request_ReferencesType
     */
    public function setCatalog_Item_Reference(array $catalog_Item_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($catalog_Item_ReferenceArrayErrorMessage = self::validateCatalog_Item_ReferenceForArrayConstraintsFromSetCatalog_Item_Reference($catalog_Item_Reference))) {
            throw new \InvalidArgumentException($catalog_Item_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Catalog_Item_Reference = $catalog_Item_Reference;
        return $this;
    }
    /**
     * Add item to Catalog_Item_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Catalog_ItemObjectType $item
     * @return \StructType\Catalog_Item_Request_ReferencesType
     */
    public function addToCatalog_Item_Reference(\StructType\Catalog_ItemObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Catalog_ItemObjectType) {
            throw new \InvalidArgumentException(sprintf('The Catalog_Item_Reference property can only contain items of type \StructType\Catalog_ItemObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Catalog_Item_Reference[] = $item;
        return $this;
    }
}
