<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Supplier_Payment_RequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Cancel Supplier Payment Request
 * @subpackage Structs
 */
class Cancel_Supplier_Payment_RequestType extends AbstractStructBase
{
    /**
     * The Supplier_Payment_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Supplier Payment
     * @var \StructType\Supplier_Payment_for_InvoicesObjectType
     */
    public $Supplier_Payment_Reference;
    /**
     * The Reason_for_Cancel
     * Meta information extracted from the WSDL
     * - documentation: Reason for Cancel
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Reason_for_Cancel;
    /**
     * The Void_Check
     * Meta information extracted from the WSDL
     * - documentation: Void Check
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Void_Check;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - ref: wd:version
     * @var string
     */
    public $version;
    /**
     * Constructor method for Cancel_Supplier_Payment_RequestType
     * @uses Cancel_Supplier_Payment_RequestType::setSupplier_Payment_Reference()
     * @uses Cancel_Supplier_Payment_RequestType::setReason_for_Cancel()
     * @uses Cancel_Supplier_Payment_RequestType::setVoid_Check()
     * @uses Cancel_Supplier_Payment_RequestType::setVersion()
     * @param \StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference
     * @param string $reason_for_Cancel
     * @param bool $void_Check
     * @param string $version
     */
    public function __construct(\StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference = null, $reason_for_Cancel = null, $void_Check = null, $version = null)
    {
        $this
            ->setSupplier_Payment_Reference($supplier_Payment_Reference)
            ->setReason_for_Cancel($reason_for_Cancel)
            ->setVoid_Check($void_Check)
            ->setVersion($version);
    }
    /**
     * Get Supplier_Payment_Reference value
     * @return \StructType\Supplier_Payment_for_InvoicesObjectType|null
     */
    public function getSupplier_Payment_Reference()
    {
        return $this->Supplier_Payment_Reference;
    }
    /**
     * Set Supplier_Payment_Reference value
     * @param \StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference
     * @return \StructType\Cancel_Supplier_Payment_RequestType
     */
    public function setSupplier_Payment_Reference(\StructType\Supplier_Payment_for_InvoicesObjectType $supplier_Payment_Reference = null)
    {
        $this->Supplier_Payment_Reference = $supplier_Payment_Reference;
        return $this;
    }
    /**
     * Get Reason_for_Cancel value
     * @return string|null
     */
    public function getReason_for_Cancel()
    {
        return $this->Reason_for_Cancel;
    }
    /**
     * Set Reason_for_Cancel value
     * @param string $reason_for_Cancel
     * @return \StructType\Cancel_Supplier_Payment_RequestType
     */
    public function setReason_for_Cancel($reason_for_Cancel = null)
    {
        // validation for constraint: string
        if (!is_null($reason_for_Cancel) && !is_string($reason_for_Cancel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reason_for_Cancel, true), gettype($reason_for_Cancel)), __LINE__);
        }
        $this->Reason_for_Cancel = $reason_for_Cancel;
        return $this;
    }
    /**
     * Get Void_Check value
     * @return bool|null
     */
    public function getVoid_Check()
    {
        return $this->Void_Check;
    }
    /**
     * Set Void_Check value
     * @param bool $void_Check
     * @return \StructType\Cancel_Supplier_Payment_RequestType
     */
    public function setVoid_Check($void_Check = null)
    {
        // validation for constraint: boolean
        if (!is_null($void_Check) && !is_bool($void_Check)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($void_Check, true), gettype($void_Check)), __LINE__);
        }
        $this->Void_Check = $void_Check;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Cancel_Supplier_Payment_RequestType
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
