<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Cancel_Request_for_Quote_Response_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element to capture the RFQ Response to be canceled along with a Cancellation Memo.
 * @subpackage Structs
 */
class Cancel_Request_for_Quote_Response_DataType extends AbstractStructBase
{
    /**
     * The Cancellation_Memo
     * Meta information extracted from the WSDL
     * - documentation: Element to capture the RFQ Response to be canceled along with a Cancellation Memo.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Cancellation_Memo;
    /**
     * Constructor method for Cancel_Request_for_Quote_Response_DataType
     * @uses Cancel_Request_for_Quote_Response_DataType::setCancellation_Memo()
     * @param string $cancellation_Memo
     */
    public function __construct($cancellation_Memo = null)
    {
        $this
            ->setCancellation_Memo($cancellation_Memo);
    }
    /**
     * Get Cancellation_Memo value
     * @return string|null
     */
    public function getCancellation_Memo()
    {
        return $this->Cancellation_Memo;
    }
    /**
     * Set Cancellation_Memo value
     * @param string $cancellation_Memo
     * @return \StructType\Cancel_Request_for_Quote_Response_DataType
     */
    public function setCancellation_Memo($cancellation_Memo = null)
    {
        // validation for constraint: string
        if (!is_null($cancellation_Memo) && !is_string($cancellation_Memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancellation_Memo, true), gettype($cancellation_Memo)), __LINE__);
        }
        $this->Cancellation_Memo = $cancellation_Memo;
        return $this;
    }
}
