<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Business_Asset_Useful_Life_Update_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Depreciation End Date cannot be prior to depreciation start date of the transaction effective date | The Depreciation End Date and Useful Life Periods must have different values than the current Depreciation End Date and Useful Life.
 * | Depreciation End Date is required and must be different than the current Depreciation End Date. | New useful life periods cannot be less than number of periods already depreciated as of the adjustment date. | Useful Life in Periods is required and
 * must be different than the current Useful Life. | Depreciation End Date must be on or after the Date the Asset is Acquired. | Element contains Business Asset useful life update details
 * @subpackage Structs
 */
class Business_Asset_Useful_Life_Update_DataType extends AbstractStructBase
{
    /**
     * The Adjust_Useful_Life
     * Meta information extracted from the WSDL
     * - documentation: Useful life correction cannot be performed on assets with post acquisition adjustments, life adjustments, impairments, reclassifications, partial disposals or suspended periods | Cannot correct useful life for assets converted from
     * another system into Workday | Indicator to whether to perform Correct Useful Life or Adjust Useful Life. Enter 0 to correct useful life or 1 to adjust useful life
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $Adjust_Useful_Life;
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: Depreciation start date for useful life adjustment cannot be earlier than last resume date. | Adjustment Date cannot be AFTER end date of of the last period in the depreciation schedule | You are entering a useful life adjustment
     * with an EARLIER effective date than an existing cost adjustment or useful life adjustment. | Adjustment Date cannot be less than Depreciation Start Date | Ledger Period must exist for the Adjustment Date. | Transaction effective date of this
     * transaction cannot be prior to last partial disposal date for asset | Adjustment Date is required when the option Adjust Useful Life is 1 (true) | Adjustment Date cannot be less than Date Acquired of the Business Asset | Date of useful life
     * adjustment. Required if value of Useful Life Adjust is 1 or 'y'. Must be blank if Useful Life Adjust is 0 or 'n'.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Useful_Life
     * Meta information extracted from the WSDL
     * - documentation: New value for useful life in periods | Useful Life cannot be more than 200 years. Useful life in years is useful life in periods divided by number of periods in the company's fiscal year. | When depreciation is based on the number of
     * days per period, all the fiscal years / periods for an asset's useful life must already be created in order to calculate the depreciation amount for each period correctly. In order to complete the accounting setup for this asset, you will first need
     * to create additional fiscal years / periods for the fiscal schedule of this asset's company. | The useful life, in periods, for this asset. | The new useful life for reclassification activity. Value is 0 if useful life did not change
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Useful_Life;
    /**
     * The Depreciation_End_Date
     * Meta information extracted from the WSDL
     * - documentation: Fiscal Period must exist for depreciation end date | Update the depreciation end date of contract assets.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Depreciation_End_Date;
    /**
     * The Restricted_to_Books_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to asset books that are used by the asset. Enter asset books if you want to restrict the useful life to specific books. To update useful life for all asset books, leave this field blank.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_BookObjectType[]
     */
    public $Restricted_to_Books_Reference;
    /**
     * Constructor method for Business_Asset_Useful_Life_Update_DataType
     * @uses Business_Asset_Useful_Life_Update_DataType::setAdjust_Useful_Life()
     * @uses Business_Asset_Useful_Life_Update_DataType::setTransaction_Effective_Date()
     * @uses Business_Asset_Useful_Life_Update_DataType::setUseful_Life()
     * @uses Business_Asset_Useful_Life_Update_DataType::setDepreciation_End_Date()
     * @uses Business_Asset_Useful_Life_Update_DataType::setRestricted_to_Books_Reference()
     * @param bool $adjust_Useful_Life
     * @param string $transaction_Effective_Date
     * @param float $useful_Life
     * @param string $depreciation_End_Date
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     */
    public function __construct($adjust_Useful_Life = null, $transaction_Effective_Date = null, $useful_Life = null, $depreciation_End_Date = null, array $restricted_to_Books_Reference = array())
    {
        $this
            ->setAdjust_Useful_Life($adjust_Useful_Life)
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setUseful_Life($useful_Life)
            ->setDepreciation_End_Date($depreciation_End_Date)
            ->setRestricted_to_Books_Reference($restricted_to_Books_Reference);
    }
    /**
     * Get Adjust_Useful_Life value
     * @return bool|null
     */
    public function getAdjust_Useful_Life()
    {
        return $this->Adjust_Useful_Life;
    }
    /**
     * Set Adjust_Useful_Life value
     * @param bool $adjust_Useful_Life
     * @return \StructType\Business_Asset_Useful_Life_Update_DataType
     */
    public function setAdjust_Useful_Life($adjust_Useful_Life = null)
    {
        // validation for constraint: boolean
        if (!is_null($adjust_Useful_Life) && !is_bool($adjust_Useful_Life)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($adjust_Useful_Life, true), gettype($adjust_Useful_Life)), __LINE__);
        }
        $this->Adjust_Useful_Life = $adjust_Useful_Life;
        return $this;
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Business_Asset_Useful_Life_Update_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Useful_Life value
     * @return float|null
     */
    public function getUseful_Life()
    {
        return $this->Useful_Life;
    }
    /**
     * Set Useful_Life value
     * @param float $useful_Life
     * @return \StructType\Business_Asset_Useful_Life_Update_DataType
     */
    public function setUseful_Life($useful_Life = null)
    {
        // validation for constraint: float
        if (!is_null($useful_Life) && !(is_float($useful_Life) || is_numeric($useful_Life))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($useful_Life, true), gettype($useful_Life)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($useful_Life) && mb_strlen(mb_substr($useful_Life, false !== mb_strpos($useful_Life, '.') ? mb_strpos($useful_Life, '.') + 1 : mb_strlen($useful_Life))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($useful_Life, true), mb_strlen(mb_substr($useful_Life, mb_strpos($useful_Life, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($useful_Life) && $useful_Life < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($useful_Life, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($useful_Life) && mb_strlen(preg_replace('/(\D)/', '', $useful_Life)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($useful_Life, true), mb_strlen(preg_replace('/(\D)/', '', $useful_Life))), __LINE__);
        }
        $this->Useful_Life = $useful_Life;
        return $this;
    }
    /**
     * Get Depreciation_End_Date value
     * @return string|null
     */
    public function getDepreciation_End_Date()
    {
        return $this->Depreciation_End_Date;
    }
    /**
     * Set Depreciation_End_Date value
     * @param string $depreciation_End_Date
     * @return \StructType\Business_Asset_Useful_Life_Update_DataType
     */
    public function setDepreciation_End_Date($depreciation_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($depreciation_End_Date) && !is_string($depreciation_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depreciation_End_Date, true), gettype($depreciation_End_Date)), __LINE__);
        }
        $this->Depreciation_End_Date = $depreciation_End_Date;
        return $this;
    }
    /**
     * Get Restricted_to_Books_Reference value
     * @return \StructType\Asset_BookObjectType[]|null
     */
    public function getRestricted_to_Books_Reference()
    {
        return $this->Restricted_to_Books_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setRestricted_to_Books_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestricted_to_Books_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $business_Asset_Useful_Life_Update_DataTypeRestricted_to_Books_ReferenceItem) {
            // validation for constraint: itemType
            if (!$business_Asset_Useful_Life_Update_DataTypeRestricted_to_Books_ReferenceItem instanceof \StructType\Asset_BookObjectType) {
                $invalidValues[] = is_object($business_Asset_Useful_Life_Update_DataTypeRestricted_to_Books_ReferenceItem) ? get_class($business_Asset_Useful_Life_Update_DataTypeRestricted_to_Books_ReferenceItem) : sprintf('%s(%s)', gettype($business_Asset_Useful_Life_Update_DataTypeRestricted_to_Books_ReferenceItem), var_export($business_Asset_Useful_Life_Update_DataTypeRestricted_to_Books_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType[] $restricted_to_Books_Reference
     * @return \StructType\Business_Asset_Useful_Life_Update_DataType
     */
    public function setRestricted_to_Books_Reference(array $restricted_to_Books_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($restricted_to_Books_ReferenceArrayErrorMessage = self::validateRestricted_to_Books_ReferenceForArrayConstraintsFromSetRestricted_to_Books_Reference($restricted_to_Books_Reference))) {
            throw new \InvalidArgumentException($restricted_to_Books_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Restricted_to_Books_Reference = $restricted_to_Books_Reference;
        return $this;
    }
    /**
     * Add item to Restricted_to_Books_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_BookObjectType $item
     * @return \StructType\Business_Asset_Useful_Life_Update_DataType
     */
    public function addToRestricted_to_Books_Reference(\StructType\Asset_BookObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_BookObjectType) {
            throw new \InvalidArgumentException(sprintf('The Restricted_to_Books_Reference property can only contain items of type \StructType\Asset_BookObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restricted_to_Books_Reference[] = $item;
        return $this;
    }
}
