<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: The Request References element contains the specific instance set that should be returned in the Get operation. Either a Reference ID or the Workday ID (GUID) should be specified for each instance to be returned.
 * @subpackage Structs
 */
class Asset_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: References to existing Assets to return data for in the response.
     * - maxOccurs: unbounded
     * @var \StructType\Business_AssetObjectType[]
     */
    public $Asset_Reference;
    /**
     * Constructor method for Asset_Request_ReferencesType
     * @uses Asset_Request_ReferencesType::setAsset_Reference()
     * @param \StructType\Business_AssetObjectType[] $asset_Reference
     */
    public function __construct(array $asset_Reference = array())
    {
        $this
            ->setAsset_Reference($asset_Reference);
    }
    /**
     * Get Asset_Reference value
     * @return \StructType\Business_AssetObjectType[]|null
     */
    public function getAsset_Reference()
    {
        return $this->Asset_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_ReferenceForArrayConstraintsFromSetAsset_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Request_ReferencesTypeAsset_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Request_ReferencesTypeAsset_ReferenceItem instanceof \StructType\Business_AssetObjectType) {
                $invalidValues[] = is_object($asset_Request_ReferencesTypeAsset_ReferenceItem) ? get_class($asset_Request_ReferencesTypeAsset_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Request_ReferencesTypeAsset_ReferenceItem), var_export($asset_Request_ReferencesTypeAsset_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType[] $asset_Reference
     * @return \StructType\Asset_Request_ReferencesType
     */
    public function setAsset_Reference(array $asset_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_ReferenceArrayErrorMessage = self::validateAsset_ReferenceForArrayConstraintsFromSetAsset_Reference($asset_Reference))) {
            throw new \InvalidArgumentException($asset_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Asset_Reference = $asset_Reference;
        return $this;
    }
    /**
     * Add item to Asset_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Business_AssetObjectType $item
     * @return \StructType\Asset_Request_ReferencesType
     */
    public function addToAsset_Reference(\StructType\Business_AssetObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Business_AssetObjectType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Reference property can only contain items of type \StructType\Business_AssetObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Reference[] = $item;
        return $this;
    }
}
