<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Reclassification_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for each time an asset was reclassified. An asset may have more than one reclassification activity.
 * @subpackage Structs
 */
class Asset_Reclassification_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was reclassified
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Item_Descriptor_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the item descriptor
     * - minOccurs: 0
     * @var \StructType\Item_DescriptorObjectType
     */
    public $Item_Descriptor_Reference;
    /**
     * The Spend_Category_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the spend category of the reclassification activity
     * - minOccurs: 0
     * @var \StructType\Spend_CategoryObjectType
     */
    public $Spend_Category_Reference;
    /**
     * The Asset_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the asset type of the reclassification activity
     * - minOccurs: 0
     * @var \StructType\Asset_TypeObjectType
     */
    public $Asset_Type_Reference;
    /**
     * The Asset_Class_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the asset class of the reclassification activity
     * - minOccurs: 0
     * @var \StructType\Asset_ClassObjectType
     */
    public $Asset_Class_Reference;
    /**
     * The Useful_Life
     * Meta information extracted from the WSDL
     * - documentation: New value for useful life in periods | Useful Life cannot be more than 200 years. Useful life in years is useful life in periods divided by number of periods in the company's fiscal year. | When depreciation is based on the number of
     * days per period, all the fiscal years / periods for an asset's useful life must already be created in order to calculate the depreciation amount for each period correctly. In order to complete the accounting setup for this asset, you will first need
     * to create additional fiscal years / periods for the fiscal schedule of this asset's company. | The useful life, in periods, for this asset. | The new useful life for reclassification activity. Value is 0 if useful life did not change
     * - base: xsd:decimal
     * - fractionDigits: 0
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 12
     * @var float
     */
    public $Useful_Life;
    /**
     * Constructor method for Asset_Reclassification_WWS_DataType
     * @uses Asset_Reclassification_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Reclassification_WWS_DataType::setItem_Descriptor_Reference()
     * @uses Asset_Reclassification_WWS_DataType::setSpend_Category_Reference()
     * @uses Asset_Reclassification_WWS_DataType::setAsset_Type_Reference()
     * @uses Asset_Reclassification_WWS_DataType::setAsset_Class_Reference()
     * @uses Asset_Reclassification_WWS_DataType::setUseful_Life()
     * @param string $transaction_Effective_Date
     * @param \StructType\Item_DescriptorObjectType $item_Descriptor_Reference
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @param float $useful_Life
     */
    public function __construct($transaction_Effective_Date = null, \StructType\Item_DescriptorObjectType $item_Descriptor_Reference = null, \StructType\Spend_CategoryObjectType $spend_Category_Reference = null, \StructType\Asset_TypeObjectType $asset_Type_Reference = null, \StructType\Asset_ClassObjectType $asset_Class_Reference = null, $useful_Life = null)
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setItem_Descriptor_Reference($item_Descriptor_Reference)
            ->setSpend_Category_Reference($spend_Category_Reference)
            ->setAsset_Type_Reference($asset_Type_Reference)
            ->setAsset_Class_Reference($asset_Class_Reference)
            ->setUseful_Life($useful_Life);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Reclassification_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Item_Descriptor_Reference value
     * @return \StructType\Item_DescriptorObjectType|null
     */
    public function getItem_Descriptor_Reference()
    {
        return $this->Item_Descriptor_Reference;
    }
    /**
     * Set Item_Descriptor_Reference value
     * @param \StructType\Item_DescriptorObjectType $item_Descriptor_Reference
     * @return \StructType\Asset_Reclassification_WWS_DataType
     */
    public function setItem_Descriptor_Reference(\StructType\Item_DescriptorObjectType $item_Descriptor_Reference = null)
    {
        $this->Item_Descriptor_Reference = $item_Descriptor_Reference;
        return $this;
    }
    /**
     * Get Spend_Category_Reference value
     * @return \StructType\Spend_CategoryObjectType|null
     */
    public function getSpend_Category_Reference()
    {
        return $this->Spend_Category_Reference;
    }
    /**
     * Set Spend_Category_Reference value
     * @param \StructType\Spend_CategoryObjectType $spend_Category_Reference
     * @return \StructType\Asset_Reclassification_WWS_DataType
     */
    public function setSpend_Category_Reference(\StructType\Spend_CategoryObjectType $spend_Category_Reference = null)
    {
        $this->Spend_Category_Reference = $spend_Category_Reference;
        return $this;
    }
    /**
     * Get Asset_Type_Reference value
     * @return \StructType\Asset_TypeObjectType|null
     */
    public function getAsset_Type_Reference()
    {
        return $this->Asset_Type_Reference;
    }
    /**
     * Set Asset_Type_Reference value
     * @param \StructType\Asset_TypeObjectType $asset_Type_Reference
     * @return \StructType\Asset_Reclassification_WWS_DataType
     */
    public function setAsset_Type_Reference(\StructType\Asset_TypeObjectType $asset_Type_Reference = null)
    {
        $this->Asset_Type_Reference = $asset_Type_Reference;
        return $this;
    }
    /**
     * Get Asset_Class_Reference value
     * @return \StructType\Asset_ClassObjectType|null
     */
    public function getAsset_Class_Reference()
    {
        return $this->Asset_Class_Reference;
    }
    /**
     * Set Asset_Class_Reference value
     * @param \StructType\Asset_ClassObjectType $asset_Class_Reference
     * @return \StructType\Asset_Reclassification_WWS_DataType
     */
    public function setAsset_Class_Reference(\StructType\Asset_ClassObjectType $asset_Class_Reference = null)
    {
        $this->Asset_Class_Reference = $asset_Class_Reference;
        return $this;
    }
    /**
     * Get Useful_Life value
     * @return float|null
     */
    public function getUseful_Life()
    {
        return $this->Useful_Life;
    }
    /**
     * Set Useful_Life value
     * @param float $useful_Life
     * @return \StructType\Asset_Reclassification_WWS_DataType
     */
    public function setUseful_Life($useful_Life = null)
    {
        // validation for constraint: float
        if (!is_null($useful_Life) && !(is_float($useful_Life) || is_numeric($useful_Life))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($useful_Life, true), gettype($useful_Life)), __LINE__);
        }
        // validation for constraint: fractionDigits
        if (!is_null($useful_Life) && mb_strlen(mb_substr($useful_Life, false !== mb_strpos($useful_Life, '.') ? mb_strpos($useful_Life, '.') + 1 : mb_strlen($useful_Life))) > 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 0 fraction digits, %d given', var_export($useful_Life, true), mb_strlen(mb_substr($useful_Life, mb_strpos($useful_Life, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($useful_Life) && $useful_Life < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($useful_Life, true)), __LINE__);
        }
        // validation for constraint: totalDigits(12)
        if (!is_null($useful_Life) && mb_strlen(preg_replace('/(\D)/', '', $useful_Life)) > 12) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 12 digits, "%d" given', var_export($useful_Life, true), mb_strlen(preg_replace('/(\D)/', '', $useful_Life))), __LINE__);
        }
        $this->Useful_Life = $useful_Life;
        return $this;
    }
}
