<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Disposal_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data for each time an asset was disposed. An asset may have more than one disposal activity if it was reinstated after a prior disposal.
 * @subpackage Structs
 */
class Asset_Disposal_WWS_DataType extends AbstractStructBase
{
    /**
     * The Transaction_Effective_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was disposed or the transaction effective date of the disposal.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Transaction_Effective_Date;
    /**
     * The Disposal_Cost
     * Meta information extracted from the WSDL
     * - documentation: The cost that was disposed.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Disposal_Cost;
    /**
     * The Disposal_Percent
     * Meta information extracted from the WSDL
     * - documentation: The percent of cost at time of disposal that was disposed. If percent is not 100, disposal is considered partial.
     * - base: xsd:decimal
     * - fractionDigits: 16
     * - maxOccurs: 1
     * - minInclusive: 0
     * - minOccurs: 0
     * - totalDigits: 19
     * @var float
     */
    public $Disposal_Percent;
    /**
     * The Disposal_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the type of disposal
     * - minOccurs: 0
     * @var \StructType\Asset_Disposal_TypeObjectType
     */
    public $Disposal_Type_Reference;
    /**
     * The Disposal_Fair_Market_Value
     * Meta information extracted from the WSDL
     * - documentation: The Disposal Fair Market Value for the Disposal transaction that this Reinstatement is linked to. | The fair market value of the asset at the time it was disposed. | The fair market value of the asset at the time of disposal. | The
     * disposal fair market value entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Disposal_Fair_Market_Value;
    /**
     * The Sale_Price
     * Meta information extracted from the WSDL
     * - documentation: The Disposal Sale Price for the Disposal transaction that this Reinstatement is linked to. | The sale price, if the asset was sold as part of the disposal activity. | The sale price (if the Disposal Type was Sale) when the asset was
     * sold. | The sale price entered has too many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Sale_Price;
    /**
     * The Net_Book_Value_at_Disposal
     * Meta information extracted from the WSDL
     * - documentation: The net book value of the asset at the time it was disposed.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Net_Book_Value_at_Disposal;
    /**
     * The Disposal_Gain
     * Meta information extracted from the WSDL
     * - documentation: The amount gained at disposal versus the asset's cost.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Disposal_Gain;
    /**
     * The Disposal_Loss
     * Meta information extracted from the WSDL
     * - documentation: The amount lost at disposal versus the asset's cost.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Disposal_Loss;
    /**
     * The Donation_Amount
     * Meta information extracted from the WSDL
     * - documentation: The value of the donation of the asset, if applicable.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Donation_Amount;
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comments entered by the user when disposing the asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The Disposal_Worktags_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worktags associated with the asset disposal activity.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Accounting_WorktagObjectType[]
     */
    public $Disposal_Worktags_Reference;
    /**
     * Constructor method for Asset_Disposal_WWS_DataType
     * @uses Asset_Disposal_WWS_DataType::setTransaction_Effective_Date()
     * @uses Asset_Disposal_WWS_DataType::setDisposal_Cost()
     * @uses Asset_Disposal_WWS_DataType::setDisposal_Percent()
     * @uses Asset_Disposal_WWS_DataType::setDisposal_Type_Reference()
     * @uses Asset_Disposal_WWS_DataType::setDisposal_Fair_Market_Value()
     * @uses Asset_Disposal_WWS_DataType::setSale_Price()
     * @uses Asset_Disposal_WWS_DataType::setNet_Book_Value_at_Disposal()
     * @uses Asset_Disposal_WWS_DataType::setDisposal_Gain()
     * @uses Asset_Disposal_WWS_DataType::setDisposal_Loss()
     * @uses Asset_Disposal_WWS_DataType::setDonation_Amount()
     * @uses Asset_Disposal_WWS_DataType::setComment()
     * @uses Asset_Disposal_WWS_DataType::setDisposal_Worktags_Reference()
     * @param string $transaction_Effective_Date
     * @param float $disposal_Cost
     * @param float $disposal_Percent
     * @param \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference
     * @param float $disposal_Fair_Market_Value
     * @param float $sale_Price
     * @param float $net_Book_Value_at_Disposal
     * @param float $disposal_Gain
     * @param float $disposal_Loss
     * @param float $donation_Amount
     * @param string $comment
     * @param \StructType\Accounting_WorktagObjectType[] $disposal_Worktags_Reference
     */
    public function __construct($transaction_Effective_Date = null, $disposal_Cost = null, $disposal_Percent = null, \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference = null, $disposal_Fair_Market_Value = null, $sale_Price = null, $net_Book_Value_at_Disposal = null, $disposal_Gain = null, $disposal_Loss = null, $donation_Amount = null, $comment = null, array $disposal_Worktags_Reference = array())
    {
        $this
            ->setTransaction_Effective_Date($transaction_Effective_Date)
            ->setDisposal_Cost($disposal_Cost)
            ->setDisposal_Percent($disposal_Percent)
            ->setDisposal_Type_Reference($disposal_Type_Reference)
            ->setDisposal_Fair_Market_Value($disposal_Fair_Market_Value)
            ->setSale_Price($sale_Price)
            ->setNet_Book_Value_at_Disposal($net_Book_Value_at_Disposal)
            ->setDisposal_Gain($disposal_Gain)
            ->setDisposal_Loss($disposal_Loss)
            ->setDonation_Amount($donation_Amount)
            ->setComment($comment)
            ->setDisposal_Worktags_Reference($disposal_Worktags_Reference);
    }
    /**
     * Get Transaction_Effective_Date value
     * @return string|null
     */
    public function getTransaction_Effective_Date()
    {
        return $this->Transaction_Effective_Date;
    }
    /**
     * Set Transaction_Effective_Date value
     * @param string $transaction_Effective_Date
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setTransaction_Effective_Date($transaction_Effective_Date = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_Effective_Date) && !is_string($transaction_Effective_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transaction_Effective_Date, true), gettype($transaction_Effective_Date)), __LINE__);
        }
        $this->Transaction_Effective_Date = $transaction_Effective_Date;
        return $this;
    }
    /**
     * Get Disposal_Cost value
     * @return float|null
     */
    public function getDisposal_Cost()
    {
        return $this->Disposal_Cost;
    }
    /**
     * Set Disposal_Cost value
     * @param float $disposal_Cost
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDisposal_Cost($disposal_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($disposal_Cost) && !(is_float($disposal_Cost) || is_numeric($disposal_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disposal_Cost, true), gettype($disposal_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($disposal_Cost) && mb_strlen(mb_substr($disposal_Cost, false !== mb_strpos($disposal_Cost, '.') ? mb_strpos($disposal_Cost, '.') + 1 : mb_strlen($disposal_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($disposal_Cost, true), mb_strlen(mb_substr($disposal_Cost, mb_strpos($disposal_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($disposal_Cost) && mb_strlen(preg_replace('/(\D)/', '', $disposal_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($disposal_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $disposal_Cost))), __LINE__);
        }
        $this->Disposal_Cost = $disposal_Cost;
        return $this;
    }
    /**
     * Get Disposal_Percent value
     * @return float|null
     */
    public function getDisposal_Percent()
    {
        return $this->Disposal_Percent;
    }
    /**
     * Set Disposal_Percent value
     * @param float $disposal_Percent
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDisposal_Percent($disposal_Percent = null)
    {
        // validation for constraint: float
        if (!is_null($disposal_Percent) && !(is_float($disposal_Percent) || is_numeric($disposal_Percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disposal_Percent, true), gettype($disposal_Percent)), __LINE__);
        }
        // validation for constraint: fractionDigits(16)
        if (!is_null($disposal_Percent) && mb_strlen(mb_substr($disposal_Percent, false !== mb_strpos($disposal_Percent, '.') ? mb_strpos($disposal_Percent, '.') + 1 : mb_strlen($disposal_Percent))) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 16 fraction digits, %d given', var_export($disposal_Percent, true), mb_strlen(mb_substr($disposal_Percent, mb_strpos($disposal_Percent, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($disposal_Percent) && $disposal_Percent < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($disposal_Percent, true)), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($disposal_Percent) && mb_strlen(preg_replace('/(\D)/', '', $disposal_Percent)) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($disposal_Percent, true), mb_strlen(preg_replace('/(\D)/', '', $disposal_Percent))), __LINE__);
        }
        $this->Disposal_Percent = $disposal_Percent;
        return $this;
    }
    /**
     * Get Disposal_Type_Reference value
     * @return \StructType\Asset_Disposal_TypeObjectType|null
     */
    public function getDisposal_Type_Reference()
    {
        return $this->Disposal_Type_Reference;
    }
    /**
     * Set Disposal_Type_Reference value
     * @param \StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDisposal_Type_Reference(\StructType\Asset_Disposal_TypeObjectType $disposal_Type_Reference = null)
    {
        $this->Disposal_Type_Reference = $disposal_Type_Reference;
        return $this;
    }
    /**
     * Get Disposal_Fair_Market_Value value
     * @return float|null
     */
    public function getDisposal_Fair_Market_Value()
    {
        return $this->Disposal_Fair_Market_Value;
    }
    /**
     * Set Disposal_Fair_Market_Value value
     * @param float $disposal_Fair_Market_Value
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDisposal_Fair_Market_Value($disposal_Fair_Market_Value = null)
    {
        // validation for constraint: float
        if (!is_null($disposal_Fair_Market_Value) && !(is_float($disposal_Fair_Market_Value) || is_numeric($disposal_Fair_Market_Value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disposal_Fair_Market_Value, true), gettype($disposal_Fair_Market_Value)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($disposal_Fair_Market_Value) && mb_strlen(mb_substr($disposal_Fair_Market_Value, false !== mb_strpos($disposal_Fair_Market_Value, '.') ? mb_strpos($disposal_Fair_Market_Value, '.') + 1 : mb_strlen($disposal_Fair_Market_Value))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($disposal_Fair_Market_Value, true), mb_strlen(mb_substr($disposal_Fair_Market_Value, mb_strpos($disposal_Fair_Market_Value, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($disposal_Fair_Market_Value) && mb_strlen(preg_replace('/(\D)/', '', $disposal_Fair_Market_Value)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($disposal_Fair_Market_Value, true), mb_strlen(preg_replace('/(\D)/', '', $disposal_Fair_Market_Value))), __LINE__);
        }
        $this->Disposal_Fair_Market_Value = $disposal_Fair_Market_Value;
        return $this;
    }
    /**
     * Get Sale_Price value
     * @return float|null
     */
    public function getSale_Price()
    {
        return $this->Sale_Price;
    }
    /**
     * Set Sale_Price value
     * @param float $sale_Price
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setSale_Price($sale_Price = null)
    {
        // validation for constraint: float
        if (!is_null($sale_Price) && !(is_float($sale_Price) || is_numeric($sale_Price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sale_Price, true), gettype($sale_Price)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($sale_Price) && mb_strlen(mb_substr($sale_Price, false !== mb_strpos($sale_Price, '.') ? mb_strpos($sale_Price, '.') + 1 : mb_strlen($sale_Price))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($sale_Price, true), mb_strlen(mb_substr($sale_Price, mb_strpos($sale_Price, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($sale_Price) && mb_strlen(preg_replace('/(\D)/', '', $sale_Price)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($sale_Price, true), mb_strlen(preg_replace('/(\D)/', '', $sale_Price))), __LINE__);
        }
        $this->Sale_Price = $sale_Price;
        return $this;
    }
    /**
     * Get Net_Book_Value_at_Disposal value
     * @return float|null
     */
    public function getNet_Book_Value_at_Disposal()
    {
        return $this->Net_Book_Value_at_Disposal;
    }
    /**
     * Set Net_Book_Value_at_Disposal value
     * @param float $net_Book_Value_at_Disposal
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setNet_Book_Value_at_Disposal($net_Book_Value_at_Disposal = null)
    {
        // validation for constraint: float
        if (!is_null($net_Book_Value_at_Disposal) && !(is_float($net_Book_Value_at_Disposal) || is_numeric($net_Book_Value_at_Disposal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($net_Book_Value_at_Disposal, true), gettype($net_Book_Value_at_Disposal)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($net_Book_Value_at_Disposal) && mb_strlen(mb_substr($net_Book_Value_at_Disposal, false !== mb_strpos($net_Book_Value_at_Disposal, '.') ? mb_strpos($net_Book_Value_at_Disposal, '.') + 1 : mb_strlen($net_Book_Value_at_Disposal))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($net_Book_Value_at_Disposal, true), mb_strlen(mb_substr($net_Book_Value_at_Disposal, mb_strpos($net_Book_Value_at_Disposal, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($net_Book_Value_at_Disposal) && mb_strlen(preg_replace('/(\D)/', '', $net_Book_Value_at_Disposal)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($net_Book_Value_at_Disposal, true), mb_strlen(preg_replace('/(\D)/', '', $net_Book_Value_at_Disposal))), __LINE__);
        }
        $this->Net_Book_Value_at_Disposal = $net_Book_Value_at_Disposal;
        return $this;
    }
    /**
     * Get Disposal_Gain value
     * @return float|null
     */
    public function getDisposal_Gain()
    {
        return $this->Disposal_Gain;
    }
    /**
     * Set Disposal_Gain value
     * @param float $disposal_Gain
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDisposal_Gain($disposal_Gain = null)
    {
        // validation for constraint: float
        if (!is_null($disposal_Gain) && !(is_float($disposal_Gain) || is_numeric($disposal_Gain))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disposal_Gain, true), gettype($disposal_Gain)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($disposal_Gain) && mb_strlen(mb_substr($disposal_Gain, false !== mb_strpos($disposal_Gain, '.') ? mb_strpos($disposal_Gain, '.') + 1 : mb_strlen($disposal_Gain))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($disposal_Gain, true), mb_strlen(mb_substr($disposal_Gain, mb_strpos($disposal_Gain, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($disposal_Gain) && mb_strlen(preg_replace('/(\D)/', '', $disposal_Gain)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($disposal_Gain, true), mb_strlen(preg_replace('/(\D)/', '', $disposal_Gain))), __LINE__);
        }
        $this->Disposal_Gain = $disposal_Gain;
        return $this;
    }
    /**
     * Get Disposal_Loss value
     * @return float|null
     */
    public function getDisposal_Loss()
    {
        return $this->Disposal_Loss;
    }
    /**
     * Set Disposal_Loss value
     * @param float $disposal_Loss
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDisposal_Loss($disposal_Loss = null)
    {
        // validation for constraint: float
        if (!is_null($disposal_Loss) && !(is_float($disposal_Loss) || is_numeric($disposal_Loss))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($disposal_Loss, true), gettype($disposal_Loss)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($disposal_Loss) && mb_strlen(mb_substr($disposal_Loss, false !== mb_strpos($disposal_Loss, '.') ? mb_strpos($disposal_Loss, '.') + 1 : mb_strlen($disposal_Loss))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($disposal_Loss, true), mb_strlen(mb_substr($disposal_Loss, mb_strpos($disposal_Loss, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($disposal_Loss) && mb_strlen(preg_replace('/(\D)/', '', $disposal_Loss)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($disposal_Loss, true), mb_strlen(preg_replace('/(\D)/', '', $disposal_Loss))), __LINE__);
        }
        $this->Disposal_Loss = $disposal_Loss;
        return $this;
    }
    /**
     * Get Donation_Amount value
     * @return float|null
     */
    public function getDonation_Amount()
    {
        return $this->Donation_Amount;
    }
    /**
     * Set Donation_Amount value
     * @param float $donation_Amount
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDonation_Amount($donation_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($donation_Amount) && !(is_float($donation_Amount) || is_numeric($donation_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($donation_Amount, true), gettype($donation_Amount)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($donation_Amount) && mb_strlen(mb_substr($donation_Amount, false !== mb_strpos($donation_Amount, '.') ? mb_strpos($donation_Amount, '.') + 1 : mb_strlen($donation_Amount))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($donation_Amount, true), mb_strlen(mb_substr($donation_Amount, mb_strpos($donation_Amount, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($donation_Amount) && mb_strlen(preg_replace('/(\D)/', '', $donation_Amount)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($donation_Amount, true), mb_strlen(preg_replace('/(\D)/', '', $donation_Amount))), __LINE__);
        }
        $this->Donation_Amount = $donation_Amount;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comment, true), gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get Disposal_Worktags_Reference value
     * @return \StructType\Accounting_WorktagObjectType[]|null
     */
    public function getDisposal_Worktags_Reference()
    {
        return $this->Disposal_Worktags_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setDisposal_Worktags_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisposal_Worktags_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisposal_Worktags_ReferenceForArrayConstraintsFromSetDisposal_Worktags_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Disposal_WWS_DataTypeDisposal_Worktags_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Disposal_WWS_DataTypeDisposal_Worktags_ReferenceItem instanceof \StructType\Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Disposal_WWS_DataTypeDisposal_Worktags_ReferenceItem) ? get_class($asset_Disposal_WWS_DataTypeDisposal_Worktags_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Disposal_WWS_DataTypeDisposal_Worktags_ReferenceItem), var_export($asset_Disposal_WWS_DataTypeDisposal_Worktags_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disposal_Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disposal_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType[] $disposal_Worktags_Reference
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function setDisposal_Worktags_Reference(array $disposal_Worktags_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($disposal_Worktags_ReferenceArrayErrorMessage = self::validateDisposal_Worktags_ReferenceForArrayConstraintsFromSetDisposal_Worktags_Reference($disposal_Worktags_Reference))) {
            throw new \InvalidArgumentException($disposal_Worktags_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Disposal_Worktags_Reference = $disposal_Worktags_Reference;
        return $this;
    }
    /**
     * Add item to Disposal_Worktags_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Disposal_WWS_DataType
     */
    public function addToDisposal_Worktags_Reference(\StructType\Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Disposal_Worktags_Reference property can only contain items of type \StructType\Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disposal_Worktags_Reference[] = $item;
        return $this;
    }
}
