<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Depreciation_Schedule_Additional_InformationType
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing Asset Depreciation Schedule additional information that will not be updated by updated by Update Asset Depreciation
 * @subpackage Structs
 */
class Asset_Depreciation_Schedule_Additional_InformationType extends AbstractStructBase
{
    /**
     * The Asset_Book_Configuration_Status_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the status of the asset book configuration
     * - minOccurs: 0
     * @var \StructType\Document_StatusObjectType
     */
    public $Asset_Book_Configuration_Status_Reference;
    /**
     * The Historical_Cost_Balance
     * Meta information extracted from the WSDL
     * - documentation: A numeric value that represents historical cost balance for depreciation schedule. Historical cost are those transactions with transaction effective date prior to depreciation start date. | The historical cost balance entered has too
     * many digits beyond the decimal point
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Historical_Cost_Balance;
    /**
     * Constructor method for Asset_Depreciation_Schedule_Additional_InformationType
     * @uses Asset_Depreciation_Schedule_Additional_InformationType::setAsset_Book_Configuration_Status_Reference()
     * @uses Asset_Depreciation_Schedule_Additional_InformationType::setHistorical_Cost_Balance()
     * @param \StructType\Document_StatusObjectType $asset_Book_Configuration_Status_Reference
     * @param float $historical_Cost_Balance
     */
    public function __construct(\StructType\Document_StatusObjectType $asset_Book_Configuration_Status_Reference = null, $historical_Cost_Balance = null)
    {
        $this
            ->setAsset_Book_Configuration_Status_Reference($asset_Book_Configuration_Status_Reference)
            ->setHistorical_Cost_Balance($historical_Cost_Balance);
    }
    /**
     * Get Asset_Book_Configuration_Status_Reference value
     * @return \StructType\Document_StatusObjectType|null
     */
    public function getAsset_Book_Configuration_Status_Reference()
    {
        return $this->Asset_Book_Configuration_Status_Reference;
    }
    /**
     * Set Asset_Book_Configuration_Status_Reference value
     * @param \StructType\Document_StatusObjectType $asset_Book_Configuration_Status_Reference
     * @return \StructType\Asset_Depreciation_Schedule_Additional_InformationType
     */
    public function setAsset_Book_Configuration_Status_Reference(\StructType\Document_StatusObjectType $asset_Book_Configuration_Status_Reference = null)
    {
        $this->Asset_Book_Configuration_Status_Reference = $asset_Book_Configuration_Status_Reference;
        return $this;
    }
    /**
     * Get Historical_Cost_Balance value
     * @return float|null
     */
    public function getHistorical_Cost_Balance()
    {
        return $this->Historical_Cost_Balance;
    }
    /**
     * Set Historical_Cost_Balance value
     * @param float $historical_Cost_Balance
     * @return \StructType\Asset_Depreciation_Schedule_Additional_InformationType
     */
    public function setHistorical_Cost_Balance($historical_Cost_Balance = null)
    {
        // validation for constraint: float
        if (!is_null($historical_Cost_Balance) && !(is_float($historical_Cost_Balance) || is_numeric($historical_Cost_Balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($historical_Cost_Balance, true), gettype($historical_Cost_Balance)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($historical_Cost_Balance) && mb_strlen(mb_substr($historical_Cost_Balance, false !== mb_strpos($historical_Cost_Balance, '.') ? mb_strpos($historical_Cost_Balance, '.') + 1 : mb_strlen($historical_Cost_Balance))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($historical_Cost_Balance, true), mb_strlen(mb_substr($historical_Cost_Balance, mb_strpos($historical_Cost_Balance, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($historical_Cost_Balance) && mb_strlen(preg_replace('/(\D)/', '', $historical_Cost_Balance)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($historical_Cost_Balance, true), mb_strlen(preg_replace('/(\D)/', '', $historical_Cost_Balance))), __LINE__);
        }
        $this->Historical_Cost_Balance = $historical_Cost_Balance;
        return $this;
    }
}
