<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Book_RuleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing a reference to an existing asset book and all its asset book rule data
 * @subpackage Structs
 */
class Asset_Book_RuleType extends AbstractStructBase
{
    /**
     * The Asset_Book_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing asset book to which the asset book rule data applies
     * @var \StructType\Asset_BookObjectType
     */
    public $Asset_Book_Reference;
    /**
     * The Asset_Book_Rule_Data
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Asset_Book_Rule_DataType[]
     */
    public $Asset_Book_Rule_Data;
    /**
     * Constructor method for Asset_Book_RuleType
     * @uses Asset_Book_RuleType::setAsset_Book_Reference()
     * @uses Asset_Book_RuleType::setAsset_Book_Rule_Data()
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @param \StructType\Asset_Book_Rule_DataType[] $asset_Book_Rule_Data
     */
    public function __construct(\StructType\Asset_BookObjectType $asset_Book_Reference = null, array $asset_Book_Rule_Data = array())
    {
        $this
            ->setAsset_Book_Reference($asset_Book_Reference)
            ->setAsset_Book_Rule_Data($asset_Book_Rule_Data);
    }
    /**
     * Get Asset_Book_Reference value
     * @return \StructType\Asset_BookObjectType|null
     */
    public function getAsset_Book_Reference()
    {
        return $this->Asset_Book_Reference;
    }
    /**
     * Set Asset_Book_Reference value
     * @param \StructType\Asset_BookObjectType $asset_Book_Reference
     * @return \StructType\Asset_Book_RuleType
     */
    public function setAsset_Book_Reference(\StructType\Asset_BookObjectType $asset_Book_Reference = null)
    {
        $this->Asset_Book_Reference = $asset_Book_Reference;
        return $this;
    }
    /**
     * Get Asset_Book_Rule_Data value
     * @return \StructType\Asset_Book_Rule_DataType[]|null
     */
    public function getAsset_Book_Rule_Data()
    {
        return $this->Asset_Book_Rule_Data;
    }
    /**
     * This method is responsible for validating the values passed to the setAsset_Book_Rule_Data method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAsset_Book_Rule_Data method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAsset_Book_Rule_DataForArrayConstraintsFromSetAsset_Book_Rule_Data(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Book_RuleTypeAsset_Book_Rule_DataItem) {
            // validation for constraint: itemType
            if (!$asset_Book_RuleTypeAsset_Book_Rule_DataItem instanceof \StructType\Asset_Book_Rule_DataType) {
                $invalidValues[] = is_object($asset_Book_RuleTypeAsset_Book_Rule_DataItem) ? get_class($asset_Book_RuleTypeAsset_Book_Rule_DataItem) : sprintf('%s(%s)', gettype($asset_Book_RuleTypeAsset_Book_Rule_DataItem), var_export($asset_Book_RuleTypeAsset_Book_Rule_DataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Asset_Book_Rule_Data property can only contain items of type \StructType\Asset_Book_Rule_DataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Asset_Book_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Book_Rule_DataType[] $asset_Book_Rule_Data
     * @return \StructType\Asset_Book_RuleType
     */
    public function setAsset_Book_Rule_Data(array $asset_Book_Rule_Data = array())
    {
        // validation for constraint: array
        if ('' !== ($asset_Book_Rule_DataArrayErrorMessage = self::validateAsset_Book_Rule_DataForArrayConstraintsFromSetAsset_Book_Rule_Data($asset_Book_Rule_Data))) {
            throw new \InvalidArgumentException($asset_Book_Rule_DataArrayErrorMessage, __LINE__);
        }
        $this->Asset_Book_Rule_Data = $asset_Book_Rule_Data;
        return $this;
    }
    /**
     * Add item to Asset_Book_Rule_Data value
     * @throws \InvalidArgumentException
     * @param \StructType\Asset_Book_Rule_DataType $item
     * @return \StructType\Asset_Book_RuleType
     */
    public function addToAsset_Book_Rule_Data(\StructType\Asset_Book_Rule_DataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Asset_Book_Rule_DataType) {
            throw new \InvalidArgumentException(sprintf('The Asset_Book_Rule_Data property can only contain items of type \StructType\Asset_Book_Rule_DataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Asset_Book_Rule_Data[] = $item;
        return $this;
    }
}
