<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Asset_Acquisition_WWS_DataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains data related to the acquisition or creation of the asset. This includes the date, method, initial cost, and source information.
 * @subpackage Structs
 */
class Asset_Acquisition_WWS_DataType extends AbstractStructBase
{
    /**
     * The Acquisition_Cost
     * Meta information extracted from the WSDL
     * - documentation: The unit acquisition cost of the business asset | The acquisition cost entered has too many digits beyond the decimal point | The initial cost when the asset was acquired.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Acquisition_Cost;
    /**
     * The Acquisition_Date
     * Meta information extracted from the WSDL
     * - documentation: The date the asset was acquired, or the transaction effective date of the acquisition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Acquisition_Date;
    /**
     * The Acquisition_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: A reference to the Acquisition Method this asset was acquired with.
     * - minOccurs: 0
     * @var \StructType\Acquisition_MethodObjectType
     */
    public $Acquisition_Method_Reference;
    /**
     * The PO_Number
     * Meta information extracted from the WSDL
     * - documentation: If this asset was created from a Purchase order, this is the PO Number for that Purchase Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PO_Number;
    /**
     * The Receipt_Number
     * Meta information extracted from the WSDL
     * - documentation: If this asset was created from a Receipt, this is the Receipt number the asset was created from.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Receipt_Number;
    /**
     * The Supplier_Invoice_Number
     * Meta information extracted from the WSDL
     * - documentation: If this asset was created from a Supplier Invoice, this is the Supplier Invoice Number the asset was created from.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Supplier_Invoice_Number;
    /**
     * The Residual_Value_At_Acquisition
     * Meta information extracted from the WSDL
     * - documentation: The residual value at the time of acquisition.
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxOccurs: 1
     * - minOccurs: 0
     * - totalDigits: 26
     * @var float
     */
    public $Residual_Value_At_Acquisition;
    /**
     * The Supplier_Invoice_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: If this asset was created from a Supplier Invoice, this is a reference to the corresponding Supplier Invoice Line.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Supplier_Invoice_Line_AbstractObjectType[]
     */
    public $Supplier_Invoice_Line_Reference;
    /**
     * The Receipt_Line_Reference
     * Meta information extracted from the WSDL
     * - documentation: If this asset was created from a Receipt, this is a reference to the corresponding Receipt Line.
     * - minOccurs: 0
     * @var \StructType\Unique_IdentifierObjectType
     */
    public $Receipt_Line_Reference;
    /**
     * The Transfer_From_Business_Asset_Reference
     * Meta information extracted from the WSDL
     * - documentation: If this asset was created as the result of transfer an existing asset to different company, this is the original source asset that was transferred to create this one.
     * - minOccurs: 0
     * @var \StructType\Business_AssetObjectType
     */
    public $Transfer_From_Business_Asset_Reference;
    /**
     * The Worktag_Reference
     * Meta information extracted from the WSDL
     * - documentation: The worktags specified on the initial acquisition transaction.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Audited_Accounting_WorktagObjectType[]
     */
    public $Worktag_Reference;
    /**
     * The Memo
     * Meta information extracted from the WSDL
     * - documentation: Memo from manual registration.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Memo;
    /**
     * The Project_Number
     * Meta information extracted from the WSDL
     * - documentation: Project number for the business asset.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Project_Number;
    /**
     * The External_Contract_Number
     * Meta information extracted from the WSDL
     * - documentation: External Contract Number from manual registration.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_Number;
    /**
     * The Lease_Accounting_Method_Reference
     * Meta information extracted from the WSDL
     * - documentation: Lease Accounting Method for Leased Asset from Supplier Contract.
     * - minOccurs: 0
     * @var \StructType\Lease_Accounting_MethodObjectType
     */
    public $Lease_Accounting_Method_Reference;
    /**
     * The Supplier_Contract_Type_Reference
     * Meta information extracted from the WSDL
     * - documentation: Supplier Contract Type for Leased Asset from Supplier Contract.
     * - minOccurs: 0
     * @var \StructType\Supplier_Contract_TypeObjectType
     */
    public $Supplier_Contract_Type_Reference;
    /**
     * The External_Contract_Start_Date
     * Meta information extracted from the WSDL
     * - documentation: External Contract Start Date from manual registration.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_Start_Date;
    /**
     * The External_Contract_End_Date
     * Meta information extracted from the WSDL
     * - documentation: External Contract End Date from manual registration.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $External_Contract_End_Date;
    /**
     * Constructor method for Asset_Acquisition_WWS_DataType
     * @uses Asset_Acquisition_WWS_DataType::setAcquisition_Cost()
     * @uses Asset_Acquisition_WWS_DataType::setAcquisition_Date()
     * @uses Asset_Acquisition_WWS_DataType::setAcquisition_Method_Reference()
     * @uses Asset_Acquisition_WWS_DataType::setPO_Number()
     * @uses Asset_Acquisition_WWS_DataType::setReceipt_Number()
     * @uses Asset_Acquisition_WWS_DataType::setSupplier_Invoice_Number()
     * @uses Asset_Acquisition_WWS_DataType::setResidual_Value_At_Acquisition()
     * @uses Asset_Acquisition_WWS_DataType::setSupplier_Invoice_Line_Reference()
     * @uses Asset_Acquisition_WWS_DataType::setReceipt_Line_Reference()
     * @uses Asset_Acquisition_WWS_DataType::setTransfer_From_Business_Asset_Reference()
     * @uses Asset_Acquisition_WWS_DataType::setWorktag_Reference()
     * @uses Asset_Acquisition_WWS_DataType::setMemo()
     * @uses Asset_Acquisition_WWS_DataType::setProject_Number()
     * @uses Asset_Acquisition_WWS_DataType::setExternal_Contract_Number()
     * @uses Asset_Acquisition_WWS_DataType::setLease_Accounting_Method_Reference()
     * @uses Asset_Acquisition_WWS_DataType::setSupplier_Contract_Type_Reference()
     * @uses Asset_Acquisition_WWS_DataType::setExternal_Contract_Start_Date()
     * @uses Asset_Acquisition_WWS_DataType::setExternal_Contract_End_Date()
     * @param float $acquisition_Cost
     * @param string $acquisition_Date
     * @param \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference
     * @param string $pO_Number
     * @param string $receipt_Number
     * @param string $supplier_Invoice_Number
     * @param float $residual_Value_At_Acquisition
     * @param \StructType\Supplier_Invoice_Line_AbstractObjectType[] $supplier_Invoice_Line_Reference
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @param \StructType\Business_AssetObjectType $transfer_From_Business_Asset_Reference
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @param string $memo
     * @param string $project_Number
     * @param string $external_Contract_Number
     * @param \StructType\Lease_Accounting_MethodObjectType $lease_Accounting_Method_Reference
     * @param \StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference
     * @param string $external_Contract_Start_Date
     * @param string $external_Contract_End_Date
     */
    public function __construct($acquisition_Cost = null, $acquisition_Date = null, \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference = null, $pO_Number = null, $receipt_Number = null, $supplier_Invoice_Number = null, $residual_Value_At_Acquisition = null, array $supplier_Invoice_Line_Reference = array(), \StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null, \StructType\Business_AssetObjectType $transfer_From_Business_Asset_Reference = null, array $worktag_Reference = array(), $memo = null, $project_Number = null, $external_Contract_Number = null, \StructType\Lease_Accounting_MethodObjectType $lease_Accounting_Method_Reference = null, \StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference = null, $external_Contract_Start_Date = null, $external_Contract_End_Date = null)
    {
        $this
            ->setAcquisition_Cost($acquisition_Cost)
            ->setAcquisition_Date($acquisition_Date)
            ->setAcquisition_Method_Reference($acquisition_Method_Reference)
            ->setPO_Number($pO_Number)
            ->setReceipt_Number($receipt_Number)
            ->setSupplier_Invoice_Number($supplier_Invoice_Number)
            ->setResidual_Value_At_Acquisition($residual_Value_At_Acquisition)
            ->setSupplier_Invoice_Line_Reference($supplier_Invoice_Line_Reference)
            ->setReceipt_Line_Reference($receipt_Line_Reference)
            ->setTransfer_From_Business_Asset_Reference($transfer_From_Business_Asset_Reference)
            ->setWorktag_Reference($worktag_Reference)
            ->setMemo($memo)
            ->setProject_Number($project_Number)
            ->setExternal_Contract_Number($external_Contract_Number)
            ->setLease_Accounting_Method_Reference($lease_Accounting_Method_Reference)
            ->setSupplier_Contract_Type_Reference($supplier_Contract_Type_Reference)
            ->setExternal_Contract_Start_Date($external_Contract_Start_Date)
            ->setExternal_Contract_End_Date($external_Contract_End_Date);
    }
    /**
     * Get Acquisition_Cost value
     * @return float|null
     */
    public function getAcquisition_Cost()
    {
        return $this->Acquisition_Cost;
    }
    /**
     * Set Acquisition_Cost value
     * @param float $acquisition_Cost
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setAcquisition_Cost($acquisition_Cost = null)
    {
        // validation for constraint: float
        if (!is_null($acquisition_Cost) && !(is_float($acquisition_Cost) || is_numeric($acquisition_Cost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($acquisition_Cost, true), gettype($acquisition_Cost)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($acquisition_Cost) && mb_strlen(mb_substr($acquisition_Cost, false !== mb_strpos($acquisition_Cost, '.') ? mb_strpos($acquisition_Cost, '.') + 1 : mb_strlen($acquisition_Cost))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($acquisition_Cost, true), mb_strlen(mb_substr($acquisition_Cost, mb_strpos($acquisition_Cost, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($acquisition_Cost) && mb_strlen(preg_replace('/(\D)/', '', $acquisition_Cost)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($acquisition_Cost, true), mb_strlen(preg_replace('/(\D)/', '', $acquisition_Cost))), __LINE__);
        }
        $this->Acquisition_Cost = $acquisition_Cost;
        return $this;
    }
    /**
     * Get Acquisition_Date value
     * @return string|null
     */
    public function getAcquisition_Date()
    {
        return $this->Acquisition_Date;
    }
    /**
     * Set Acquisition_Date value
     * @param string $acquisition_Date
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setAcquisition_Date($acquisition_Date = null)
    {
        // validation for constraint: string
        if (!is_null($acquisition_Date) && !is_string($acquisition_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acquisition_Date, true), gettype($acquisition_Date)), __LINE__);
        }
        $this->Acquisition_Date = $acquisition_Date;
        return $this;
    }
    /**
     * Get Acquisition_Method_Reference value
     * @return \StructType\Acquisition_MethodObjectType|null
     */
    public function getAcquisition_Method_Reference()
    {
        return $this->Acquisition_Method_Reference;
    }
    /**
     * Set Acquisition_Method_Reference value
     * @param \StructType\Acquisition_MethodObjectType $acquisition_Method_Reference
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setAcquisition_Method_Reference(\StructType\Acquisition_MethodObjectType $acquisition_Method_Reference = null)
    {
        $this->Acquisition_Method_Reference = $acquisition_Method_Reference;
        return $this;
    }
    /**
     * Get PO_Number value
     * @return string|null
     */
    public function getPO_Number()
    {
        return $this->PO_Number;
    }
    /**
     * Set PO_Number value
     * @param string $pO_Number
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setPO_Number($pO_Number = null)
    {
        // validation for constraint: string
        if (!is_null($pO_Number) && !is_string($pO_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pO_Number, true), gettype($pO_Number)), __LINE__);
        }
        $this->PO_Number = $pO_Number;
        return $this;
    }
    /**
     * Get Receipt_Number value
     * @return string|null
     */
    public function getReceipt_Number()
    {
        return $this->Receipt_Number;
    }
    /**
     * Set Receipt_Number value
     * @param string $receipt_Number
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setReceipt_Number($receipt_Number = null)
    {
        // validation for constraint: string
        if (!is_null($receipt_Number) && !is_string($receipt_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receipt_Number, true), gettype($receipt_Number)), __LINE__);
        }
        $this->Receipt_Number = $receipt_Number;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Number value
     * @return string|null
     */
    public function getSupplier_Invoice_Number()
    {
        return $this->Supplier_Invoice_Number;
    }
    /**
     * Set Supplier_Invoice_Number value
     * @param string $supplier_Invoice_Number
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setSupplier_Invoice_Number($supplier_Invoice_Number = null)
    {
        // validation for constraint: string
        if (!is_null($supplier_Invoice_Number) && !is_string($supplier_Invoice_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplier_Invoice_Number, true), gettype($supplier_Invoice_Number)), __LINE__);
        }
        $this->Supplier_Invoice_Number = $supplier_Invoice_Number;
        return $this;
    }
    /**
     * Get Residual_Value_At_Acquisition value
     * @return float|null
     */
    public function getResidual_Value_At_Acquisition()
    {
        return $this->Residual_Value_At_Acquisition;
    }
    /**
     * Set Residual_Value_At_Acquisition value
     * @param float $residual_Value_At_Acquisition
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setResidual_Value_At_Acquisition($residual_Value_At_Acquisition = null)
    {
        // validation for constraint: float
        if (!is_null($residual_Value_At_Acquisition) && !(is_float($residual_Value_At_Acquisition) || is_numeric($residual_Value_At_Acquisition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($residual_Value_At_Acquisition, true), gettype($residual_Value_At_Acquisition)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($residual_Value_At_Acquisition) && mb_strlen(mb_substr($residual_Value_At_Acquisition, false !== mb_strpos($residual_Value_At_Acquisition, '.') ? mb_strpos($residual_Value_At_Acquisition, '.') + 1 : mb_strlen($residual_Value_At_Acquisition))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($residual_Value_At_Acquisition, true), mb_strlen(mb_substr($residual_Value_At_Acquisition, mb_strpos($residual_Value_At_Acquisition, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(26)
        if (!is_null($residual_Value_At_Acquisition) && mb_strlen(preg_replace('/(\D)/', '', $residual_Value_At_Acquisition)) > 26) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 26 digits, "%d" given', var_export($residual_Value_At_Acquisition, true), mb_strlen(preg_replace('/(\D)/', '', $residual_Value_At_Acquisition))), __LINE__);
        }
        $this->Residual_Value_At_Acquisition = $residual_Value_At_Acquisition;
        return $this;
    }
    /**
     * Get Supplier_Invoice_Line_Reference value
     * @return \StructType\Supplier_Invoice_Line_AbstractObjectType[]|null
     */
    public function getSupplier_Invoice_Line_Reference()
    {
        return $this->Supplier_Invoice_Line_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplier_Invoice_Line_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplier_Invoice_Line_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplier_Invoice_Line_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Line_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Acquisition_WWS_DataTypeSupplier_Invoice_Line_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Acquisition_WWS_DataTypeSupplier_Invoice_Line_ReferenceItem instanceof \StructType\Supplier_Invoice_Line_AbstractObjectType) {
                $invalidValues[] = is_object($asset_Acquisition_WWS_DataTypeSupplier_Invoice_Line_ReferenceItem) ? get_class($asset_Acquisition_WWS_DataTypeSupplier_Invoice_Line_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Acquisition_WWS_DataTypeSupplier_Invoice_Line_ReferenceItem), var_export($asset_Acquisition_WWS_DataTypeSupplier_Invoice_Line_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Supplier_Invoice_Line_Reference property can only contain items of type \StructType\Supplier_Invoice_Line_AbstractObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Supplier_Invoice_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_AbstractObjectType[] $supplier_Invoice_Line_Reference
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setSupplier_Invoice_Line_Reference(array $supplier_Invoice_Line_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($supplier_Invoice_Line_ReferenceArrayErrorMessage = self::validateSupplier_Invoice_Line_ReferenceForArrayConstraintsFromSetSupplier_Invoice_Line_Reference($supplier_Invoice_Line_Reference))) {
            throw new \InvalidArgumentException($supplier_Invoice_Line_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Supplier_Invoice_Line_Reference = $supplier_Invoice_Line_Reference;
        return $this;
    }
    /**
     * Add item to Supplier_Invoice_Line_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Supplier_Invoice_Line_AbstractObjectType $item
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function addToSupplier_Invoice_Line_Reference(\StructType\Supplier_Invoice_Line_AbstractObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Supplier_Invoice_Line_AbstractObjectType) {
            throw new \InvalidArgumentException(sprintf('The Supplier_Invoice_Line_Reference property can only contain items of type \StructType\Supplier_Invoice_Line_AbstractObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Supplier_Invoice_Line_Reference[] = $item;
        return $this;
    }
    /**
     * Get Receipt_Line_Reference value
     * @return \StructType\Unique_IdentifierObjectType|null
     */
    public function getReceipt_Line_Reference()
    {
        return $this->Receipt_Line_Reference;
    }
    /**
     * Set Receipt_Line_Reference value
     * @param \StructType\Unique_IdentifierObjectType $receipt_Line_Reference
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setReceipt_Line_Reference(\StructType\Unique_IdentifierObjectType $receipt_Line_Reference = null)
    {
        $this->Receipt_Line_Reference = $receipt_Line_Reference;
        return $this;
    }
    /**
     * Get Transfer_From_Business_Asset_Reference value
     * @return \StructType\Business_AssetObjectType|null
     */
    public function getTransfer_From_Business_Asset_Reference()
    {
        return $this->Transfer_From_Business_Asset_Reference;
    }
    /**
     * Set Transfer_From_Business_Asset_Reference value
     * @param \StructType\Business_AssetObjectType $transfer_From_Business_Asset_Reference
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setTransfer_From_Business_Asset_Reference(\StructType\Business_AssetObjectType $transfer_From_Business_Asset_Reference = null)
    {
        $this->Transfer_From_Business_Asset_Reference = $transfer_From_Business_Asset_Reference;
        return $this;
    }
    /**
     * Get Worktag_Reference value
     * @return \StructType\Audited_Accounting_WorktagObjectType[]|null
     */
    public function getWorktag_Reference()
    {
        return $this->Worktag_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setWorktag_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorktag_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $asset_Acquisition_WWS_DataTypeWorktag_ReferenceItem) {
            // validation for constraint: itemType
            if (!$asset_Acquisition_WWS_DataTypeWorktag_ReferenceItem instanceof \StructType\Audited_Accounting_WorktagObjectType) {
                $invalidValues[] = is_object($asset_Acquisition_WWS_DataTypeWorktag_ReferenceItem) ? get_class($asset_Acquisition_WWS_DataTypeWorktag_ReferenceItem) : sprintf('%s(%s)', gettype($asset_Acquisition_WWS_DataTypeWorktag_ReferenceItem), var_export($asset_Acquisition_WWS_DataTypeWorktag_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType[] $worktag_Reference
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setWorktag_Reference(array $worktag_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($worktag_ReferenceArrayErrorMessage = self::validateWorktag_ReferenceForArrayConstraintsFromSetWorktag_Reference($worktag_Reference))) {
            throw new \InvalidArgumentException($worktag_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Worktag_Reference = $worktag_Reference;
        return $this;
    }
    /**
     * Add item to Worktag_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\Audited_Accounting_WorktagObjectType $item
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function addToWorktag_Reference(\StructType\Audited_Accounting_WorktagObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Audited_Accounting_WorktagObjectType) {
            throw new \InvalidArgumentException(sprintf('The Worktag_Reference property can only contain items of type \StructType\Audited_Accounting_WorktagObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Worktag_Reference[] = $item;
        return $this;
    }
    /**
     * Get Memo value
     * @return string|null
     */
    public function getMemo()
    {
        return $this->Memo;
    }
    /**
     * Set Memo value
     * @param string $memo
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setMemo($memo = null)
    {
        // validation for constraint: string
        if (!is_null($memo) && !is_string($memo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memo, true), gettype($memo)), __LINE__);
        }
        $this->Memo = $memo;
        return $this;
    }
    /**
     * Get Project_Number value
     * @return string|null
     */
    public function getProject_Number()
    {
        return $this->Project_Number;
    }
    /**
     * Set Project_Number value
     * @param string $project_Number
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setProject_Number($project_Number = null)
    {
        // validation for constraint: string
        if (!is_null($project_Number) && !is_string($project_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($project_Number, true), gettype($project_Number)), __LINE__);
        }
        $this->Project_Number = $project_Number;
        return $this;
    }
    /**
     * Get External_Contract_Number value
     * @return string|null
     */
    public function getExternal_Contract_Number()
    {
        return $this->External_Contract_Number;
    }
    /**
     * Set External_Contract_Number value
     * @param string $external_Contract_Number
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setExternal_Contract_Number($external_Contract_Number = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_Number) && !is_string($external_Contract_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_Number, true), gettype($external_Contract_Number)), __LINE__);
        }
        $this->External_Contract_Number = $external_Contract_Number;
        return $this;
    }
    /**
     * Get Lease_Accounting_Method_Reference value
     * @return \StructType\Lease_Accounting_MethodObjectType|null
     */
    public function getLease_Accounting_Method_Reference()
    {
        return $this->Lease_Accounting_Method_Reference;
    }
    /**
     * Set Lease_Accounting_Method_Reference value
     * @param \StructType\Lease_Accounting_MethodObjectType $lease_Accounting_Method_Reference
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setLease_Accounting_Method_Reference(\StructType\Lease_Accounting_MethodObjectType $lease_Accounting_Method_Reference = null)
    {
        $this->Lease_Accounting_Method_Reference = $lease_Accounting_Method_Reference;
        return $this;
    }
    /**
     * Get Supplier_Contract_Type_Reference value
     * @return \StructType\Supplier_Contract_TypeObjectType|null
     */
    public function getSupplier_Contract_Type_Reference()
    {
        return $this->Supplier_Contract_Type_Reference;
    }
    /**
     * Set Supplier_Contract_Type_Reference value
     * @param \StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setSupplier_Contract_Type_Reference(\StructType\Supplier_Contract_TypeObjectType $supplier_Contract_Type_Reference = null)
    {
        $this->Supplier_Contract_Type_Reference = $supplier_Contract_Type_Reference;
        return $this;
    }
    /**
     * Get External_Contract_Start_Date value
     * @return string|null
     */
    public function getExternal_Contract_Start_Date()
    {
        return $this->External_Contract_Start_Date;
    }
    /**
     * Set External_Contract_Start_Date value
     * @param string $external_Contract_Start_Date
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setExternal_Contract_Start_Date($external_Contract_Start_Date = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_Start_Date) && !is_string($external_Contract_Start_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_Start_Date, true), gettype($external_Contract_Start_Date)), __LINE__);
        }
        $this->External_Contract_Start_Date = $external_Contract_Start_Date;
        return $this;
    }
    /**
     * Get External_Contract_End_Date value
     * @return string|null
     */
    public function getExternal_Contract_End_Date()
    {
        return $this->External_Contract_End_Date;
    }
    /**
     * Set External_Contract_End_Date value
     * @param string $external_Contract_End_Date
     * @return \StructType\Asset_Acquisition_WWS_DataType
     */
    public function setExternal_Contract_End_Date($external_Contract_End_Date = null)
    {
        // validation for constraint: string
        if (!is_null($external_Contract_End_Date) && !is_string($external_Contract_End_Date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($external_Contract_End_Date, true), gettype($external_Contract_End_Date)), __LINE__);
        }
        $this->External_Contract_End_Date = $external_Contract_End_Date;
        return $this;
    }
}
