<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Airport_Request_ReferencesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Element containing reference instances for an Airport object
 * @subpackage Structs
 */
class Airport_Request_ReferencesType extends AbstractStructBase
{
    /**
     * The Airport_Reference
     * Meta information extracted from the WSDL
     * - documentation: Reference to an existing Airport Object
     * - maxOccurs: unbounded
     * @var \StructType\AirportObjectType[]
     */
    public $Airport_Reference;
    /**
     * Constructor method for Airport_Request_ReferencesType
     * @uses Airport_Request_ReferencesType::setAirport_Reference()
     * @param \StructType\AirportObjectType[] $airport_Reference
     */
    public function __construct(array $airport_Reference = array())
    {
        $this
            ->setAirport_Reference($airport_Reference);
    }
    /**
     * Get Airport_Reference value
     * @return \StructType\AirportObjectType[]|null
     */
    public function getAirport_Reference()
    {
        return $this->Airport_Reference;
    }
    /**
     * This method is responsible for validating the values passed to the setAirport_Reference method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirport_Reference method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirport_ReferenceForArrayConstraintsFromSetAirport_Reference(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airport_Request_ReferencesTypeAirport_ReferenceItem) {
            // validation for constraint: itemType
            if (!$airport_Request_ReferencesTypeAirport_ReferenceItem instanceof \StructType\AirportObjectType) {
                $invalidValues[] = is_object($airport_Request_ReferencesTypeAirport_ReferenceItem) ? get_class($airport_Request_ReferencesTypeAirport_ReferenceItem) : sprintf('%s(%s)', gettype($airport_Request_ReferencesTypeAirport_ReferenceItem), var_export($airport_Request_ReferencesTypeAirport_ReferenceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Airport_Reference property can only contain items of type \StructType\AirportObjectType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Airport_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirportObjectType[] $airport_Reference
     * @return \StructType\Airport_Request_ReferencesType
     */
    public function setAirport_Reference(array $airport_Reference = array())
    {
        // validation for constraint: array
        if ('' !== ($airport_ReferenceArrayErrorMessage = self::validateAirport_ReferenceForArrayConstraintsFromSetAirport_Reference($airport_Reference))) {
            throw new \InvalidArgumentException($airport_ReferenceArrayErrorMessage, __LINE__);
        }
        $this->Airport_Reference = $airport_Reference;
        return $this;
    }
    /**
     * Add item to Airport_Reference value
     * @throws \InvalidArgumentException
     * @param \StructType\AirportObjectType $item
     * @return \StructType\Airport_Request_ReferencesType
     */
    public function addToAirport_Reference(\StructType\AirportObjectType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AirportObjectType) {
            throw new \InvalidArgumentException(sprintf('The Airport_Reference property can only contain items of type \StructType\AirportObjectType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Airport_Reference[] = $item;
        return $this;
    }
}
